/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.testFramework.ParsingTestCase;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrCodeInsightFixtureAdapter;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCaseBase;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectFixture;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCodeInsightTestCase
extends OCCodeInsightTestCaseBase<OCMockProjectFixture, CidrExecutionFixture<OCMockProjectFixture>, CidrDebuggingFixture<CidrExecutionFixture<OCMockProjectFixture>>, CidrCodeInsightFixture> {
    public OCCodeInsightTestCase() {
    }

    public OCCodeInsightTestCase(@NlsSafe @NotNull String relativeProjectPath) {
        super(relativeProjectPath);
    }

    public OCCodeInsightTestCase(@Nullable CidrTestProjectDescription testProjectDescription) {
        super(testProjectDescription);
    }

    public OCCodeInsightTestCase(@NlsSafe @NotNull String testFilesPath, @NlsSafe @NotNull String testFilesExtension) {
        super(testFilesPath, testFilesExtension);
    }

    public OCCodeInsightTestCase(@NlsSafe @NotNull String projectRelativePath, @NlsSafe @NotNull String testFilesPath, @NlsSafe @NotNull String testFilesExtension) {
        super(projectRelativePath, testFilesPath, testFilesExtension);
    }

    @Override
    @Nullable
    protected OCMockProjectFixture createProjectFixture() {
        return new OCMockProjectFixture(this.myTestDataFixture);
    }

    @Override
    @Nullable
    protected CidrCodeInsightFixture createCodeInsightFixture() {
        return new CidrCodeInsightFixture(this.myProjectFixture, OCCodeInsightTestCase.createProjectAdapter((OCMockProjectFixture)this.myProjectFixture), this.myTestFilesPath, this.myTestFilesExtension);
    }

    public static CidrCodeInsightFixtureAdapter<OCMockProjectFixture> createProjectAdapter(OCMockProjectFixture fixture) {
        return new CidrCodeInsightFixtureAdapter<OCMockProjectFixture>(fixture){

            @Override
            public void addFileToProject(@NotNull VirtualFile file2) {
                ((OCMockProjectFixture)this.myProjectFixture).updateFirstResolveConfiguration((Consumer<OCResolveConfiguration.ModifiableModel>)((Consumer)model -> ((OCMockProjectFixture)this.myProjectFixture).getMockWorkspace().addSourceFile(file2, null, (OCResolveConfiguration.ModifiableModel)model)));
            }

            @Override
            public void removeFileFromProject(@NotNull VirtualFile file2) {
                ((OCMockProjectFixture)this.myProjectFixture).updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> ((OCMockProjectFixture)this.myProjectFixture).getMockWorkspace().removeSourceFile(file2, (OCWorkspace.ModifiableModel)model)));
            }
        };
    }

    protected void assertTypesEqual(@NotNull OCType type1, OCType type2) {
        OCCodeInsightTestCase.assertTrue((String)String.format("Expected: %s, got %s", type1.getCanonicalName(OCResolveContext.empty((Project)this.getProject())), type2 == null ? "null" : type2.getCanonicalName(OCResolveContext.empty((Project)this.getProject()))), (boolean)type1.equals((Object)type2, OCResolveContext.empty((Project)this.getProject())));
    }

    protected void assertTypeSize(short expectedSizeInBytes, OCType type) {
        Integer actualSize = type == null ? null : Integer.valueOf(type.getSizeInBytes(null, null, this.getProject()));
        OCCodeInsightTestCase.assertTrue((String)String.format("Expected: %s, got %s", expectedSizeInBytes, type == null ? "null" : "sizeof(" + type.getCanonicalName(OCResolveContext.empty((Project)this.getProject())) + ") = " + actualSize), (actualSize != null && actualSize == expectedSizeInBytes ? 1 : 0) != 0);
    }

    protected static boolean isDumb(OCFile ocFile) {
        return SyntaxTraverser.psiTraverser((PsiElement)ocFile).traverse().filter(element -> OCParsing.DUMB_ELEMENT_TYPE.equals(element.getNode().getElementType())).isNotEmpty();
    }

    @Override
    protected <T extends PsiElement> void assertIntention(String check, IntentionAction actionHandler, String result, OCLanguageKind languageKind) {
        this.myAnnotationFixture.assertAction(check, this.myAnnotationFixture.getActionFromIntention(actionHandler), result, languageKind);
    }

    @Override
    protected <T extends PsiElement> void assertActionNotAvailable(String check, IntentionAction actionHandler, OCLanguageKind languageKind) {
        this.myAnnotationFixture.assertActionNotAvailable(check, this.myAnnotationFixture.getActionFromIntention(actionHandler), languageKind);
    }

    protected <T extends PsiElement> void assertActionAvailable(String check, IntentionAction intentionAction, OCLanguageKind languageKind) {
        this.myAnnotationFixture.assertActionAvailable(check, this.myAnnotationFixture.getActionFromIntention(intentionAction), languageKind);
    }

    public static PsiFile reparse(VirtualFile file2, Project project2) {
        FileContentUtil.reparseFiles((Project)project2, Collections.singletonList(file2), (boolean)false);
        FileViewProvider fvp = PsiManager.getInstance((Project)project2).findViewProvider(file2);
        OCCodeInsightTestCase.assertNotNull((Object)fvp);
        PsiFile result = null;
        for (PsiFile psiFile : fvp.getAllFiles()) {
            ParsingTestCase.ensureParsed((PsiFile)psiFile);
            if (psiFile.getLanguage() != OCLanguageUtils.getConfigLanguage()) continue;
            result = psiFile;
        }
        OCCodeInsightTestCase.assertNotNull(result);
        return result;
    }

    @NotNull
    public static LocalInspectionEP createInspectionProfile(@NotNull Class<? extends OCInspection> inspectionClass) {
        LocalInspectionEP inspection = new LocalInspectionEP();
        String name = inspectionClass.getCanonicalName();
        inspection.setPluginDescriptor((PluginDescriptor)new DefaultPluginDescriptor(PluginId.getId((String)"OCCodeInsightTestCase"), OCCodeInsightTestCase.class.getClassLoader()));
        inspection.shortName = InspectionProfileEntry.getShortName((String)StringUtil.getShortName((String)name));
        inspection.displayName = name;
        inspection.groupDisplayName = name;
        inspection.level = "WARNING";
        inspection.enabledByDefault = true;
        inspection.implementationClass = inspectionClass.getName();
        inspection.runForWholeFile = inspectionClass.getSimpleName().matches("OCUnused.*Inspection");
        return inspection;
    }
}

