/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.lang.documentation.ide.IdeDocumentationTargetProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CidrDocumentationFixture {
    @NotNull
    private final Provider myProvider;

    public CidrDocumentationFixture(@NotNull Provider provider) {
        this.myProvider = provider;
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    @Nullable
    public String getDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        return this.myProvider.getDoc(element, originalElement);
    }

    @Nullable
    public String getQuickDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        return this.myProvider.getQuickDoc(element, originalElement);
    }

    public void assertDoc(Pair<PsiElement, PsiElement> es, String ... docFragments) throws Exception {
        this.assertDocForToken(es, ((PsiElement)es.second).getText(), docFragments);
    }

    public void assertDocForToken(Pair<PsiElement, PsiElement> es, String token, String ... docFragments) throws Exception {
        this.assertDoc((PsiElement)es.first, (PsiElement)es.second, token, docFragments);
        this.assertDoc((PsiElement)es.first, null, token, docFragments);
    }

    public void assertDoc(PsiElement element, PsiElement originalElement, String token, String ... docFragments) throws ParserConfigurationException, SAXException, IOException {
        this.assertDoc(element, originalElement, token, true, docFragments);
    }

    public void assertDoc(PsiElement element, PsiElement originalElement, String token, boolean shouldBeValidXML, String ... docFragments) throws ParserConfigurationException, SAXException, IOException {
        this.assertDoc(element, originalElement, token, shouldBeValidXML, true, docFragments);
    }

    public void assertDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement, @Nullable String token, boolean shouldBeValidXML, boolean shouldContainFragments, String ... docFragments) throws ParserConfigurationException, SAXException, IOException {
        String doc = this.myProvider.getDoc(element, originalElement);
        Assert.assertNotNull((Object)doc);
        CidrDocumentationFixture.assertDoc(doc, element, originalElement, token, shouldBeValidXML, shouldContainFragments, docFragments);
    }

    public static void assertDoc(@NotNull String doc, @Nullable PsiElement element, @Nullable PsiElement originalElement, @Nullable String token, boolean shouldBeValidXML, boolean shouldContainFragments, String ... docFragments) throws ParserConfigurationException, SAXException, IOException {
        CidrDocumentationFixture.assertDoc(doc, element, originalElement, token, shouldContainFragments, docFragments);
        if (shouldBeValidXML) {
            CidrDocumentationFixture.assertDocIsWellFormed(doc);
        }
    }

    public static void assertDoc(@NotNull String doc, @Nullable PsiElement element, @Nullable PsiElement originalElement, @Nullable String token, boolean shouldContainFragments, String ... docFragments) {
        Assert.assertNotNull((Object)doc);
        String info = CidrDocumentationFixture.getInfo(element, originalElement);
        if (token != null) {
            Assert.assertTrue((String)(info + "doc does not contain token: \n" + token + "\n\nactual doc:\n" + doc), (boolean)doc.contains(StringUtil.escapeXmlEntities((String)token)));
        }
        for (String docFragment : docFragments) {
            Assert.assertEquals((String)(info + "doc " + (shouldContainFragments ? "does not contain" : "contains") + " fragment:\n" + docFragment + "\n\nactual doc:\n" + doc), (Object)shouldContainFragments, (Object)doc.contains(docFragment));
        }
    }

    @NotNull
    private static String getInfo(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        return "element: " + (element == null ? "null" : element.toString()) + ", original: " + (originalElement == null ? "null" : originalElement.toString()) + "\n";
    }

    private static void assertDocIsWellFormed(@NotNull String doc) throws ParserConfigurationException, SAXException, IOException {
        final String xml = doc.replaceAll("<br>", "<br/>");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newDefaultInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                Assert.fail((String)("doc is not well formed: " + xml + "(" + exception.getLocalizedMessage() + ")"));
            }

            @Override
            public void error(SAXParseException exception) {
                Assert.fail((String)("doc is not well formed: " + xml + "(" + exception.getLocalizedMessage() + ")"));
            }

            @Override
            public void fatalError(SAXParseException exception) {
                Assert.fail((String)("doc is not well formed: " + xml + "(" + exception.getLocalizedMessage() + ")"));
            }
        });
        builder.parse(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    public static Pair<PsiElement, PsiElement> configure(CidrCodeInsightFixture fixture, String code, String fileName) {
        return CidrDocumentationFixture.configure(fixture, code, fileName, true);
    }

    public static Pair<PsiElement, PsiElement> configure(CidrCodeInsightFixture fixture, String code, OCLanguageKind lang, boolean checkElements) {
        return CidrDocumentationFixture.configure(fixture, code, "test." + lang.getDefaultSourceExtension(), checkElements);
    }

    public static Pair<PsiElement, PsiElement> configure(CidrCodeInsightFixture fixture, String code, String fileName, boolean checkElements) {
        Object file2 = fixture.configureByText(code, fileName);
        int caretOffset = fixture.getCaretOffset();
        PsiElement elementAtCaret = fixture.getFile().findElementAt(caretOffset);
        DocumentationManager manager2 = DocumentationManager.getInstance((Project)fixture.getProject());
        PsiElement element = manager2.findTargetElement(fixture.getEditor(), file2);
        if (checkElements) {
            TestCase.assertNotNull((Object)elementAtCaret);
            TestCase.assertNotNull((Object)element);
        }
        return Pair.create((Object)element, (Object)elementAtCaret);
    }

    @NotNull
    public static List<? extends DocumentationTarget> findTargets(@NotNull CidrCodeInsightFixture fixture) {
        return IdeDocumentationTargetProvider.getInstance((Project)fixture.getProject()).documentationTargets(fixture.getEditor(), fixture.getFile(), fixture.getCaretOffset());
    }

    static interface Provider {
        @Nullable
        public String getDoc(@Nullable PsiElement var1, @Nullable PsiElement var2);

        @Nullable
        default public String getQuickDoc(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
            return null;
        }
    }
}

