/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileProjectModelHandler;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNewFileProjectModelHandlerProvider {
    private static final ExtensionPointName<OCNewFileProjectModelHandlerProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.newFileModelHandlerProvider");
    private static final Logger LOG = Logger.getInstance(OCNewFileProjectModelHandlerProvider.class);
    private static final Key<OCNewFileProjectModelHandlerProvider> PROVIDER_KEY = Key.create((String)"NEW_FILE_PROJECT_MODEL_HANDLER_PROVIDER_KEY");

    @NotNull
    public abstract OCNewFileProjectModelHandler createHandler();

    public abstract boolean isAvailable(@NotNull DataContext var1);

    @Nullable
    public static OCNewFileProjectModelHandlerProvider getInstance(@Nullable Project project2) {
        if (project2 == null) {
            return null;
        }
        OCNewFileProjectModelHandlerProvider providerFromUserData = (OCNewFileProjectModelHandlerProvider)project2.getUserData(PROVIDER_KEY);
        if (providerFromUserData != null) {
            return providerFromUserData;
        }
        List providers = ContainerUtil.filter((Collection)EP_NAME.getExtensionList(), p -> p.isApplicable(project2));
        if (providers.size() == 0) {
            LOG.debug("Cannot get OCNewFileProjectModelHandlerProvider: There is no available providers");
            return null;
        }
        if (providers.size() > 1) {
            LOG.error("Cannot get OCNewFileProjectModelHandlerProvider: There are multiple providers available");
            return null;
        }
        OCNewFileProjectModelHandlerProvider provider = (OCNewFileProjectModelHandlerProvider)providers.get(0);
        project2.putUserData(PROVIDER_KEY, (Object)provider);
        return provider;
    }

    protected abstract boolean isApplicable(@NotNull Project var1);
}

