/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.core.CoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.actions.newFile.DialogWrapperFacade;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileProjectModelHandler;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileProjectModelHandlerProvider;
import com.jetbrains.cidr.lang.formatting.CidrFormattingModelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNewFileActionBase<T extends CreateFileDialogBase>
extends CreateInDirectoryActionBase {
    protected static final Logger LOG = Logger.getInstance(OCNewFileActionBase.class);
    public static final Key<FileFactory> FILE_FACTORY = Key.create((String)"FILE_FACTORY");
    protected static final String NAME_TEMPLATE_PROPERTY = "NAME";
    protected static final String HEADER_FILENAME_TEMPLATE_PROPERTY = "HEADER_FILENAME";
    protected static final String CLASS_TEMPLATE_NAME = "Objective-C Class.m";
    protected static final String CPP_CLASS_TEMPLATE_NAME = "C++ Class.cc";
    protected static final String HEADER_TEMPLATE_NAME = "Objective-C Header File.h";
    protected static final String CPP_CLASS_HEADER_TEMPLATE_NAME = "C++ Class Header.h";
    protected static final String C_HEADER_TEMPLATE_NAME = "C Header File.h";
    protected static final String C_SOURCE_TEMPLATE_NAME = "C Source File.c";
    @Nullable
    private final FileType myFileType;
    @NotNull
    private final List<AuxAction> myAuxActions = new ArrayList<AuxAction>();
    @Nullable
    private OCNewFileProjectModelHandler myModelHandler = null;
    private DisposableState<T> myState = null;
    protected String mySelectedName;

    protected OCNewFileActionBase(@Nullable FileType type, @NlsActions.ActionText String text, @NlsActions.ActionDescription String description2, Icon icon) {
        this(type, () -> text, () -> description2, icon);
    }

    protected OCNewFileActionBase(@Nullable FileType type, @NotNull Supplier<@NlsActions.ActionText String> dynamicText, @NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription, Icon icon) {
        super(dynamicText, dynamicDescription, icon);
        this.myFileType = type;
    }

    public static boolean isNewFileActionSupported(@Nullable Project project2) {
        return OCNewFileProjectModelHandlerProvider.getInstance(project2) != null;
    }

    public void addAuxAction(@NotNull AuxAction action) {
        this.myAuxActions.add(action);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext) || !this.isAvailable()) {
            return false;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        OCNewFileProjectModelHandlerProvider provider = OCNewFileProjectModelHandlerProvider.getInstance(project2);
        return provider != null && provider.isAvailable(dataContext);
    }

    protected boolean isAvailable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null || !this.isAvailable() || !this.initModelHandlerFromDataContext(dataContext)) {
            return;
        }
        try {
            PsiDirectory[] directories = view.getDirectories();
            DisposableState<T> state = new DisposableState<T>((PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext), e.getProject(), directories.length == 1 ? directories[0] : null, this.createDialog(this.getDefaultName()));
            this.setState(state);
            PsiFile[] createdElements = this.invokeDialog(this.myState.project, dataContext);
            if (createdElements != null) {
                this.selectResult(view, createdElements);
            }
        }
        finally {
            this.setState(null);
        }
    }

    public DisposableState<T> getState() {
        return this.myState;
    }

    public void setState(DisposableState<T> state) {
        this.myState = state;
    }

    protected void selectResult(@NotNull IdeView view, PsiFile @NotNull [] createdElements) {
        for (PsiFile createdElement : createdElements) {
            view.selectElement((PsiElement)createdElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiFile @Nullable [] performAction(Project project2, PsiDirectory directory, @NotNull PsiFile file2, @Nullable String name) {
        if (project2 == null || directory == null || !this.initModelHandlerFromFile(file2)) {
            return null;
        }
        try {
            this.setState(new DisposableState<T>(file2, project2, directory, this.createDialog(name != null ? name : this.getDefaultName())));
            PsiFile[] createdElements = this.invokeDialog(project2, null);
            if (createdElements != null) {
                this.openCreatedFiles(createdElements);
                PsiFile[] psiFileArray = createdElements;
                return psiFileArray;
            }
            PsiFile[] psiFileArray = null;
            return psiFileArray;
        }
        finally {
            this.setState(null);
        }
    }

    public PsiFile @Nullable [] performActionWithoutDialog(String name, @NotNull PsiFile sampleFile, boolean unifyName) {
        VirtualFile virtualFile = sampleFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Object uniqueName = name;
        int i = 1;
        while (true) {
            boolean wasCollision = false;
            for (String fileName : this.getNewFileNames((String)uniqueName, sampleFile).getNames()) {
                if (virtualFile.getParent().findChild(fileName) == null) continue;
                wasCollision = true;
                break;
            }
            if (!wasCollision) break;
            int extensionPos = name.lastIndexOf(46);
            uniqueName = extensionPos != -1 ? name.substring(0, extensionPos) + i + name.substring(extensionPos) : name + i;
            ++i;
        }
        if (!unifyName && uniqueName != name) {
            return null;
        }
        return this.performAction(sampleFile.getProject(), virtualFile.getPath(), name, (String)uniqueName, null, sampleFile);
    }

    protected void openCreatedFiles(PsiFile @NotNull [] createdElements) {
        for (PsiFile element : createdElements) {
            EditorHelper.openInEditor((PsiElement)element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiFile[] invokeDialog(Project project2, @Nullable DataContext dataContext) {
        try {
            LOG.assertTrue(this.myModelHandler != null);
            DialogWrapper dialog = this.myModelHandler.createDialog((CreateFileDialogBase)((Object)this.myState.dialogPeer), this.myState.selectedDir, dataContext);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                String selectedName = ((CreateFileDialogBase)((Object)this.myState.dialogPeer)).getSelectedName();
                PsiFile[] psiFileArray = this.performAction(project2, ((CreateFileDialogBase)((Object)this.myState.dialogPeer)).getSelectedPath(), selectedName, selectedName, dialog, null);
                return psiFileArray;
            }
            PsiFile[] psiFileArray = null;
            return psiFileArray;
        }
        finally {
            this.myAuxActions.clear();
        }
    }

    @NotNull
    private static String removeEmptyLinesFromEnd(@NotNull String text) {
        boolean addNewLine = text.endsWith("\n");
        return StringUtil.trimTrailing((String)text) + (addNewLine ? "\n" : "");
    }

    protected PsiFile @Nullable [] performAction(Project project2, String path, String name, String fileName, DialogWrapper dialog, @Nullable PsiFile sampleFile) {
        CreateFilesStatus status;
        PsiDirectory parentDirectory;
        List<String> fileNames;
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project2);
        if (this.myState != null) {
            fileNames = this.getNewFileNames(fileName).getNames();
            parentDirectory = this.myState.selectedDir;
        } else {
            LOG.assertTrue(sampleFile != null);
            fileNames = this.getNewFileNames(fileName, sampleFile).getNames();
            parentDirectory = sampleFile.getContainingDirectory();
        }
        if (sampleFile != null) {
            this.initModelHandlerFromFile(sampleFile);
        }
        PsiFile[] resultElements = new PsiFile[fileNames.size()];
        String dirPath = FileTemplateUtil.getDirPathRelativeToProjectBaseDir((PsiDirectory)parentDirectory);
        for (int i = 0; i < fileNames.size(); ++i) {
            List words;
            String filename = fileNames.get(i);
            String fileTemplate = this.getFileTemplate(filename);
            FileTemplate template = this.loadFileTemplate(fileTemplate, project2);
            this.mySelectedName = name;
            Properties properties = new Properties(FileTemplateManager.getInstance((Project)project2).getDefaultProperties());
            FileTemplateUtil.fillDefaultProperties((Properties)properties, (PsiDirectory)parentDirectory);
            if (template != null) {
                CreateFromTemplateHandler handler = FileTemplateUtil.findHandler((FileTemplate)template);
                HashMap<String, String> map2 = new HashMap<String, String>();
                map2.put("FILE_PATH", FileUtil.join((String[])new String[]{path, filename}));
                if (dirPath != null) {
                    map2.put("DIR_PATH", dirPath);
                }
                handler.prepareProperties(map2, filename, template, project2);
                handler.prepareProperties(map2);
                properties.putAll((Map<?, ?>)map2);
            }
            properties.setProperty(NAME_TEMPLATE_PROPERTY, (words = StringUtil.getWordsIn((String)this.mySelectedName)).isEmpty() ? this.mySelectedName : (String)words.get(0));
            if (this.myModelHandler != null) {
                this.myModelHandler.setProperties(dialog, properties, sampleFile, project2);
            }
            this.setAdditionalProperties(properties, filename, sampleFile, project2);
            FileFactory factory = OCNewFileActionBase.getFileFactory(project2);
            try {
                String classText;
                String string = classText = template != null ? OCNewFileActionBase.removeEmptyLinesFromEnd(template.getText(properties)) : "";
                if (classText.isEmpty()) continue;
                resultElements[i] = factory.createFileFromText(filename, this.myFileType, classText);
                continue;
            }
            catch (Exception e) {
                if (fileTemplate == null) continue;
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(fileTemplate)), e);
            }
        }
        boolean useHelperAndCreateFiles = this.myModelHandler != null && !ApplicationManager.getApplication().isUnitTestMode();
        Supplier<PsiFile[]> elementsSupplier = () -> ContainerUtil.mapNotNull((Object[])resultElements, it -> PsiManager.getInstance((Project)project2).findFile(it.getVirtualFile())).toArray(PsiFile.EMPTY_ARRAY);
        try {
            CidrFormattingModelBuilder.requestAlwaysCreateFullModel();
            status = (CreateFilesStatus)((Object)WriteCommandAction.writeCommandAction((Project)project2).withName(CidrLangBundle.message("action.new.file.creation", new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(() -> {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                if (useHelperAndCreateFiles) {
                    VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
                    if (dir == null) {
                        dir = VfsUtil.createDirectoryIfMissing((String)path);
                    }
                    if (dir == null) {
                        return CreateFilesStatus.DIR_CREATION_FAILED;
                    }
                    if (!dir.isWritable()) {
                        return CreateFilesStatus.DIR_IS_READ_ONLY;
                    }
                    PsiDirectory directory = PsiManager.getInstance((Project)project2).findDirectory(dir.isDirectory() ? dir : dir.getParent());
                    LOG.assertTrue(directory != null);
                    try {
                        this.myModelHandler.doCreateFiles(project2, directory, ArrayUtilRt.toStringArray((Collection)fileNames), resultElements, dialog, sampleFile);
                    }
                    catch (IncorrectOperationException ex) {
                        return CreateFilesStatus.GENERIC_FAILURE;
                    }
                }
                PsiFile[] restoredElements = (PsiFile[])elementsSupplier.get();
                for (AuxAction action2 : this.myAuxActions) {
                    if (!action2.executeUnderWriteAction()) continue;
                    action2.run(restoredElements);
                }
                this.myAuxActions.removeIf(action -> action.executeUnderWriteAction());
                return CreateFilesStatus.SUCCESS;
            }));
            if (status == CreateFilesStatus.SUCCESS) {
                PsiFile[] restoredElements = elementsSupplier.get();
                for (AuxAction action : this.myAuxActions) {
                    if (action.executeUnderWriteAction()) continue;
                    action.run(restoredElements);
                }
                this.myAuxActions.clear();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            CidrFormattingModelBuilder.releaseAlwaysCreateFullModel();
        }
        switch (status) {
            case DIR_CREATION_FAILED: {
                Messages.showErrorDialog((String)CidrLangBundle.message("create.directory.failed.message", path), (String)CidrLangBundle.message("create.directory.failed", new Object[0]));
                return null;
            }
            case DIR_IS_READ_ONLY: {
                Messages.showErrorDialog((Project)project2, (String)CoreBundle.message((String)"cannot.modify.a.read.only.directory", (Object[])new Object[]{path}), (String)IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]));
                return null;
            }
            case GENERIC_FAILURE: {
                Messages.showErrorDialog((Project)project2, (String)CidrLangBundle.message("create.error.files.in.directory", StringUtil.join(fileNames, (String)"; "), path), (String)IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]));
                return null;
            }
        }
        return resultElements;
    }

    protected FileTemplate loadFileTemplate(String fileTemplateName, Project project2) {
        FileTemplateManager ftm = FileTemplateManager.getInstance((Project)project2);
        return fileTemplateName != null ? ftm.getInternalTemplate(fileTemplateName) : null;
    }

    private static FileFactory getFileFactory(final Project project2) {
        FileFactory factory = (FileFactory)project2.getUserData(FILE_FACTORY);
        return factory != null ? factory : new FileFactory(){

            @Override
            public PsiFile createFileFromText(@NotNull String fileName, @Nullable FileType fileType, @NotNull String text) {
                PsiFileFactory f = PsiFileFactory.getInstance((Project)project2);
                return fileType == null ? f.createFileFromText(fileName, text) : f.createFileFromText(fileName, fileType, (CharSequence)text);
            }
        };
    }

    protected void setAdditionalProperties(Properties properties, String fileName, @Nullable PsiFile sampleFile, Project project2) {
    }

    @Nullable
    protected abstract String getFileTemplate(String var1);

    @NotNull
    protected abstract NewFileNames getNewFileNames(String var1);

    @NotNull
    protected NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        return this.getNewFileNames(selectedName);
    }

    @NlsSafe
    @NotNull
    protected String getDefaultName() {
        return "";
    }

    @NotNull
    protected String getDefaultClassPrefix() {
        return this.myModelHandler != null ? this.myModelHandler.getDefaultClassPrefix() : "";
    }

    protected boolean isValidName(@NotNull String selectedName) {
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @NotNull
    protected abstract T createDialog(@NotNull String var1);

    private boolean initModelHandlerFromDataContext(@NotNull DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        this.createHandler(project2);
        if (this.myModelHandler == null) {
            return false;
        }
        return this.myModelHandler.initFromDataContext(dataContext);
    }

    private boolean initModelHandlerFromFile(@NotNull PsiFile file2) {
        this.createHandler(file2.getProject());
        if (this.myModelHandler == null) {
            return false;
        }
        return this.myModelHandler.initFromFile(file2);
    }

    private void createHandler(@Nullable Project project2) {
        OCNewFileProjectModelHandlerProvider provider = OCNewFileProjectModelHandlerProvider.getInstance(project2);
        this.myModelHandler = provider != null ? provider.createHandler() : null;
    }

    public class CreateFileDialogBase
    extends DialogWrapper {
        public static final String NAME_SELECTION_START_TAG = "<@!selection!@>";
        @NotNull
        private final @NlsContexts.Label String myNameFieldTitle;
        private final String myDefaultName;
        protected JTextField myNameField;
        protected TextFieldWithBrowseButton myLocationField;
        private boolean myLocationWasManuallyChanged;
        private DialogWrapperFacade myWrapper;
        @Nullable
        private final String myHelpId;

        public CreateFileDialogBase(@NlsContexts.Label String title, @Nullable String defaultName, String helpId) {
            this(title, CidrLangBundle.message("create.field.name", new Object[0]), defaultName, helpId);
        }

        public CreateFileDialogBase(@NotNull @NlsContexts.Label String title, String nameFieldTitle, @Nullable String defaultName, String helpId) {
            super(false);
            this.myDefaultName = defaultName;
            this.myNameFieldTitle = nameFieldTitle;
            this.myHelpId = helpId;
            this.setTitle(title);
            this.init();
        }

        @Nullable
        public String getHelpId() {
            return this.myHelpId;
        }

        @Nullable
        public String getSelectedPath() {
            return this.myLocationField.getText();
        }

        @NotNull
        public String getSelectedName() {
            return this.myNameField.getText();
        }

        public PsiDirectory getSelectedDir() {
            return OCNewFileActionBase.this.myState.selectedDir;
        }

        public void setSelectedDir(PsiDirectory selectedDir) {
            assert (OCNewFileActionBase.this.myState != null);
            OCNewFileActionBase.this.setState(new DisposableState(OCNewFileActionBase.this.myState.selectedFile, OCNewFileActionBase.this.myState.project, selectedDir, OCNewFileActionBase.this.myState.dialogPeer));
        }

        public TextFieldWithBrowseButton getLocationField() {
            return this.myLocationField;
        }

        public boolean isLocationWasManuallyChanged() {
            return this.myLocationWasManuallyChanged;
        }

        public void setLocationWasManuallyChanged(boolean locationWasManuallyChanged) {
            this.myLocationWasManuallyChanged = locationWasManuallyChanged;
        }

        public final void validateOkAction() {
            String error = this.collectOkActionErrors();
            this.setErrorText(null);
            this.setOKActionEnabled(error == null);
            if (!StringUtil.isEmptyOrSpaces((String)error)) {
                this.setErrorText(error);
            }
        }

        @Nullable
        @NlsContexts.DialogMessage
        protected String collectOkActionErrors() {
            VirtualFile file2;
            String selectedName = this.getSelectedName();
            if (StringUtil.isEmptyOrSpaces((String)selectedName)) {
                return "";
            }
            if (!this.isValidName(selectedName)) {
                return CidrLangBundle.message("create.error.invalid.name", selectedName);
            }
            if (StringUtil.isEmpty((String)this.myLocationField.getText())) {
                return "";
            }
            String path = this.getSelectedPath();
            VirtualFile virtualFile = file2 = path == null ? null : LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null || !file2.isDirectory()) {
                return CidrLangBundle.message("create.error.missing.target.dir", new Object[0]);
            }
            @NlsContexts.DialogMessage StringBuilder errors = new StringBuilder();
            for (String filename : OCNewFileActionBase.this.getNewFileNames(selectedName).getNames()) {
                VirtualFile child = file2.findChild(filename);
                if (child == null) continue;
                if (child.isDirectory()) {
                    errors.append(CidrLangBundle.message("create.error.dir.exists", filename)).append("<br>");
                    continue;
                }
                errors.append(CidrLangBundle.message("create.error.file.exists", filename)).append("<br>");
            }
            return errors.length() > 0 ? errors.toString() : null;
        }

        public void setWrapper(DialogWrapperFacade wrapper) {
            this.myWrapper = wrapper;
        }

        public void setOKActionEnabled(boolean isEnabled2) {
            if (this.myWrapper == null) {
                super.setOKActionEnabled(isEnabled2);
            } else {
                this.myWrapper.setOKEnabled(isEnabled2);
            }
        }

        protected void setErrorText(@Nullable String text, @Nullable JComponent component) {
            if (this.myWrapper == null) {
                super.setErrorText(text, component);
            } else {
                this.myWrapper.setErrorMessage(text);
            }
        }

        protected boolean areControlsConsistent() {
            return true;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new JPanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myNameField;
        }

        public boolean checkCanDoOKAction() {
            if (!this.areControlsConsistent()) {
                ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myNameField, true)));
                return false;
            }
            return true;
        }

        protected void doOKAction() {
            if (this.checkCanDoOKAction()) {
                super.doOKAction();
            }
        }

        public void fillGenericControls(FormBuilder formBuilder) {
            this.addNameField(formBuilder);
            this.addLocationField(formBuilder);
        }

        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, false);
        }

        protected final void addNameField(FormBuilder formBuilder, boolean withUpDownHint) {
            Object name;
            int selectionStart = this.myDefaultName.indexOf(NAME_SELECTION_START_TAG);
            if (selectionStart < 0) {
                selectionStart = 0;
                name = this.myDefaultName;
            } else {
                name = this.myDefaultName.substring(0, selectionStart) + this.myDefaultName.substring(selectionStart + NAME_SELECTION_START_TAG.length());
            }
            this.myNameField = new JTextField();
            this.myNameField.setText((String)name);
            this.myNameField.setMinimumSize(new Dimension(250, this.myNameField.getPreferredSize().height));
            final NameFocusListener focusListener = new NameFocusListener(selectionStart);
            this.myNameField.addFocusListener(focusListener);
            this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    CreateFileDialogBase.this.validateOkAction();
                    focusListener.resetSelectionStart();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
            JComponent nameFieldComponent = this.myNameField;
            if (withUpDownHint) {
                JPanel panel = new JPanel(new BorderLayout(5, 0));
                panel.add((Component)this.myNameField, "Center");
                JLabel hint = new JLabel(AllIcons.Ide.UpDown);
                hint.setToolTipText(CidrLangBundle.message("create.tooltip.arrows.type", new Object[0]));
                panel.add((Component)hint, "East");
                nameFieldComponent = panel;
            }
            formBuilder.addLabeledComponent(this.myNameFieldTitle, nameFieldComponent);
            this.myNameField.setEnabled(this.isNameFieldEnabled());
        }

        protected final void addLocationField(FormBuilder formBuilder) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            FileTextField field = FileChooserFactory.getInstance().createFileTextField(descriptor, this.myDisposable);
            field.getField().setColumns(25);
            this.myLocationField = new TextFieldWithBrowseButton(field.getField());
            this.myLocationField.addBrowseFolderListener(CidrLangBundle.message("create.folder.dialog.title", new Object[0]), CidrLangBundle.message("create.folder.dialog.description", new Object[0]), OCNewFileActionBase.this.myState.project, descriptor);
            if (OCNewFileActionBase.this.myState != null && OCNewFileActionBase.this.myState.selectedDir != null) {
                this.myLocationField.setText(OCNewFileActionBase.this.myState.selectedDir.getVirtualFile().getPath());
            }
            field.getField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CreateFileDialogBase.this.validateOkAction();
                    CreateFileDialogBase.this.myLocationWasManuallyChanged = true;
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CreateFileDialogBase.this.validateOkAction();
                    CreateFileDialogBase.this.myLocationWasManuallyChanged = e.getDocument().getLength() != 0;
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            if (OCNewFileActionBase.this.myModelHandler != null && OCNewFileActionBase.this.myModelHandler.canChangeDir()) {
                formBuilder.addLabeledComponent(CidrLangBundle.message("create.field.location", new Object[0]), (JComponent)this.myLocationField);
            } else {
                LOG.assertTrue(!this.myLocationField.getText().isEmpty());
            }
        }

        private boolean isValidName(@NotNull String selectedName) {
            return OCNewFileActionBase.this.isValidName(selectedName);
        }

        protected boolean isNameFieldEnabled() {
            return true;
        }

        private class NameFocusListener
        implements FocusListener {
            private int mySelectionStart;

            NameFocusListener(int selectionStart) {
                this.mySelectionStart = selectionStart;
            }

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (this.mySelectionStart == -1) {
                    return;
                }
                CreateFileDialogBase.this.myNameField.setCaretPosition(this.mySelectionStart);
                CreateFileDialogBase.this.myNameField.moveCaretPosition(CreateFileDialogBase.this.myNameField.getText().length());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
            }

            public void resetSelectionStart() {
                this.mySelectionStart = -1;
            }
        }
    }

    public static class NewFileNames {
        @Nullable
        private final String mySourceName;
        @Nullable
        private final String myHeaderName;
        @Nullable
        private final List<String> myOtherNames;

        public NewFileNames(@Nullable String sourceName, @Nullable String headerName) {
            this(sourceName, headerName, null);
        }

        public NewFileNames(@Nullable String sourceName, @Nullable String headerName, @Nullable List<String> otherNames) {
            assert (sourceName != null || headerName != null) : "either source or header name should be specified";
            this.mySourceName = sourceName;
            this.myHeaderName = headerName;
            this.myOtherNames = otherNames;
        }

        @Nullable
        public String getSourceName() {
            return this.mySourceName;
        }

        @Nullable
        public String getHeaderName() {
            return this.myHeaderName;
        }

        @Nullable
        public List<String> getOtherNames() {
            return this.myOtherNames;
        }

        public String toString() {
            return this.mySourceName + " & " + this.myHeaderName + (String)(this.myOtherNames == null ? "" : " & " + this.myOtherNames);
        }

        @NotNull
        public List<String> getNames() {
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(this.mySourceName, this.myHeaderName));
            if (this.myOtherNames != null) {
                names.addAll(this.myOtherNames);
            }
            return ContainerUtil.filter(names, (Condition)Conditions.notNull());
        }
    }

    private static enum CreateFilesStatus {
        SUCCESS,
        DIR_CREATION_FAILED,
        DIR_IS_READ_ONLY,
        GENERIC_FAILURE;

    }

    public static interface AuxAction {
        public void run(PsiFile[] var1);

        default public boolean executeUnderWriteAction() {
            return true;
        }
    }

    public static class DisposableState<T extends CreateFileDialogBase> {
        public final PsiFile selectedFile;
        public final Project project;
        public final PsiDirectory selectedDir;
        @NotNull
        public final T dialogPeer;

        public DisposableState(PsiFile selectedFile, Project project2, PsiDirectory selectedDir, @NotNull T dialogPeer) {
            this.selectedFile = selectedFile;
            this.project = project2;
            this.selectedDir = selectedDir;
            this.dialogPeer = dialogPeer;
        }
    }

    public static interface FileFactory {
        public PsiFile createFileFromText(@NotNull String var1, @Nullable FileType var2, @NotNull String var3);
    }
}

