/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCLanguageStandard {
    C89(CLanguageKind.C),
    C99(CLanguageKind.C),
    C11(CLanguageKind.C),
    C17(CLanguageKind.C),
    C23(CLanguageKind.C),
    CPP98(CLanguageKind.CPP),
    CPP11(CLanguageKind.CPP),
    CPP14(CLanguageKind.CPP),
    CPP17(CLanguageKind.CPP),
    CPP20(CLanguageKind.CPP),
    CPP23(CLanguageKind.CPP);

    @NotNull
    private final OCLanguageKind myKind;
    public static final String __STDC_VERSION__VALUE_C89 = "199409L";
    public static final String __STDC_VERSION__VALUE_C99 = "199901L";
    public static final String __STDC_VERSION__VALUE_C11 = "201112L";
    public static final String __STDC_VERSION__VALUE_C17 = "201710L";
    public static final String __CPLUSPLUS_VALUE_CPP98 = "199711L";
    public static final String __CPLUSPLUS_VALUE_CPP11 = "201103L";
    public static final String __CPLUSPLUS_VALUE_CPP14 = "201402L";
    public static final String __CPLUSPLUS_VALUE_CPP17 = "201703L";
    public static final String __CPLUSPLUS_VALUE_CPP20 = "202002L";

    private OCLanguageStandard(OCLanguageKind kind) {
        this.myKind = kind;
    }

    public boolean supports(@NotNull OCLanguageStandard standard) {
        return Comparing.equal((Object)this.myKind, (Object)standard.myKind) && this.compareTo(standard) >= 0;
    }

    public String toString() {
        switch (this) {
            case C89: {
                return "c89";
            }
            case C99: {
                return "c99";
            }
            case C11: {
                return "c11";
            }
            case C17: {
                return "c17";
            }
            case C23: {
                return "c2x";
            }
            case CPP98: {
                return "c++98";
            }
            case CPP11: {
                return "c++11";
            }
            case CPP14: {
                return "c++14";
            }
            case CPP17: {
                return "c++17";
            }
            case CPP20: {
                return "c++20";
            }
            case CPP23: {
                return "c++2b";
            }
        }
        return "";
    }

    @NotNull
    public static OCLanguageStandard getCStandard(@Nullable String stdc_version) {
        if (stdc_version != null) {
            if (stdc_version.compareTo(__STDC_VERSION__VALUE_C17) > 0) {
                return C23;
            }
            if (stdc_version.compareTo(__STDC_VERSION__VALUE_C11) > 0) {
                return C17;
            }
            if (stdc_version.compareTo(__STDC_VERSION__VALUE_C99) > 0) {
                return C11;
            }
            if (stdc_version.compareTo(__STDC_VERSION__VALUE_C89) > 0) {
                return C99;
            }
        }
        return C89;
    }

    @NotNull
    public static OCLanguageStandard getCppStandard(@Nullable String cplusplus) {
        if (cplusplus != null) {
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP20) > 0) {
                return CPP23;
            }
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP17) > 0) {
                return CPP20;
            }
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP14) > 0) {
                return CPP17;
            }
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP11) > 0) {
                return CPP14;
            }
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP98) > 0) {
                return CPP11;
            }
        }
        return CPP98;
    }

    @NotNull
    public static OCLanguageStandard latestCpp() {
        return Arrays.stream(OCLanguageStandard.values()).filter(it -> it.myKind == CLanguageKind.CPP).max(Comparator.naturalOrder()).get();
    }

    @NotNull
    public static OCLanguageStandard latestC() {
        return Arrays.stream(OCLanguageStandard.values()).filter(it -> it.myKind == CLanguageKind.C).max(Comparator.naturalOrder()).get();
    }

    @NotNull
    public static String latestCValue() {
        switch (OCLanguageStandard.latestC()) {
            case C89: {
                return __STDC_VERSION__VALUE_C89;
            }
            case C99: {
                return __STDC_VERSION__VALUE_C99;
            }
        }
        return __STDC_VERSION__VALUE_C11;
    }

    @NotNull
    public static String latestCppValue() {
        switch (OCLanguageStandard.latestCpp()) {
            case CPP11: {
                return __CPLUSPLUS_VALUE_CPP11;
            }
            case CPP14: {
                return __CPLUSPLUS_VALUE_CPP14;
            }
            case CPP17: {
                return __CPLUSPLUS_VALUE_CPP17;
            }
        }
        return __CPLUSPLUS_VALUE_CPP20;
    }
}

