/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public final class OCInlineAsserts {
    public static void doAll(@NotNull String text, @NotNull Assert test) {
        OCInlineAsserts.doAll(text, (List<AssertionInfo> assertions, ExceptionHandler handler) -> {
            for (AssertionInfo info : assertions) {
                try {
                    test.doAssert(info.text, info.assertionRange, info.assertionText);
                }
                catch (Throwable e) {
                    handler.handle(info, e);
                }
            }
        });
    }

    public static void doAll(@NotNull String text, @NotNull BatchAssert testBatch) {
        StringBuilder failMessage = new StringBuilder();
        Pattern comment = Pattern.compile("/\\*(([^*])|(\\*[^*/]))*\\*/");
        Matcher matcher = comment.matcher(text);
        ArrayList<AssertionInfo> assertions = new ArrayList<AssertionInfo>();
        while (matcher.find()) {
            String assertionText = matcher.group().replace("/*", "").replace("*/", "");
            int start = matcher.start();
            int end = matcher.end();
            assertions.add(new AssertionInfo(text, new TextRange(start, end), assertionText));
        }
        testBatch.doAssertAll(assertions, (info, e) -> {
            int line = StringUtil.offsetToLineNumber((CharSequence)text, (int)info.assertionRange.getStartOffset()) + 1;
            failMessage.append("Line: ").append(line).append(",  Assertion: ").append(info.assertionText).append("\n").append(e.getMessage()).append("\n\n");
        });
        if (failMessage.length() != 0) {
            TestCase.fail((String)("\n\n" + failMessage));
        }
    }

    private OCInlineAsserts() {
    }

    public static interface BatchAssert {
        public void doAssertAll(@NotNull List<AssertionInfo> var1, @NotNull ExceptionHandler var2);
    }

    public static interface ExceptionHandler {
        public void handle(@NotNull AssertionInfo var1, @NotNull Throwable var2);
    }

    public static interface Assert {
        public void doAssert(@NotNull String var1, @NotNull TextRange var2, @NotNull String var3);
    }

    public static class AssertionInfo {
        @NotNull
        public final String text;
        @NotNull
        public final TextRange assertionRange;
        @NotNull
        public final String assertionText;

        public AssertionInfo(@NotNull String text, @NotNull TextRange assertionRange, @NotNull String assertionText) {
            this.text = text;
            this.assertionRange = assertionRange;
            this.assertionText = assertionText;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssertionInfo info = (AssertionInfo)o;
            if (!this.text.equals(info.text)) {
                return false;
            }
            if (!this.assertionRange.equals((Object)info.assertionRange)) {
                return false;
            }
            return this.assertionText.equals(info.assertionText);
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = 31 * result + this.assertionRange.hashCode();
            result = 31 * result + this.assertionText.hashCode();
            return result;
        }

        public String toString() {
            return String.format("AssertionInfo{/*%s*/ at %s}", this.assertionText, this.assertionRange);
        }
    }
}

