/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrLangUtil {
    public static boolean enableObjectiveCSettings() {
        return PlatformUtils.isAppCode() || PlatformUtils.isMobileIde() || Registry.is((String)"clion.enable.objc.settings");
    }

    @NotNull
    @NlsSafe
    public static String getOCLanguageDisplayName() {
        return PlatformUtils.isAppCode() || PlatformUtils.isMobileIde() ? "C/C++/Objective-C" : "C/C++";
    }

    @NotNull
    public static HyperlinkLabel createLinkToConfigurable(@NotNull @NlsContexts.LinkLabel String hyperlinkText, final @NotNull Class<? extends Configurable> targetConfigurable, final @Nullable Predicate<? super Configurable> predicate, final @Nullable Consumer<? super Configurable> additionalConsumer) {
        final HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(hyperlinkText);
        hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)hyperlinkLabel);
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project2 != null) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project2, c -> ConfigurableWrapper.cast((Class)targetConfigurable, (UnnamedConfigurable)c) != null && (predicate == null || predicate.test(c)), additionalConsumer);
                }
            }
        });
        return hyperlinkLabel;
    }

    @NotNull
    @NlsSafe
    public static String getPrettyNameFromClassName(@NotNull Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (clazz.isAnonymousClass()) {
            className = clazz.getSuperclass().getSimpleName();
        }
        return CidrLangUtil.getPrettyNameFromClassName(className);
    }

    @NotNull
    public static String getPrettyNameFromClassName(@NotNull String className) {
        StringBuilder result = new StringBuilder();
        className = StringUtil.trimStart((String)className, (String)"OC");
        className = StringUtil.trimEnd((String)className, (String)"Inspection");
        className = StringUtil.trimEnd((String)className, (String)"IntentionAction");
        for (String word : StringUtil.findMatches((String)className, (Pattern)Pattern.compile("([A-Z][a-z]*)"))) {
            if (result.length() > 0) {
                result.append(' ').append(StringUtil.decapitalize((String)word));
                continue;
            }
            result.append(word);
        }
        return result.toString();
    }

    public static void restartCodeAnalyzer() {
        Project[] openProjects;
        for (Project project2 : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isInitialized() || project2.isDisposed()) continue;
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project2).restart();
        }
    }

    @Nullable
    public static VirtualFile findBestFile(@NotNull Project project2, @NotNull String path, int requestedLine, @NotNull Predicate<VirtualFile> fileAcceptor) {
        Document document;
        VirtualFile file2;
        long targetStamp = 0L;
        VirtualFile targetVirtualFile = null;
        for (VirtualFile file3 : LocalFileSystem.getInstance().findCachedFilesForPath(path)) {
            Document document2;
            if (!fileAcceptor.test(file3) || (document2 = FileDocumentManager.getInstance().getDocument(file3)) == null || requestedLine >= document2.getLineCount()) continue;
            if (targetVirtualFile == null) {
                targetVirtualFile = file3;
                targetStamp = document2.getModificationStamp();
                continue;
            }
            long curStamp = document2.getModificationStamp();
            if (curStamp <= targetStamp) continue;
            targetVirtualFile = file3;
            targetStamp = curStamp;
        }
        if (targetVirtualFile == null && (file2 = VfsUtil.findFile((Path)new File(path).toPath(), (boolean)false)) != null && (document = FileDocumentManager.getInstance().getDocument(file2)) != null && requestedLine < document.getLineCount()) {
            targetVirtualFile = file2;
        }
        return targetVirtualFile;
    }

    public static boolean isIdentifier(@NotNull String name, @NotNull OCLanguageKind kind, @Nullable OCLanguageStandard languageStandard) {
        return CidrLangUtil.getTokenType(name, kind, languageStandard) == OCLexerTokenTypes.IDENTIFIER;
    }

    @Nullable
    public static IElementType getTokenType(@NotNull String name, @NotNull OCLanguageKind kind, @Nullable OCLanguageStandard languageStandard) {
        CidrLexerSettings.Builder lexerSettings = OCLexerSettings.forLanguage(kind);
        if (languageStandard != null) {
            lexerSettings.setLanguageStandard(languageStandard);
        }
        OCLexer lexer = new OCLexer(lexerSettings.build());
        lexer.start(name);
        IElementType tt = lexer.getTokenType();
        lexer.advance();
        return lexer.getTokenType() == null ? tt : null;
    }
}

