/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrFileIconProvider {
    private static Icon getHeaderIcon(@Nullable OCLanguageKind languageKind) {
        if (languageKind instanceof CUDALanguageKind) {
            return CidrLangIcons.FileTypes.Cuh;
        }
        return CidrLangIcons.FileTypes.H;
    }

    @Nullable
    public static Icon getIcon(@Nullable VirtualFile virtualFile, @NotNull String fileName, @Nullable Project project2) {
        OCLanguageKind kind;
        boolean isHeaderFile = OCFileTypeHelpers.isHeaderFile(fileName);
        OCLanguageKind oCLanguageKind = kind = virtualFile == null ? OCLanguageKindCalculatorBase.calculateMinimalKindByExtension(project2, fileName) : OCLanguageKindCalculatorBase.tryFileTypeAndExtension(project2, virtualFile);
        if (isHeaderFile) {
            return CidrFileIconProvider.getHeaderIcon(kind);
        }
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    return CidrLangIcons.FileTypes.C;
                }
                case CPP: {
                    return CidrLangIcons.FileTypes.Cpp;
                }
                case OBJ_C: 
                case OBJ_CPP: {
                    return CidrLangIcons.FileTypes.M;
                }
            }
        } else if (kind instanceof CUDALanguageKind) {
            return CidrLangIcons.FileTypes.CU;
        }
        return null;
    }
}

