/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class OCTestExecution {
    private static final ThreadLocal<Boolean> ourCanWaitInThisThread = new ThreadLocal();

    public static <T> T executeWithCachedValuesFast(@NotNull Supplier<T> producer) {
        return OCTestExecution.execute(producer, false, false);
    }

    public static <T> T executeWithRealValuesSlow(@NotNull Supplier<T> producer) {
        return OCTestExecution.execute(producer, true, false);
    }

    @TestOnly
    public static <T> T executeWithCachedValuesFastIgnoreUTMode(@NotNull Supplier<T> producer) {
        return OCTestExecution.execute(producer, false, true);
    }

    @TestOnly
    public static <T> T executeWithRealValuesSlowIgnoreUTMode(@NotNull Supplier<T> producer) {
        return OCTestExecution.execute(producer, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T execute(@NotNull Supplier<T> producer, boolean canWait, boolean ignoreTestMode) {
        if (!ignoreTestMode && ApplicationManager.getApplication().isUnitTestMode() || ourCanWaitInThisThread.get() != null && ourCanWaitInThisThread.get() == canWait) {
            return producer.get();
        }
        assert (ourCanWaitInThisThread.get() == null);
        ourCanWaitInThisThread.set(canWait);
        try {
            T t = producer.get();
            return t;
        }
        finally {
            ourCanWaitInThisThread.remove();
        }
    }

    public static boolean canWaitInThisThread() {
        Boolean canWait = ourCanWaitInThisThread.get();
        if (canWait != null) {
            return canWait;
        }
        Application application = ApplicationManager.getApplication();
        return !application.isDispatchThread() && !OCTestExecution.isActionUpdateThread() || application.isUnitTestMode();
    }

    public static boolean isActionUpdateThread() {
        String threadName = Thread.currentThread().getName();
        return threadName.startsWith("Action Updater");
    }
}

