/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestScopeElementImpl
implements CidrTestScopeElement,
Comparable<CidrTestScopeElement> {
    @Nullable
    protected final String mySuiteName;
    @Nullable
    protected final String myTestName;
    @Nullable
    protected final AbstractPropertiesGenerator myDelegate;
    public static final long DEFAULT_TEST_ORDER = -1L;

    protected CidrTestScopeElementImpl(@Nullable String suiteName, @Nullable String testName) {
        this(suiteName, testName, (Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator>)((Function)DefaultPropertiesGenerator::new));
    }

    protected CidrTestScopeElementImpl(@Nullable String suiteName, @Nullable String testName, @Nullable Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> factory) {
        this.mySuiteName = StringUtil.nullize((String)suiteName, (boolean)true);
        this.myTestName = StringUtil.nullize((String)testName, (boolean)true);
        this.myDelegate = factory == null ? null : (AbstractPropertiesGenerator)factory.fun((Object)this);
    }

    public CidrTestScopeElementImpl() {
        this(null, null, null);
    }

    @Override
    @Nullable
    public String getSuiteName() {
        return this.mySuiteName;
    }

    @Override
    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    @Override
    public boolean isTest() {
        this.checkDelegateNotNull();
        return this.myDelegate.isTest();
    }

    @Override
    public boolean isPatternLike() {
        this.checkDelegateNotNull();
        return this.myDelegate.isPatternLike();
    }

    public boolean isVirtualPathHolder() {
        return false;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        CidrTestScopeElementImpl.throwNotDefined();
        return null;
    }

    @Override
    @Nullable
    public String getId() {
        CidrTestScopeElementImpl.throwNotDefined();
        return null;
    }

    @Override
    public long getSortIndex() {
        return -1L;
    }

    @Contract(value=" -> fail")
    private static void throwNotDefined() {
        throw new RuntimeException("Not defined");
    }

    @Override
    @NotNull
    public String getTestPath() {
        if (this.isVirtualPathHolder()) {
            CidrTestScopeElementImpl.throwNotDefined();
        }
        this.checkDelegateNotNull();
        return this.myDelegate.getTestPath();
    }

    @Override
    @NotNull
    public String getPattern() {
        this.checkDelegateNotNull();
        return this.myDelegate.getPattern();
    }

    @Override
    @Nullable
    public String getConfigurationName() {
        this.checkDelegateNotNull();
        return this.myDelegate.getConfigurationName();
    }

    private void checkDelegateNotNull() {
        if (this.myDelegate == null) {
            CidrTestScopeElementImpl.throwNotDefined();
        }
    }

    @NotNull
    public String toString() {
        return this.getPattern();
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CidrTestScopeElement)) {
            return false;
        }
        return this.getPattern().equals(((CidrTestScopeElement)o).getPattern());
    }

    public int hashCode() {
        return this.getPattern().hashCode();
    }

    @Override
    public int compareTo(CidrTestScopeElement o) {
        return StringUtil.compare((String)this.getPattern(), (String)o.getPattern(), (boolean)false);
    }

    @NotNull
    public static String createPathFromParts(Collection<String> suites) {
        return CidrTestScopeElementImpl.createPathFromParts(ArrayUtilRt.toStringArray(suites));
    }

    @NotNull
    public static String createPathFromParts(String ... suites) {
        StringBuilder path = new StringBuilder();
        for (String suite : suites) {
            if (path.length() != 0) {
                path.append('/');
            }
            path.append(suite);
        }
        return path.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitPath(@NotNull String pathWithoutProtocolPrefix) {
        return StringUtil.splitHonorQuotes((String)pathWithoutProtocolPrefix, (char)'/');
    }

    @NotNull
    @Contract(pure=true)
    public static CidrTestScopeElement createTestScopeElementForFile(final @NotNull PsiFile file2, final @NotNull Supplier<String> patternForFile) {
        return new CidrTestScopeElementImpl(){

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public String getConfigurationName() {
                return CidrExecutionBundle.message("test.defaultName.allTestsIn", file2.getName());
            }

            @Override
            @NotNull
            public String getPattern() {
                return StringUtil.notNullize((String)((String)patternForFile.get()));
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                return file2;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String suiteName, @Nullable String testName, @NotNull Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> generator) {
        return new CidrTestScopeElementImpl(suiteName, testName, generator);
    }

    @NotNull
    @Contract(pure=true)
    public static CidrTestScopeElement createTestScopeElementForVirtualTestPath(final @NotNull String virtualTestPath, final @NotNull String configurationName, final @NotNull Supplier<? extends PsiElement> funGetElement, @Nullable Function<CidrTestScopeElementImpl, AbstractPropertiesGenerator> factory) {
        return new CidrTestScopeElementImpl(null, null, factory){

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public String getConfigurationName() {
                return configurationName;
            }

            @Override
            @NotNull
            public String getTestPath() {
                return virtualTestPath;
            }

            @Override
            public boolean isVirtualPathHolder() {
                return true;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                return (PsiElement)funGetElement.get();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeWithPatternAndConfigurationName(final @NotNull String configurationName, final @NotNull String pattern, final @NotNull Supplier<? extends PsiElement> funGetElement) {
        return new CidrTestScopeElementImpl(){

            @Override
            @NotNull
            public String getConfigurationName() {
                return configurationName;
            }

            @Override
            @NotNull
            public String getPattern() {
                return pattern;
            }

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                return (PsiElement)funGetElement.get();
            }
        };
    }

    public static class DefaultPropertiesGenerator
    extends AbstractPropertiesGenerator {
        protected final CidrTestScopeElementImpl myOwner;

        public DefaultPropertiesGenerator(CidrTestScopeElementImpl owner) {
            this.myOwner = owner;
        }

        @Override
        public boolean isTest() {
            return this.myOwner.myTestName != null;
        }

        @Override
        public boolean isPatternLike() {
            return false;
        }

        @Override
        @NotNull
        public String getTestPath() {
            if (this.myOwner.isVirtualPathHolder()) {
                return this.myOwner.getTestPath();
            }
            StringBuilder testName = new StringBuilder();
            if (this.myOwner.mySuiteName != null) {
                testName.append(this.myOwner.mySuiteName);
            }
            if (this.myOwner.myTestName != null) {
                if (testName.length() != 0) {
                    testName.append('/');
                }
                testName.append(this.myOwner.myTestName);
            }
            return testName.toString();
        }

        @Override
        @NotNull
        public String getPattern() {
            return this.getTestPath();
        }

        @Override
        @NotNull
        public String getConfigurationName() {
            if (this.myOwner.myTestName != null) {
                return this.myOwner.myTestName;
            }
            if (this.myOwner.mySuiteName != null) {
                int index = this.myOwner.mySuiteName.lastIndexOf(47);
                return index < 0 ? this.myOwner.mySuiteName : this.myOwner.mySuiteName.substring(index + 1);
            }
            return "";
        }
    }

    public static abstract class AbstractPropertiesGenerator
    implements CidrTestScopeElement {
        @Override
        @NotNull
        public PsiElement getElement() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        @Override
        @Nullable
        public String getId() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        @Override
        @Nullable
        public String getSuiteName() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }

        @Override
        @Nullable
        public String getTestName() {
            CidrTestScopeElementImpl.throwNotDefined();
            return null;
        }
    }
}

