/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeHints;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import com.jetbrains.cidr.ui.ComponentRenderer;
import com.jetbrains.cidr.ui.ItemPrinter;
import com.jetbrains.cidr.ui.ItemPrinterKt;
import com.jetbrains.cidr.ui.ItemState;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestScopeEditor<CONFIGURATION extends RunConfiguration, SUITE>
implements Disposable {
    protected OCTextFieldWithSymbolAutoCompletion<SUITE> mySuiteField;
    protected EditorTextField myPatternField;
    private AsyncProcessIcon myProcessIcon;
    private JLabel myMethodComboLabel;
    private JLabel mySuiteFieldLabel;
    private JLabel myPatternFieldLabel;
    private JLabel mySuitesTipLabel;
    private JRadioButton myRbPattern;
    protected CidrRunConfigurationEditorUtil.ComboBox myMethodCombo;
    private MergingUpdateQueue myQueue;
    private Set<String> mySuiteMethods = Collections.emptySet();
    private final Project myProject;
    private final CidrTestScopeHints myHints;

    public CidrTestScopeEditor(@NotNull Project project2, @NotNull CidrTestScopeHints hints) {
        this.myProject = project2;
        this.myHints = hints;
    }

    public void createEditor(@NotNull JPanel p, @NotNull GridBag g) {
        this.myQueue = new MergingUpdateQueue("UpdateMethods", 500, false, (JComponent)p, (Disposable)this, (JComponent)p, true);
        this.createTestKindRadioButtons(p, g);
        this.mySuiteFieldLabel = new JLabel(this.myHints.getSuiteFieldLabelName() + ":");
        JPanel childPanel = new JPanel(new GridBagLayout());
        p.add((Component)childPanel, g.nextLine().next().insets(0, 0, 0, 0));
        GridBag childGrid = new GridBag().setDefaultFill(1);
        childPanel.add((Component)this.mySuiteFieldLabel, childGrid.nextLine().next().weightx(0.9));
        this.myProcessIcon = new AsyncProcessIcon("TestCompletion");
        this.myProcessIcon.setVisible(false);
        childPanel.add((Component)this.myProcessIcon, childGrid.next().anchor(22).weightx(0.1));
        this.mySuiteField = this.createSuiteField();
        p.add((Component)((Object)this.mySuiteField), g.next().coverLine().insets(0, 0, 0, 0));
        this.mySuiteFieldLabel.setLabelFor((Component)((Object)this.mySuiteField));
        this.mySuitesTipLabel = new JBLabel(this.myHints.getSuitesTipMessage(), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        p.add((Component)this.mySuitesTipLabel, g.nextLine().next().next().coverLine().insets((Insets)JBUI.insets((int)-1, (int)10, (int)4, (int)0)));
        JBInsets i = JBUI.insets((int)-1, (int)-1, (int)12, (int)-1);
        this.myMethodComboLabel = new JLabel(this.myHints.getTestFieldLabelName() + ":");
        p.add((Component)this.myMethodComboLabel, g.nextLine().next().insets((Insets)i));
        this.myMethodCombo = CidrRunConfigurationEditorUtil.createCombo();
        p.add((Component)((Object)this.myMethodCombo), g.next().coverLine().insets((Insets)i));
        this.myMethodComboLabel.setLabelFor((Component)((Object)this.myMethodCombo));
        this.mySuiteField.setPlaceholder(this.myHints.getSuitePlaceholder());
        this.myMethodCombo.setRenderer((ListCellRenderer)((Object)this.getRunConfigurationsRenderer()));
        this.mySuiteField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                CidrTestScopeEditor.this.scheduleSuiteAndTestsUpdate();
            }
        });
        this.myPatternFieldLabel = new JLabel(CidrExecutionBundle.message("test.configuration.pattern", new Object[0]) + ":");
        p.add((Component)this.myPatternFieldLabel, g.nextLine().next());
        this.myPatternField = new EditorTextField();
        p.add((Component)this.myPatternField, g.next().coverLine());
        this.myPatternField.setVisible(false);
        this.myPatternField.setPlaceholder((CharSequence)this.myHints.getPatternPlaceholder());
        this.myPatternField.setPreferredWidth(150);
        this.myPatternFieldLabel.setLabelFor((Component)this.myPatternField);
        this.myPatternFieldLabel.setVisible(false);
    }

    @NotNull
    protected abstract RunConfigurationsRenderer getRunConfigurationsRenderer();

    private void renderMethodName(@NotNull ComponentRenderer component, @NotNull String methodName, @NotNull ItemState state) {
        if (methodName.isEmpty()) {
            component.appendGrayed((Object)this.myHints.getAllTestsMessage(), state);
        } else if (!this.mySuiteMethods.contains(methodName)) {
            component.appendError((Object)methodName, state);
        } else {
            component.append((Object)methodName);
        }
    }

    protected void scheduleSuiteAndTestsUpdate() {
        this.myQueue.cancelAllUpdates();
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && application.isUnitTestMode()) {
            this.myQueue.setPassThrough(false);
        }
        this.myQueue.queue(new Update("go!"){

            public void run() {
                boolean suitesSpecified = CidrTestScopeEditor.this.isValidSuiteName();
                CidrTestScopeEditor.this.myMethodComboLabel.setEnabled(suitesSpecified);
                CidrTestScopeEditor.this.myMethodCombo.setEnabled(suitesSpecified);
                CidrTestScopeEditor.this.updateSuiteAndMethodControls();
            }
        });
    }

    protected OCTextFieldWithSymbolAutoCompletion<SUITE> createSuiteField() {
        return OCTextFieldWithSymbolAutoCompletion.create(this.myProject, this.createSuiteAdapter(), null, new OCTextFieldWithSymbolAutoCompletion.ProcessListener(){

            @Override
            public void onStarted() {
                CidrTestScopeEditor.this.myProcessIcon.setVisible(true);
            }

            @Override
            public void onFinished() {
                CidrTestScopeEditor.this.myProcessIcon.setVisible(false);
            }
        });
    }

    @NotNull
    protected abstract OCFieldAdapter<SUITE> createSuiteAdapter();

    private void createTestKindRadioButtons(JPanel p, GridBag g) {
        JBLabel typeLabel = new JBLabel(ExecutionBundle.message((String)"junit.configuration.configure.junit.test.kind.label", (Object[])new Object[0]));
        p.add((Component)typeLabel, g.nextLine().next());
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton myRbSuiteTest = new JRadioButton();
        myRbSuiteTest.setText(this.myHints.getSuiteFieldLabelName() + " / " + this.myHints.getTestFieldLabelName());
        myRbSuiteTest.setSelected(true);
        this.myRbPattern = new JRadioButton();
        this.myRbPattern.setText(CidrExecutionBundle.message("test.configuration.pattern", new Object[0]));
        buttonGroup.add(myRbSuiteTest);
        buttonGroup.add(this.myRbPattern);
        p.add((Component)myRbSuiteTest, g.next().weightx(0.0).insets((Insets)JBUI.insets((int)0, (int)0, (int)4, (int)10)));
        p.add((Component)this.myRbPattern, g.next().weightx(0.0).insets((Insets)JBUI.insetsBottom((int)4)));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CidrTestScopeEditor.this.changeTestKind();
            }
        };
        myRbSuiteTest.addActionListener(listener);
        this.myRbPattern.addActionListener(listener);
    }

    private void changeTestKind() {
        boolean pattern = this.myRbPattern.isSelected();
        this.mySuiteField.setVisible(!pattern);
        this.mySuiteFieldLabel.setVisible(!pattern);
        this.mySuitesTipLabel.setVisible(!pattern);
        this.myMethodCombo.setVisible(!pattern);
        this.myMethodComboLabel.setVisible(!pattern);
        this.myPatternField.setVisible(pattern);
        this.myPatternFieldLabel.setVisible(pattern);
    }

    private void updateSuiteField() {
        Editor editor = this.mySuiteField.getEditor();
        if (editor == null) {
            return;
        }
        MarkupModel markup = editor.getMarkupModel();
        markup.removeAllHighlighters();
        String suites = this.getTestSuiteText();
        if (suites == null) {
            return;
        }
        if (!this.isValidSuiteName()) {
            markup.addRangeHighlighter(CodeInsightColors.ERRORS_ATTRIBUTES, 0, this.mySuiteField.getDocument().getText().length(), 5000, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    public abstract boolean isValidSuiteName();

    @NotNull
    protected abstract Set<String> collectSuiteTests();

    protected boolean hasOutOfSuiteTests() {
        return false;
    }

    private void updateMethodCombo() {
        this.updateMethodCombo((String)this.myMethodCombo.getSelectedItem());
    }

    private void updateMethodCombo(@Nullable @NlsSafe String selectedItem) {
        if (this.getTestSuiteText() == null && !this.hasOutOfSuiteTests()) {
            selectedItem = null;
        }
        this.mySuiteMethods = this.collectSuiteTests();
        ArrayList<String> items = new ArrayList<String>(this.mySuiteMethods);
        items.add("");
        if (selectedItem != null && !items.contains(selectedItem)) {
            items.add(selectedItem);
        }
        Collections.sort(items);
        if (selectedItem == null && !items.isEmpty()) {
            selectedItem = items.get(0);
        }
        this.myMethodCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)""));
        this.myMethodCombo.setSelectedItem(selectedItem);
    }

    public void dispose() {
        this.mySuiteField.cancelRunningTasks();
        this.myQueue.cancelAllUpdates();
    }

    public void resetEditorFrom(@NotNull CONFIGURATION selected) {
        assert (selected instanceof CidrTestRunConfiguration);
        CidrTestRunConfigurationData<?> delegate = ((CidrTestRunConfiguration)selected).getTestData();
        this.mySuiteField.setText(StringUtil.notNullize((String)delegate.getTestSuite()));
        this.updateMethodCombo(StringUtil.notNullize((String)delegate.getTestName()));
        this.myPatternField.setText(StringUtil.notNullize((String)delegate.getTestPattern()));
        this.myRbPattern.setSelected(delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN);
        this.changeTestKind();
    }

    public void applyEditorTo(@NotNull CONFIGURATION selected) throws ConfigurationException {
        assert (selected instanceof CidrTestRunConfiguration);
        CidrTestRunConfigurationData<?> delegate = ((CidrTestRunConfiguration)selected).getTestData();
        CidrTestRunConfigurationData.Mode mode = this.myRbPattern.isSelected() ? CidrTestRunConfigurationData.Mode.PATTERN : CidrTestRunConfigurationData.Mode.SUITE_TEST;
        delegate.setTestSuite(mode == CidrTestRunConfigurationData.Mode.SUITE_TEST ? this.getTestSuiteText() : null);
        delegate.setTestName(mode == CidrTestRunConfigurationData.Mode.SUITE_TEST ? this.getTestMethodText() : null);
        delegate.setTestPattern(mode == CidrTestRunConfigurationData.Mode.PATTERN ? StringUtil.nullize((String)this.myPatternField.getText().trim()) : null);
        delegate.setTestMode(mode);
    }

    @Nullable
    public String getTestSuiteText() {
        return StringUtil.nullize((String)this.mySuiteField.getText().trim());
    }

    @Nullable
    private String getTestMethodText() {
        return StringUtil.nullize((String)((String)this.myMethodCombo.getSelectedItem()));
    }

    protected void updateSuiteAndMethodControls() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        this.updateSuiteField();
        this.updateMethodCombo();
    }

    protected class RunConfigurationsRenderer
    extends CidrRunConfigurationEditorUtil.RunConfigurationsRenderer {
        public RunConfigurationsRenderer(boolean hasTargetsInSeveralProjects) {
            super(hasTargetsInSeveralProjects, new ItemPrinter[]{ItemPrinterKt.printerFor(String.class, (x$0, x$1, x$2) -> CidrTestScopeEditor.this.renderMethodName(x$0, (String)x$1, x$2))});
        }
    }
}

