/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CidrTestScope {
    @NonNls
    public static final String ALL_IN_FILE_PREFIX = "all-tests(";
    @NonNls
    public static final String ALL_IN_FILE_SUF = ")";
    private final String mySeparator;
    private List<CidrTestScopeElement> myElements;
    private String myPreRenderedScope;

    protected CidrTestScope(@NotNull String separator) {
        this.mySeparator = separator;
    }

    @NotNull
    public List<CidrTestScopeElement> getElements() {
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.createElementCollectionIfNull();
        return this.myElements.stream().sorted().distinct().collect(Collectors.toUnmodifiableList());
    }

    @NotNull
    public static CidrTestScope createEmptyTestScope(@NotNull String separator) {
        return new CidrTestScope(separator);
    }

    @NotNull
    public CidrTestScope configureForPreRenderedScope(@NotNull String switches) {
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null && (this.myElements == null || this.myElements.isEmpty()));
        this.myPreRenderedScope = switches;
        return this;
    }

    @NotNull
    public CidrTestScope addScopeElement(@NotNull CidrTestScopeElement element) {
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.createElementCollectionIfNull();
        this.myElements.add(element);
        return this;
    }

    @NotNull
    public CidrTestScope addPattern(@NotNull String pattern) {
        CidrTestLog.LOG.assertTrue(this.myElements == null || this.myElements.isEmpty());
        this.myPreRenderedScope = this.myPreRenderedScope == null ? pattern : this.myPreRenderedScope + this.mySeparator + pattern;
        return this;
    }

    @NotNull
    public String toString() {
        return this.getAsPattern();
    }

    @NotNull
    public String getAsPattern() {
        return this.myPreRenderedScope != null ? this.myPreRenderedScope : StringUtil.join(this.getAsPatternList(), (String)this.mySeparator);
    }

    @NotNull
    public List<String> getAsPatternList() {
        if (this.myPreRenderedScope != null) {
            if (this.myPreRenderedScope.contains(ALL_IN_FILE_PREFIX)) {
                ArrayList<String> split = new ArrayList<String>();
                int pos = 0;
                while (pos < this.myPreRenderedScope.length()) {
                    int spos;
                    String prefix = "";
                    if (StringUtil.startsWith((CharSequence)this.myPreRenderedScope, (int)pos, (CharSequence)ALL_IN_FILE_PREFIX)) {
                        int end = StringUtil.indexOf((CharSequence)this.myPreRenderedScope, (CharSequence)ALL_IN_FILE_SUF, (int)pos);
                        int npos = end + ALL_IN_FILE_SUF.length();
                        prefix = this.myPreRenderedScope.substring(pos, npos);
                        pos = npos;
                    }
                    if ((spos = StringUtil.indexOf((CharSequence)this.myPreRenderedScope, (CharSequence)this.mySeparator, (int)pos)) < 0) {
                        split.add(prefix + this.myPreRenderedScope.substring(pos));
                        break;
                    }
                    split.add(prefix + this.myPreRenderedScope.substring(pos, spos));
                    pos = spos + this.mySeparator.length();
                }
                return split;
            }
            return StringUtil.split((String)this.myPreRenderedScope, (String)this.mySeparator);
        }
        this.createElementCollectionIfNull();
        return this.myElements.stream().sorted(Comparator.comparingLong(CidrTestScopeElement::getSortIndex)).distinct().map(CidrTestScopeElement::getPattern).collect(Collectors.toList());
    }

    private void createElementCollectionIfNull() {
        if (this.myElements == null) {
            this.myElements = new ArrayList<CidrTestScopeElement>();
        }
    }
}

