/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationBaseProducer;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, TEST_OBJECT>
extends CidrTestRunConfigurationBaseProducer<BC, TARGET, CONFIGURATION, TEST_OBJECT> {
    public static final Key<String> TEST_TARGET_NAME_KEY = Key.create((String)"TEST_TARGET_NAME_KEY");

    protected CidrTestRunConfigurationProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(binder);
    }

    @Override
    protected boolean doSetupConfigurationFromContext(@NotNull CONFIGURATION configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<CidrBuildTarget<Object>> targetsForFile;
        if (!super.doSetupConfigurationFromContext(configuration2, context, sourceElement)) {
            return false;
        }
        PsiFile containingFile = ((PsiElement)sourceElement.get()).getContainingFile();
        String testTargetName = (String)TEST_TARGET_NAME_KEY.get((UserDataHolder)containingFile);
        if (testTargetName != null) {
            CidrBuildConfigurationHelper helper = ((CidrRunConfiguration)configuration2).getHelper();
            Object firstSuitableTarget = helper.findFirstSuitableTarget(testTargetName);
            if (firstSuitableTarget == null) {
                return false;
            }
            targetsForFile = Collections.singletonList(firstSuitableTarget);
        } else {
            targetsForFile = this.getTargetsForFile(containingFile, this::isTestTarget);
        }
        this.setupTarget(configuration2, targetsForFile);
        return true;
    }

    protected abstract boolean isTestTarget(@NotNull TARGET var1);

    @Override
    @Nullable
    protected CidrTestScopeElement determineScope(@NotNull List<CidrTestScopeElement> objects) {
        return this.foldScope(ContainerUtil.mapNotNull(objects, e -> this.containingFileCanUseFramework(this.getElement((CidrTestScopeElement)e)) ? this.determineScope((CidrTestScopeElement)e) : null));
    }

    @Override
    @NotNull
    protected List<CidrTestScopeElement> findTestObjects(@NotNull ConfigurationContext context) {
        return ContainerUtil.mapNotNull(this.getLocations(context), e -> this.containingFileCanUseFramework(e.getPsiElement()) ? this.findTestObject((Location)e) : null);
    }

    @Nullable
    protected CidrTestScopeElement findTestObject(@NotNull Location location) {
        return this.getTestFramework().findTestObject(location.getPsiElement());
    }

    @Contract(value="null -> null")
    @Nullable
    private CidrTestRunConfigurationData getDelegate(CONFIGURATION configuration2) {
        return configuration2 instanceof CidrTestRunConfiguration ? ((CidrTestRunConfiguration)configuration2).getTestData() : null;
    }

    @Contract(pure=true)
    protected boolean containingFileCanUseFramework(@NotNull PsiElement context) {
        return this.getTestFramework().isAvailable(context.getContainingFile());
    }

    @Override
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return this.getTestFramework().getPatternSeparatorInCommandLine();
    }

    @NotNull
    protected abstract CidrTestRunConfigurationLanguageSupport getTestFramework();
}

