/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationSettingsEditor;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeEditor;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrTestRunConfigurationEditor<SUITE, BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrRunConfigurationSettingsEditor<BC, TARGET, CONFIGURATION, BCH> {
    protected CidrTestScopeEditor<CONFIGURATION, SUITE> myTestScopeEditor;
    private volatile boolean myIsDisposed = false;

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public CidrTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        super(project2, configHelper);
    }

    @Override
    @NotNull
    protected CommonProgramParametersPanel createProgramParametersPanel() {
        return this.myConfigHelper.createCommonPanelForTests();
    }

    @NotNull
    protected abstract CidrTestScopeEditor<CONFIGURATION, SUITE> createTestScopeEditor();

    @Override
    protected void createEditorInner(JPanel p, GridBag g) {
        this.myTestScopeEditor = this.createTestScopeEditor();
        Disposer.register((Disposable)this, this.myTestScopeEditor);
        this.myTestScopeEditor.createEditor(p, g);
        super.createEditorInner(p, g);
    }

    protected void disposeEditor() {
        this.myIsDisposed = true;
        if (this.myTestScopeEditor != null) {
            Disposer.dispose(this.myTestScopeEditor);
        }
        super.disposeEditor();
    }

    @Override
    protected void resetEditorFrom(@NotNull CONFIGURATION selected) {
        super.resetEditorFrom(selected);
        this.myTestScopeEditor.resetEditorFrom(selected);
    }

    @Override
    protected void applyEditorTo(@NotNull CONFIGURATION selected) throws ConfigurationException {
        super.applyEditorTo(selected);
        this.myTestScopeEditor.applyEditorTo(selected);
    }

    @TestOnly
    public TextFieldWithAutoCompletion<SUITE> getSuiteField() {
        return this.myTestScopeEditor.mySuiteField;
    }

    @Override
    protected void syncBuildAndExecute(@NotNull CONFIGURATION configuration2, @Nullable BuildTargetData buildTargetData) {
        if (configuration2 instanceof CidrExecutableDataHolder) {
            ((CidrExecutableDataHolder)configuration2).setExecutableData(buildTargetData == null ? null : new ExecutableData(buildTargetData));
        }
    }

    protected boolean isChecking() {
        return false;
    }
}

