/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationBaseProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, TEST_OBJECT>
extends CidrContextRunConfigurationProducer<BC, TARGET, CONFIGURATION> {
    protected CidrTestRunConfigurationBaseProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(binder);
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Supplier<Boolean> supplier = () -> this.doSetupConfigurationFromContext(configuration2, context, sourceElement);
        return ApplicationManager.getApplication().isUnitTestMode() ? supplier.get().booleanValue() : OCTestExecution.executeWithCachedValuesFast(supplier).booleanValue();
    }

    protected boolean doSetupConfigurationFromContext(@NotNull CONFIGURATION configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<CidrTestScopeElement> objects = this.findTestObjects(context);
        if (objects.isEmpty()) {
            return false;
        }
        CidrTestScopeElement scope = this.determineScope(objects);
        if (scope == null) {
            return false;
        }
        CidrTestScopeElement testObj = objects.get(0);
        this.setupConfiguration(configuration2, scope);
        sourceElement.set((Object)this.getElement(testObj));
        return true;
    }

    @NotNull
    protected abstract PsiElement getElement(@NotNull CidrTestScopeElement var1);

    @Nullable
    protected abstract CidrTestScopeElement determineScope(@NotNull List<CidrTestScopeElement> var1);

    @Nullable
    protected CidrTestScopeElement determineScope(@NotNull ConfigurationContext context) {
        return this.determineScope(this.findTestObjects(context));
    }

    @Nullable
    protected abstract CidrTestScopeElement determineScope(@NotNull CidrTestScopeElement var1);

    @NotNull
    protected abstract List<CidrTestScopeElement> findTestObjects(@NotNull ConfigurationContext var1);

    public boolean isConfigurationFromContext(@NotNull CONFIGURATION configuration2, @NotNull ConfigurationContext context) {
        Supplier<Boolean> supplier = () -> {
            CidrTestRunConfigurationData delegate = this.getDelegate(configuration2);
            if (delegate == null) {
                return false;
            }
            CidrTestScopeElement scope = this.determineScope(context);
            if (scope == null) {
                return false;
            }
            return delegate.equalTo(scope);
        };
        return ApplicationManager.getApplication().isUnitTestMode() ? supplier.get().booleanValue() : OCTestExecution.executeWithCachedValuesFast(supplier).booleanValue();
    }

    @Contract(value="null -> null")
    @Nullable
    private CidrTestRunConfigurationData getDelegate(CONFIGURATION configuration2) {
        return configuration2 instanceof CidrTestRunConfiguration ? ((CidrTestRunConfiguration)configuration2).getTestData() : null;
    }

    protected void setupConfiguration(CONFIGURATION configuration2, CidrTestScopeElement scope) {
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration2);
        if (delegate == null) {
            return;
        }
        if (scope.isPatternLike()) {
            delegate.setTestSuite(null);
            delegate.setTestName(null);
            delegate.setTestPattern(scope.getPattern());
            delegate.setTestMode(CidrTestRunConfigurationData.Mode.PATTERN);
        } else {
            delegate.setTestSuite(scope.getSuiteName());
            delegate.setTestName(scope.getTestName());
            delegate.setTestPattern(null);
            delegate.setTestMode(CidrTestRunConfigurationData.Mode.SUITE_TEST);
        }
        String configurationName = scope.getConfigurationName();
        configuration2.setName(configurationName == null ? delegate.suggestedName(((CidrRunConfiguration)configuration2).suggestNameForTarget()) : configurationName);
    }

    @NotNull
    public List<Location> getLocations(@NotNull ConfigurationContext context) {
        Object[] psiElements;
        Object[] paths;
        SMTRunnerTestTreeView treeView = (SMTRunnerTestTreeView)SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW.getData(context.getDataContext());
        if (treeView != null && (paths = treeView.getSelectionPaths()) != null && paths.length > 1) {
            GlobalSearchScope scope = this.getProjectSourcesScope(context.getProject());
            return ContainerUtil.mapNotNull((Object[])paths, path -> {
                if (treeView.isPathSelected(path.getParentPath())) {
                    return null;
                }
                SMTestProxy test = treeView.getSelectedTest(path);
                return test == null ? null : test.getLocation(context.getProject(), scope);
            });
        }
        if (context.containsMultipleSelection() && (psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context.getDataContext())) != null) {
            return ContainerUtil.mapNotNull((Object[])psiElements, e -> new PsiLocation(context.getProject(), e));
        }
        Location location = context.getLocation();
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(location);
    }

    @Nullable
    protected CidrTestScopeElement foldScope(@NotNull List<CidrTestScopeElement> elements) {
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        Ref firstName = new Ref();
        List res = ContainerUtil.map(elements, scope -> {
            firstName.setIfNull((Object)scope.getConfigurationName());
            return scope.getPattern();
        });
        if (res.isEmpty()) {
            return null;
        }
        Object name = (String)firstName.get();
        if (res.size() > 1) {
            name = (String)name + " " + CidrExecutionBundle.message("test.and.more", res.size() - 1);
        }
        return CidrTestScopeElementImpl.createTestScopeWithPatternAndConfigurationName((String)name, StringUtil.join(new LinkedHashSet(res), (String)this.getPatternSeparatorInCommandLine()), () -> ((CidrTestScopeElement)elements.get(0)).getElement());
    }

    @NotNull
    public abstract String getPatternSeparatorInCommandLine();

    @NotNull
    public abstract GlobalSearchScope getProjectSourcesScope(@NotNull Project var1);
}

