/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRunConfigurationWithFrameworkInfo;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CidrTestRunConfiguration
extends SMRunnerConsolePropertiesProvider,
CidrRunConfigurationWithFrameworkInfo {
    @NotNull
    public CidrTestRunConfigurationData<?> getTestData();

    @NotNull
    public CidrLauncher createLauncher(@NotNull ExecutionEnvironment var1);

    @NotNull
    default public CidrRerunFailedTestsAction.CidrReturnTestProfile createTestRunProfile(@NotNull CidrTestScope scope) {
        return new CidrRerunFailedTestsAction.CidrReturnTestProfile(this, scope);
    }

    @Nullable
    default public CommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        return this.getTestData().createState(env, executor, failedTests);
    }

    @NotNull
    default public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        return this.getTestData().createTestConsoleProperties(executor, ExecutionTargetManager.getActiveTarget((Project)this.getProject()));
    }

    @Override
    @Nullable
    @NonNls
    default public String getFrameworkId() {
        return (String)ReadAction.compute(() -> {
            CidrTestRunConfigurationData<?> testData = this.getTestData();
            boolean canReportID = PluginInfoDetectorKt.getPluginInfo(testData.getClass()).isDevelopedByJetBrains();
            return canReportID ? testData.getTestingFrameworkId() : "third.party";
        });
    }
}

