/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrMetaParam;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestNoIndexSupport
implements CidrTestLanguageSupport {
    private static final Key<Pair<String, CidrTestScopeElement>> TEST_SCOPE_ELEMENT_KEY = Key.create((String)"TEST_SCOPE_ELEMENT_KEY");
    @NonNls
    @NotNull
    private final String myProtocolPrefix;
    @NonNls
    @NotNull
    private final String myPatternSeparatorInCommandLine;

    public CidrTestNoIndexSupport(@NonNls @NotNull String protocolPrefix, @NonNls @NotNull String patternSeparatorInCommandLine) {
        this.myProtocolPrefix = protocolPrefix;
        this.myPatternSeparatorInCommandLine = patternSeparatorInCommandLine;
    }

    @Override
    public Collection<? extends CidrTestScopeElement> getElementsInFile(@NotNull PsiFile file2) {
        return Collections.emptySet();
    }

    @Override
    public boolean usesTestIndexForNavigation() {
        return false;
    }

    @Override
    public boolean isIndexing(@NotNull Project project2) {
        return false;
    }

    @Override
    public boolean areSymbolsLoaded(@NotNull Project project2) {
        return true;
    }

    @Override
    @NotNull
    public Collection<CidrTestScopeElement> findTestScopeElementsSync(@NotNull @NonNls String locationPath, @NotNull @NonNls String configName, @Nullable @NonNls String metainfo, @NotNull Project project2, @NotNull GlobalSearchScope scope, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
        String target = CidrMetaParam.parse(metainfo).get("target");
        if (target == null) {
            return Collections.emptyList();
        }
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)PsiManager.getInstance((Project)project2), null);
        CidrTestScopeElement testScopeElementForVirtualTestPath = CidrTestScopeElementImpl.createTestScopeElementForVirtualTestPath(locationPath, configName, () -> holder, generator);
        TEST_SCOPE_ELEMENT_KEY.set((UserDataHolder)holder, (Object)Pair.create((Object)this.myProtocolPrefix, (Object)testScopeElementForVirtualTestPath));
        CidrTestRunConfigurationProducer.TEST_TARGET_NAME_KEY.set((UserDataHolder)holder, (Object)target);
        return Collections.singleton(testScopeElementForVirtualTestPath);
    }

    @Override
    @NotNull
    public List<Location> getLocationSafe(@NotNull Project project2, @NotNull Computable<List<Location>> findLocationsInScope) {
        return (List)findLocationsInScope.compute();
    }

    @Override
    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project2) {
        return ModificationTracker.NEVER_CHANGED;
    }

    @Override
    public boolean hasTestElement(@NotNull Project project2, @Nullable @NonNls String suite, @Nullable @NonNls String test) {
        return true;
    }

    @Override
    @NotNull
    public Set<String> collectAllSuiteNames(@NotNull Project project2, @Nullable Condition<String> conditionForSuiteName) {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public Set<String> collectTestsInSuite(@NotNull Project project2, @Nullable @NonNls String suitePath) {
        return Collections.emptySet();
    }

    @Override
    @NonNls
    @NotNull
    public String getProtocolPrefix() {
        return this.myProtocolPrefix;
    }

    @Override
    @NonNls
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        return this.myPatternSeparatorInCommandLine;
    }

    @Override
    public boolean isAvailable(@Nullable PsiFile file2) {
        return file2 == null || file2 instanceof DummyHolder && this.findTestObject((PsiElement)file2) != null;
    }

    @Override
    @Nullable
    public CidrTestScopeElement findTestObject(@Nullable PsiElement element) {
        return CidrTestNoIndexSupport.findCachedTestObject(element, this.myProtocolPrefix);
    }

    @Override
    @NotNull
    public GlobalSearchScope getProjectSourcesScope(@NotNull Project project2) {
        return GlobalSearchScope.projectScope((Project)project2);
    }

    @Nullable
    public static CidrTestScopeElement findCachedTestObject(@Nullable PsiElement element, @NonNls @NotNull String protocolPrefix) {
        Pair pair = (Pair)TEST_SCOPE_ELEMENT_KEY.get((UserDataHolder)element);
        return pair != null && ((String)pair.first).equals(protocolPrefix) ? (CidrTestScopeElement)pair.second : null;
    }
}

