/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class CidrTestExecutionUtil {
    @NotNull
    public static String getAsPatternForCommandLine(@NotNull Project project2, @NotNull Function<PsiFile, Collection<? extends CidrTestScopeElement>> getFileElements, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull Supplier<Boolean> areSymbolsLoaded, @NotNull CidrTestScope testScope, @NotNull ProgressIndicator progress) {
        String pattern = testScope.getAsPattern();
        if (!pattern.contains("all-tests(")) {
            return pattern;
        }
        CidrTestLog.LOG.assertTrue(OCTestExecution.canWaitInThisThread());
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        CidrTestScope finalFileScope = emptyTestScopeProducer.get();
        block2: for (String _pattern : testScope.getAsPatternList()) {
            if (!(_pattern = _pattern.trim()).startsWith("all-tests(") || !_pattern.endsWith(")")) continue;
            String fileId = _pattern.substring("all-tests(".length(), _pattern.length() - ")".length());
            VirtualFile vfile = virtualFileManager.findFileByUrl(fileId);
            if (vfile == null) {
                progress.setText2(CidrExecutionBundle.message("test.file.not.found.in.fs", fileId));
                continue;
            }
            boolean first = true;
            while (!progress.isCanceled()) {
                if (!areSymbolsLoaded.get().booleanValue()) {
                    if (first) {
                        first = false;
                        progress.setText2(CidrExecutionBundle.message("test.waiting.for.symbols", new Object[0]));
                    }
                } else if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    PsiFile pfile = psiManager.findFile(vfile);
                    if (pfile == null) {
                        progress.setText2(CidrExecutionBundle.message("test.file.not.found.in.project", fileId));
                        return;
                    }
                    progress.setText2(CidrExecutionBundle.message("test.processing.file", vfile.getPath()));
                    finalFileScope.addPattern(CidrTestExecutionUtil.createFilePatternAsTestList((Collection)getFileElements.fun((Object)pfile), emptyTestScopeProducer, CidrTestScopeElement::isTest));
                }, (ProgressIndicator)new SensitiveProgressWrapper(progress))) continue block2;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!progress.isCanceled()) {
            String finalFileScopeAsPattern = finalFileScope.getAsPattern();
            progress.setText2(CidrExecutionBundle.message("test.pattern.to.run", finalFileScopeAsPattern));
            return finalFileScopeAsPattern;
        }
        return "";
    }

    @NotNull
    public static String createFilePatternAsTestList(@NotNull Collection<? extends CidrTestScopeElement> fileElements, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull Predicate<CidrTestScopeElement> filter2) {
        CidrTestScope fileScope = emptyTestScopeProducer.get();
        for (CidrTestScopeElement cidrTestScopeElement : fileElements) {
            if (!filter2.test(cidrTestScopeElement)) continue;
            fileScope.addScopeElement(cidrTestScopeElement);
        }
        return fileScope.getAsPattern();
    }
}

