/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestEventProcessor {
    @NotNull
    private final String myLocationProtocol;

    public CidrTestEventProcessor(@NotNull String locationProtocol) {
        this.myLocationProtocol = locationProtocol;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NlsSafe @NotNull String name, @NonNls @NotNull String location) {
        return this.suiteStarted(name, null, null, location, null);
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NlsSafe @NotNull String name, @NonNls @Nullable String parentId, @NonNls @Nullable String nodeId, @NotNull String location, @Nullable String metainfo) {
        return this.doSuiteStarted(name, parentId, nodeId, location, metainfo);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doSuiteStarted(@NlsSafe @NotNull String name, @NonNls @Nullable String parentId, @NonNls @Nullable String nodeId, @NonNls @NotNull String location, @NonNls @Nullable String metainfo) {
        return Collections.singletonList(CidrTestEventProcessor.setParentNodeId(parentId, CidrTestEventProcessor.setNodeId(nodeId, this.setLocation(location, CidrTestEventProcessor.setMetainfo(metainfo, ServiceMessageBuilder.testSuiteStarted((String)name))))));
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteFinished(@NlsSafe @NotNull String name) {
        return this.suiteFinished(name, null);
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteFinished(@NlsSafe @NotNull String name, @NonNls @Nullable String nodeId) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testSuiteFinished((String)name)));
    }

    @NotNull
    public List<ServiceMessageBuilder> testStarted(@NlsSafe @NotNull String testName, @NonNls @NotNull String location) {
        return this.testStarted(testName, null, null, location, null);
    }

    @NotNull
    public List<ServiceMessageBuilder> testStarted(@NlsSafe @NotNull String testName, @NonNls @Nullable String parentId, @NonNls @Nullable String nodeId, @NonNls @NotNull String location, @NonNls @Nullable String metainfo) {
        return this.doTestStarted(testName, parentId, nodeId, location, metainfo);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestStarted(@NlsSafe @NotNull String testName, @NonNls @Nullable String parentId, @NonNls @Nullable String nodeId, @NonNls @NotNull String location, @NonNls @Nullable String metainfo) {
        return Collections.singletonList(CidrTestEventProcessor.setParentNodeId(parentId, CidrTestEventProcessor.setNodeId(nodeId, this.setLocation(location, CidrTestEventProcessor.setMetainfo(metainfo, ServiceMessageBuilder.testStarted((String)testName))))));
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @NotNull String duration, boolean success) {
        return this.testFinished(testName, duration, success, false);
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @NotNull String duration, boolean success, boolean ignored) {
        return this.testFinished(testName, null, duration, success, ignored);
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @NotNull String duration, boolean success) {
        return this.doTestFinished(testName, nodeId, duration, success, false);
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @NotNull String duration, boolean success, boolean ignore) {
        return this.doTestFinished(testName, nodeId, duration, success, ignore);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestFinished(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @NotNull String duration, boolean success, boolean ignored) {
        ServiceMessageBuilder statusMessage = null;
        if (!success) {
            statusMessage = ServiceMessageBuilder.testFailed((String)testName);
        } else if (ignored) {
            statusMessage = ServiceMessageBuilder.testIgnored((String)testName);
        }
        ServiceMessageBuilder finishMessage = CidrTestEventProcessor.setNodeId(nodeId, CidrTestEventProcessor.setDuration(duration, ServiceMessageBuilder.testFinished((String)testName)));
        if (statusMessage == null) {
            return Collections.singletonList(finishMessage);
        }
        CidrTestEventProcessor.setNodeId(nodeId, CidrTestEventProcessor.setMessage("", statusMessage));
        return Arrays.asList(statusMessage, finishMessage);
    }

    @NotNull
    public List<ServiceMessageBuilder> testUnitIgnore(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NonNls @Nullable String ignoreComment) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, CidrTestEventProcessor.setMessage(ignoreComment, ServiceMessageBuilder.testIgnored((String)testName))));
    }

    @NotNull
    public List<ServiceMessageBuilder> testErrOut(@NlsSafe @NotNull String testName, @NlsSafe @NotNull String output) {
        return this.testErrOut(testName, null, output);
    }

    @NotNull
    public List<ServiceMessageBuilder> testErrOut(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NlsSafe @NotNull String output) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdErr((String)testName).addAttribute("out", output)));
    }

    @NotNull
    public List<ServiceMessageBuilder> testStdOut(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NlsSafe @NotNull String output) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdOut((String)testName).addAttribute("out", output)));
    }

    @NotNull
    public List<ServiceMessageBuilder> testErrOut(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NotNull Key outputType, @NlsSafe @NotNull String output) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdErr((String)testName).addAttribute("out", output).addAttribute("textAttributes", outputType.toString())));
    }

    @NotNull
    public List<ServiceMessageBuilder> testStdOut(@NlsSafe @NotNull String testName, @NonNls @Nullable String nodeId, @NotNull Key outputType, @NlsSafe @NotNull String output) {
        return Collections.singletonList(CidrTestEventProcessor.setNodeId(nodeId, ServiceMessageBuilder.testStdOut((String)testName).addAttribute("out", output).addAttribute("textAttributes", outputType.toString())));
    }

    @NotNull
    private ServiceMessageBuilder setLocation(@NonNls @Nullable String location, @NotNull ServiceMessageBuilder builder) {
        if (location == null) {
            return builder;
        }
        return builder.addAttribute("locationHint", this.myLocationProtocol + "://" + location);
    }

    @NotNull
    private static ServiceMessageBuilder setMetainfo(@NonNls @Nullable String nodeId, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("metainfo", nodeId, builder);
    }

    @NotNull
    private static ServiceMessageBuilder setNodeId(@NonNls @Nullable String nodeId, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("nodeId", nodeId, builder);
    }

    @NotNull
    private static ServiceMessageBuilder setParentNodeId(@NonNls @Nullable String parentNodeId, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("parentNodeId", parentNodeId, builder);
    }

    @NotNull
    private static ServiceMessageBuilder setMessage(@NlsSafe @Nullable String message, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("message", message, builder);
    }

    @NotNull
    private static ServiceMessageBuilder setDuration(@NonNls @Nullable String duration, @NotNull ServiceMessageBuilder builder) {
        return CidrTestEventProcessor.addParamIfNeed("duration", duration, builder);
    }

    private static ServiceMessageBuilder addParamIfNeed(@NonNls @NotNull String attrName, @NlsSafe @Nullable String value, @NotNull ServiceMessageBuilder builder) {
        if (value == null) {
            return builder;
        }
        return builder.addAttribute(attrName, value);
    }

    @Nullable
    public Matcher hideOutputMatcher(@NlsSafe @NotNull String text) {
        return null;
    }
}

