/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverterBase;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrFromTagInLineToGeneralTestEventsConverter
extends CidrOutputToGeneralTestEventsConverterBase {
    protected final CidrTestEventProcessor myEventProcessor;
    protected volatile String myProcessFinishedMessage;
    protected volatile String myFinalTestReport;
    protected final ExecutionConsole myConsole;
    protected final Stack<String> myTestNameStack = new Stack();
    protected final Stack<TestResult> myTestResultStack = new Stack();
    public static final String NAME_SPLITTER = "/";
    public static final String EMPTY_STR = "";
    protected static final String ROOT_NODE_ID = "0";
    protected volatile ServiceMessageVisitor myVisitor;

    public CidrFromTagInLineToGeneralTestEventsConverter(@NonNls @NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull CidrTestEventProcessor processor, @NotNull ExecutionConsole console) {
        super(testFrameworkName, consoleProperties);
        this.myEventProcessor = processor;
        this.myConsole = console;
    }

    protected void process(@NotNull List<ServiceMessageBuilder> messages) {
        try {
            for (ServiceMessageBuilder each : messages) {
                super.processServiceMessages(each.toString(), ProcessOutputTypes.STDOUT, this.myVisitor);
            }
        }
        catch (Exception e) {
            CidrTestLog.LOG.error(e.getMessage());
        }
    }

    protected boolean processServiceMessages(@NlsSafe @NotNull String text, @Nullable Key outputType, @NotNull ServiceMessageVisitor visitor) {
        CidrOutputToGeneralTestEventsConverter.logOutput(text, outputType);
        this.myVisitor = visitor;
        if (outputType != null && (ProcessOutputType.isStdout((Key)outputType) || ProcessOutputType.isStderr((Key)outputType))) {
            this.processLine(outputType, text);
            return true;
        }
        if (CidrOutputToGeneralTestEventsConverter.PROCESS_FINISHED_PATTERN.matcher(text).matches()) {
            this.myProcessFinishedMessage = text;
            return true;
        }
        return text.equals("\n");
    }

    protected abstract void processLine(@NotNull Key var1, @NotNull @NlsSafe String var2);

    @NotNull
    @NonNls
    protected String getCurrentNodeId() {
        StringBuilder path = new StringBuilder();
        path.append(ROOT_NODE_ID);
        this.myTestNameStack.forEach(testName -> path.append(NAME_SPLITTER).append((String)testName));
        return path.toString();
    }

    @NonNls
    protected String getLocationFromId() {
        String nodeId = this.getCurrentNodeId();
        return nodeId.equals(ROOT_NODE_ID) ? EMPTY_STR : nodeId.substring(ROOT_NODE_ID.length() + 1);
    }

    public static long getTimeInMs(@NlsSafe @Nullable String timeStringWithSplittersAndSuffix) {
        if (timeStringWithSplittersAndSuffix != null) {
            try {
                int length = timeStringWithSplittersAndSuffix.length() - 2;
                if (length > 0) {
                    String numbersWithSeps = timeStringWithSplittersAndSuffix.substring(0, length).trim();
                    length = numbersWithSeps.length();
                    StringBuilder sb = new StringBuilder(length);
                    for (int i = 0; i < length; ++i) {
                        char ch = numbersWithSeps.charAt(i);
                        if ("0123456789".indexOf(ch) < 0) continue;
                        sb.append(ch);
                    }
                    long parseLong = Long.parseLong(sb.toString());
                    if (timeStringWithSplittersAndSuffix.endsWith("us")) {
                        return Math.round((double)parseLong / 1000.0);
                    }
                    if (timeStringWithSplittersAndSuffix.endsWith("ms")) {
                        return parseLong;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public void flushBufferOnProcessTermination(int exitCode) {
        GeneralTestEventsProcessor processor = this.getProcessor();
        if (processor != null) {
            if (this.myFinalTestReport != null) {
                processor.onUncapturedOutput(this.myFinalTestReport, ProcessOutputTypes.STDERR);
            }
            if (this.myProcessFinishedMessage != null) {
                processor.onUncapturedOutput(this.myProcessFinishedMessage, ProcessOutputTypes.SYSTEM);
            }
        }
        this.transferTextToConsoleViewInTest();
        super.flushBufferOnProcessTermination(exitCode);
    }

    protected void transferTextToConsoleViewInTest() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ((ConsoleViewImpl)((SMTRunnerConsoleView)this.myConsole).getConsole()).waitAllRequests());
        }
    }

    protected static boolean fixIgnoredState(@NotNull GeneralTestEventsProcessor processor, @NotNull SMTestProxy node, @NotNull Predicate<SMTestProxy> isDisabledByFramework, @NotNull Function<? super SMTestProxy, String> getNodeId, boolean markIgnored) {
        String nodeId;
        markIgnored |= node.isIgnored() || isDisabledByFramework.test(node);
        if (!node.isLeaf()) {
            boolean allChildrenIgnored = true;
            for (SMTestProxy ch : node.getChildren()) {
                if (CidrFromTagInLineToGeneralTestEventsConverter.fixIgnoredState(processor, ch, isDisabledByFramework, getNodeId, markIgnored)) continue;
                allChildrenIgnored = false;
            }
            markIgnored |= allChildrenIgnored;
        }
        if (markIgnored && !node.isIgnored() && (nodeId = (String)getNodeId.fun((Object)node)) != null) {
            processor.onTestIgnored(new TestIgnoredEvent(node.getName(), nodeId, " ", null));
        }
        return markIgnored;
    }

    protected static final class TestResult {
        public boolean success = true;
        public int durationInMs = 0;

        private TestResult() {
        }

        public void update(boolean succeed, long durationInMs) {
            this.success &= succeed;
            this.durationInMs = (int)((long)this.durationInMs + durationInMs);
        }

        public static TestResult create(boolean success, int durationInMs) {
            TestResult result = new TestResult();
            result.success = success;
            result.durationInMs = durationInMs;
            return result;
        }
    }

    protected static class TagWithAttr<TAG> {
        private final Map<Attr, String> myAttrs;
        private final TAG myTag;

        public TagWithAttr(@NotNull TAG tag, @NotNull Map<Attr, String> attrs) {
            this.myAttrs = attrs;
            this.myTag = tag;
        }

        @Nullable
        public String getAttr(Attr attrId) {
            return this.myAttrs.get((Object)attrId);
        }

        @NotNull
        public TAG getTag() {
            return this.myTag;
        }
    }

    public static enum Attr {
        SOURCE_PATH,
        LINE_NUM,
        NAME,
        MESSAGE,
        TIME,
        SUCCEEDED,
        TEST_ID;

    }
}

