/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunConfigurationConverter;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunProfileStateWithPreparation;
import java.awt.Component;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBeforeTestRunTaskProvider
extends BeforeRunTaskProvider {
    private static final String BEFORE_TEST_ID = "BeforeTestRunTask";
    public static final Key<BeforeTestRunTask> ID = Key.create((String)"BeforeTestRunTask");
    public static final Key<Content> CONTENT = Key.create((String)"Content");
    public static final Key<ProgressIndicator> PROGRESS = Key.create((String)"ProgressIndicator");
    private static final Key<ConsoleView> CONSOLE_VIEW = Key.create((String)"ConsoleView");

    public Key<BeforeTestRunTask> getId() {
        return ID;
    }

    public String getName() {
        return CidrExecutionBundle.message("test.before.run", new Object[0]);
    }

    public String getDescription(BeforeRunTask task) {
        return CidrExecutionBundle.message("test.before.run.description", new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return new LayeredIcon(new Icon[]{AllIcons.RunConfigurations.TestState.Run, AllIcons.RunConfigurations.TestMark});
    }

    public boolean isSingleton() {
        return true;
    }

    public BeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (!this.configurationNeedBeforeTestRunTask(runConfiguration)) {
            return null;
        }
        return new BeforeTestRunTask();
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration2, @NotNull BeforeRunTask task) {
        return this.configurationNeedBeforeTestRunTask(configuration2);
    }

    protected boolean configurationNeedBeforeTestRunTask(@NotNull RunConfiguration runConfiguration) {
        return runConfiguration instanceof CidrTestRunConfiguration && ((CidrTestRunConfiguration)runConfiguration).getTestData() instanceof CidrTestConfigurationNeedBeforeRunTask;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration2, @NotNull ExecutionEnvironment env, @NotNull BeforeRunTask task) {
        try {
            RunProfileState pureState = Objects.requireNonNull(env.getState());
            if (!(pureState instanceof CidrTestRunProfileStateWithPreparation)) {
                return true;
            }
            CidrTestRunProfileStateWithPreparation state = (CidrTestRunProfileStateWithPreparation)pureState;
            BackgroundableProcessIndicator progress = this.createProgress(configuration2);
            ProgressManager.getInstance().runProcess(() -> state.prepareTestExecutionEnvironment((ProgressIndicator)progress), (ProgressIndicator)progress);
            return !progress.isCanceled();
        }
        catch (ProcessCanceledException ignored) {
            return false;
        }
        catch (Throwable e) {
            CidrTestLog.LOG.error(e);
            return false;
        }
    }

    @NotNull
    private BackgroundableProcessIndicator createProgress(final @NotNull RunConfiguration configuration2) {
        return (BackgroundableProcessIndicator)UIUtil.invokeAndWaitIfNeeded(() -> {
            Project project2 = configuration2.getProject();
            final Content content = this.getContent(project2);
            BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(project2, new TaskInfo(){

                @NotNull
                public String getTitle() {
                    return CidrExecutionBundle.message("test.before.run.progress.title", configuration2.getName());
                }

                public String getCancelText() {
                    return CidrExecutionBundle.message("test.stop.run", new Object[0]);
                }

                public String getCancelTooltipText() {
                    return CidrExecutionBundle.message("test.stop.run.description", new Object[0]);
                }

                public boolean isCancellable() {
                    return true;
                }
            }, PerformInBackgroundOption.ALWAYS_BACKGROUND){
                boolean first;
                {
                    super(arg0, arg1, arg2);
                    this.first = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void start() {
                    Object object = this.getLock();
                    synchronized (object) {
                        super.start();
                        this.setText(CidrExecutionBundle.message("test.before.run.progress.text", new Object[0]));
                        this.setText2(this.getTitle());
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stop() {
                    Object object = this.getLock();
                    synchronized (object) {
                        this.setText2(CidrExecutionBundle.message(this.isCanceled() ? "test.before.run.canceled" : "test.before.run.finished", new Object[0]));
                        PROGRESS.set((UserDataHolder)content, null);
                        super.stop();
                    }
                }

                public void setText2(@NlsSafe String text) {
                    Object message;
                    super.setText2(text);
                    if (content == null || Disposer.isDisposed((Disposable)content)) {
                        return;
                    }
                    ConsoleView consoleView = (ConsoleView)CONSOLE_VIEW.get((UserDataHolder)content);
                    if (consoleView == null) {
                        return;
                    }
                    if (this.first) {
                        this.first = false;
                        message = text;
                    } else {
                        message = "\n" + text;
                    }
                    ConsoleViewContentType output = text.startsWith("Warning:") || text.startsWith("Error:") ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
                    consoleView.print((String)message, output);
                }
            };
            CONTENT.set((UserDataHolder)indicator, (Object)content);
            PROGRESS.set((UserDataHolder)content, (Object)indicator);
            return indicator;
        });
    }

    @Nullable
    private Content getContent(final @NotNull Project project2) throws RuntimeException {
        return (Content)ApplicationManager.getApplication().runWriteAction(() -> {
            ConsoleView consoleView;
            MessageView.getInstance((Project)project2);
            ToolWindowManager manager2 = ToolWindowManager.getInstance((Project)project2);
            ToolWindow window = manager2.getToolWindow("Messages");
            if (window == null) {
                return null;
            }
            String displayName2 = this.getName();
            final ContentManager contentManager = window.getContentManager();
            Content content = contentManager.findContent(displayName2);
            if (content == null) {
                ConsoleView console = TextConsoleBuilderFactory.getInstance().createBuilder(project2, ProjectScope.getProjectScope((Project)project2)).getConsole();
                JComponent component = console.getComponent();
                DefaultActionGroup toolbarActions = new DefaultActionGroup();
                ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Run", (ActionGroup)toolbarActions, false);
                toolbar.setTargetComponent(component);
                component.add((Component)toolbar.getComponent(), "West");
                content = contentManager.getFactory().createContent(component, displayName2, true);
                contentManager.addContent(content);
                CONSOLE_VIEW.set((UserDataHolder)content, (Object)console);
                Disposer.register((Disposable)content, (Disposable)console);
                toolbarActions.add((AnAction)new StopAction(content));
                toolbarActions.addSeparator();
                toolbarActions.addAll(console.createConsoleActions());
                final Content fcontent = content;
                contentManager.addContentManagerListener(new ContentManagerListener(){

                    public void contentRemoved(@NotNull ContentManagerEvent event) {
                        if (event.getContent() != fcontent) {
                            return;
                        }
                        contentManager.removeContentManagerListener((ContentManagerListener)this);
                    }

                    public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
                        if (event.getContent() != fcontent) {
                            return;
                        }
                        ProgressIndicator indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)fcontent);
                        if (indicator != null && indicator.isRunning()) {
                            int result = Messages.showYesNoDialog((Project)project2, (String)CidrExecutionBundle.message("test.before.run.cancelQuestion", new Object[0]), (String)CidrExecutionBundle.message("test.before.run.inProgress", new Object[0]), (Icon)Messages.getQuestionIcon());
                            if (result == 0) {
                                PROGRESS.set((UserDataHolder)fcontent, null);
                                indicator.cancel();
                            } else {
                                event.consume();
                            }
                        }
                    }
                });
            }
            if (!window.isAvailable()) {
                window.setAvailable(true);
            }
            if (!window.isActive() && Registry.is((String)"cidr.test.framework.activate.test.scan.tab")) {
                window.activate(null);
            }
            if ((consoleView = (ConsoleView)CONSOLE_VIEW.get((UserDataHolder)content)) != null) {
                consoleView.clear();
            }
            contentManager.setSelectedContent(content);
            return content;
        });
    }

    public static interface CidrTestConfigurationNeedBeforeRunTask {
    }

    public static interface CidrBeforeRunTaskConverter
    extends RunConfigurationConverter {
        public String getId();

        default public boolean convertRunConfigurationOnDemand(@NotNull Element element) {
            if (!this.getId().equals(element.getAttributeValue("type"))) {
                return false;
            }
            Element method = element.getChild("method");
            if (method != null && method.getAttributeValue("v") != null && method.getChildren("option").stream().noneMatch(option -> CidrBeforeTestRunTaskProvider.BEFORE_TEST_ID.equals(option.getAttributeValue("name")))) {
                Element option2 = new Element("option");
                option2.setAttribute("name", CidrBeforeTestRunTaskProvider.BEFORE_TEST_ID);
                option2.setAttribute("enabled", Boolean.TRUE.toString());
                method.addContent(option2);
                return true;
            }
            return false;
        }
    }

    private static final class BeforeTestRunTask
    extends BeforeRunTask<BeforeTestRunTask> {
        private BeforeTestRunTask() {
            super(ID);
            this.setEnabled(true);
        }
    }

    private static final class StopAction
    extends DumbAwareAction {
        @NotNull
        private final Content myContent;

        private StopAction(@NotNull Content content) {
            super(IdeBundle.message((String)"action.stop", (Object[])new Object[0]), null, AllIcons.Actions.Suspend);
            this.myContent = content;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ProgressIndicator indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)this.myContent);
            if (indicator != null) {
                indicator.cancel();
            }
        }

        public void update(@NotNull AnActionEvent event) {
            ProgressIndicator indicator = (ProgressIndicator)PROGRESS.get((UserDataHolder)this.myContent);
            event.getPresentation().setEnabled(indicator != null && indicator.isRunning());
        }
    }
}

