/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrAbstractTestConsoleProperties
extends SMTRunnerConsoleProperties
implements SMCustomMessagesParsing {
    @RegExp
    public static final String FILE_LOCATION_M = "((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: ";
    @RegExp
    public static final String FILE_LOCATION = "(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)[)]?: )?";
    private final ExecutionTarget myTarget;

    protected CidrAbstractTestConsoleProperties(@NotNull RunConfiguration config, @NonNls @NotNull String testFrameworkName, @NotNull Executor executor, @NotNull ExecutionTarget target) {
        super(config, testFrameworkName, executor);
        this.addStackTraceFilter((lineTest, entireLength) -> {
            Matcher m = this.getAssertionPattern().matcher(lineTest);
            if (m.find()) {
                int lineNumber;
                String path = m.group(1);
                String lineString = m.group(2);
                VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(CidrAbstractTestConsoleProperties.normalizePath(path));
                if (file2 == null) {
                    return null;
                }
                try {
                    lineNumber = Integer.parseInt(lineString) - 1;
                }
                catch (NumberFormatException e) {
                    return null;
                }
                return new Filter.Result(m.start(1), m.end(2), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.getProject(), file2, lineNumber){

                    @Nullable
                    protected Integer calculateOffset(@Nullable Document document, int documentLine, int documentColumn) {
                        return document == null || documentLine < 0 || document.getLineCount() <= documentLine ? null : Integer.valueOf(DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)documentLine));
                    }
                }, false);
            }
            return null;
        });
        this.myTarget = target;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        return this.myTarget;
    }

    @Nullable
    public String getTargetNameForRerun() {
        RunProfile configuration2 = this.getConfiguration();
        String targetName = null;
        if (configuration2 instanceof CidrRunConfiguration) {
            targetName = ((CidrRunConfiguration)configuration2).suggestNameForTarget();
        }
        return targetName;
    }

    @NotNull
    protected abstract Pattern getAssertionPattern();

    @NotNull
    public static String normalizePath(@NotNull String fileName) {
        if (ApplicationManager.getApplication().isUnitTestMode() && FileUtil.isAbsolute((String)fileName)) {
            try {
                fileName = new File(fileName).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fileName;
    }
}

