/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XTestValueNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerTestCase;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingWithDebugProjectTestCase;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public abstract class CidrDebuggingSTLValuesTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggingWithDebugProjectTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE> {
    private static final int MAX_PRESENTED_ELEMENTS = 50;

    public CidrDebuggingSTLValuesTestCase(String targetName, DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, targetName, fixtureProjectFileRelativePath);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.waitForResolve();
    }

    @Test
    public void testValuesOfSTLMaps() throws Exception {
        this.doTestValuesOfSTLMaps(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS);
    }

    @Test
    public void testValuesOfSTLSequences() throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_UNORDERED_MAP);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers");
        List<XValue> vars = this.collectVars(1);
        CidrDebuggingSTLValuesTestCase.checkPairsSequence(vars, "pair_vector", this.selectDriver(null, "size=50"));
        CidrDebuggingSTLValuesTestCase.checkPairsSequence(vars, "pair_deque", this.selectDriver(null, "size=50"));
        CidrDebuggingSTLValuesTestCase.checkPairsSequence(vars, "pair_list", this.selectDriver(null, "size=50"));
        CidrDebuggingSTLValuesTestCase.checkStringsSequence(vars, "str_list");
        CidrDebuggingSTLValuesTestCase.checkStringsSequence(vars, "str_vec");
    }

    private static void checkStringsSequence(List<XValue> vars, String name) {
        String[] values = new String[]{"abc", "abcd", "abcde", "abcdef"};
        XValue str_list = CidrDebuggingFixture.findVar(vars, name);
        List strings = XDebuggerAssertions.collectChildren((XValueContainer)str_list);
        CidrDebuggingSTLValuesTestCase.assertSize((int)4, (Collection)strings);
        for (int i = 0; i < strings.size(); ++i) {
            XDebuggerAssertions.assertVariableValue((XValue)((XValue)strings.get(i)), (String)("[" + i + "]"), (String)("\"" + values[i] + "\""));
        }
    }

    private static void checkPairsSequence(List<XValue> vars, String name, @Nullable String value) {
        XValue sequence = CidrDebuggingFixture.findVar(vars, name);
        XDebuggerAssertions.assertVariableValue((XValue)sequence, (String)name, (String)value);
        List values = XDebuggerAssertions.collectChildren((XValueContainer)sequence);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)values);
        for (int i = 0; i < 50; ++i) {
            XDebuggerAssertions.assertVariableTypeMatches((XValue)((XValue)values.get(i)), (String)("[" + i + "]"), (String)"std::(.+?::)?pair<int, int>", null, (Boolean)true);
            List children = XDebuggerAssertions.collectChildren((XValueContainer)((XValueContainer)values.get(i)));
            XDebuggerAssertions.assertVariableValue((XValue)((XValue)children.get(0)), (String)"first", (String)String.valueOf(i));
            XDebuggerAssertions.assertVariableValue((XValue)((XValue)children.get(1)), (String)"second", (String)String.valueOf(i * i));
        }
    }

    @Test
    public void testValuesOfSTLSets() throws Exception {
        int i;
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_UNORDERED_MAP);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers");
        List<XValue> vars = this.collectVars(1);
        XValue set = CidrDebuggingFixture.findVar(vars, "int_set");
        XDebuggerAssertions.assertVariable((XValue)set, (String)"int_set", null, (String)this.selectDriver(null, "size=50"), (Boolean)true);
        List setElements = XDebuggerAssertions.collectChildren((XValueContainer)set);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)setElements);
        XValue multiset = CidrDebuggingFixture.findVar(vars, "int_multiset");
        XDebuggerAssertions.assertVariable((XValue)multiset, (String)"int_multiset", null, (String)this.selectDriver(null, "size=100"), (Boolean)true);
        List multisetElements = XDebuggerAssertions.collectChildren((XValueContainer)multiset);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)multisetElements);
        for (int i2 = 0; i2 < 50; ++i2) {
            String name = "[" + i2 + "]";
            XDebuggerAssertions.assertVariableTypeMatches((XValue)((XValue)setElements.get(i2)), (String)name, (String)CidrDebuggingSTLValuesTestCase.treesetValueType("int"), (String)Integer.toString(i2 * i2), (Boolean)false);
            int j = i2 / 2;
            XDebuggerAssertions.assertVariableTypeMatches((XValue)((XValue)multisetElements.get(i2)), (String)name, (String)CidrDebuggingSTLValuesTestCase.treesetValueType("int"), (String)Integer.toString(j * j), (Boolean)false);
        }
        XValue hashset = CidrDebuggingFixture.findVar(vars, "int_hash_set");
        XDebuggerAssertions.assertVariable((XValue)hashset, (String)"int_hash_set", null, (String)this.selectDriver(null, "size=50"), (Boolean)true);
        List hashsetElements = XDebuggerAssertions.collectChildren((XValueContainer)hashset);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)hashsetElements);
        HashSet<CallSite> setNames = new HashSet<CallSite>();
        HashSet<String> setValues = new HashSet<String>();
        for (i = 0; i < 50; ++i) {
            String value = Integer.toString(i * i);
            setValues.add(value);
            setNames.add((CallSite)((Object)("[" + i + "]")));
        }
        for (i = 0; i < 50; ++i) {
            XTestValueNode node = XDebuggerAssertions.computePresentation((XValue)((XValue)hashsetElements.get(i)));
            CidrDebuggingSTLValuesTestCase.assertNotNull((Object)node.myValue);
            CidrDebuggingSTLValuesTestCase.assertTrue((boolean)setValues.remove(node.myValue));
            CidrDebuggingSTLValuesTestCase.assertNotNull((Object)node.myName);
            CidrDebuggingSTLValuesTestCase.assertTrue((boolean)setNames.remove(node.myName));
            CidrDebuggingSTLValuesTestCase.assertMatches(node.myType, CidrDebuggingSTLValuesTestCase.hashValueType("int"));
            CidrDebuggingSTLValuesTestCase.assertFalse((boolean)node.myHasChildren);
        }
        CidrDebuggingSTLValuesTestCase.assertEmpty(setValues);
        CidrDebuggingSTLValuesTestCase.assertEmpty(setNames);
    }

    protected void doTestValuesOfStdString(String value) throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_UNORDERED_MAP);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers");
        List<XValue> vars = this.collectVars(1);
        XDebuggerAssertions.assertVariable(vars, (String)"str1", null, (String)value, null);
        XDebuggerAssertions.assertVariable(vars, (String)"str2", null, (String)value, null);
        XDebuggerAssertions.assertVariable(vars, (String)"str", null, (String)value, null);
    }

    @Test
    public void testValuesOfStdString() throws Exception {
        this.doTestValuesOfStdString("\"abcd\"");
    }

    @Test
    public void testValuesOfSTLMapsByRef() throws Exception {
        this.assumeBackendKind().isNotLLDB();
        this.doTestValuesOfSTLMaps(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_BY_REF);
    }

    @Test
    public void testValuesOfSTLMapsByConstRef() throws Exception {
        this.assumeBackendKind().isNotLLDB();
        this.doTestValuesOfSTLMaps(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_BY_CONST_REF);
    }

    @Test
    public void testValuesOfSTLMapsByPtr() throws Exception {
        this.doTestValuesOfSTLMaps(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_BY_PTR);
    }

    @Test
    public void testValuesOfSTLMapsByConstPtr() throws Exception {
        this.doTestValuesOfSTLMaps(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_BY_CONST_PTR);
    }

    protected void doTestValuesOfSTLMaps(@NotNull VirtualFile virtualFile, int line) throws Exception {
        int i;
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)virtualFile, (int)line);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers");
        List<XValue> vars = this.collectVars(0);
        XValue map2 = CidrDebuggingFixture.findVar(vars, "int_map");
        XDebuggerAssertions.assertVariableValueMatches((XValue)map2, (String)"int_map", null, (String)this.selectDriverRegExp(null, ".*\\bsize=50"), (Boolean)true);
        List mapElements = XDebuggerAssertions.collectChildren((XValueContainer)map2);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)mapElements);
        XValue multimap = CidrDebuggingFixture.findVar(vars, "int_multimap");
        XDebuggerAssertions.assertVariableValueMatches((XValue)multimap, (String)"int_multimap", null, (String)this.selectDriverRegExp(null, ".*\\bsize=100"), (Boolean)true);
        List multimapElements = XDebuggerAssertions.collectChildren((XValueContainer)multimap);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)multimapElements);
        XValue aa = CidrDebuggingFixture.findVar(vars, "aa_map");
        XDebuggerAssertions.assertVariableValueMatches((XValue)aa, (String)"aa_map", null, (String)this.selectDriverRegExp(null, ".*\\bsize=50"), (Boolean)true);
        List aaElements = XDebuggerAssertions.collectChildren((XValueContainer)aa);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)aaElements);
        XValue aa2 = CidrDebuggingFixture.findVar(vars, "aa2_map");
        XDebuggerAssertions.assertVariableValueMatches((XValue)aa2, (String)"aa2_map", null, (String)this.selectDriverRegExp(null, ".*\\bsize=50"), (Boolean)true);
        List aa2Elements = XDebuggerAssertions.collectChildren((XValueContainer)aa2);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)aa2Elements);
        XValue hashmap = CidrDebuggingFixture.findVar(vars, "int_hash_map");
        XDebuggerAssertions.assertVariableValueMatches((XValue)hashmap, (String)"int_hash_map", null, (String)this.selectDriverRegExp(null, ".*\\bsize=50"), (Boolean)true);
        List hashmapElements = XDebuggerAssertions.collectChildren((XValueContainer)hashmap);
        CidrDebuggingSTLValuesTestCase.assertSize((int)50, (Collection)hashmapElements);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (i = 0; i < 50; ++i) {
            hashMap.put(Integer.toString(i), Integer.toString(i * i));
        }
        for (i = 0; i < 50; ++i) {
            String name = "[" + i + "]";
            XValue var = (XValue)mapElements.get(i);
            XDebuggerAssertions.assertVariable((XValue)var, (String)name, null, (String)"", (Boolean)true);
            CidrDebuggingSTLValuesTestCase.checkMapPair(var, null, i, Integer.toString(i * i), false);
            if (this.libcContainersSupportedSupported()) {
                CidrDebuggingSTLValuesTestCase.checkHashMapValue((XValue)hashmapElements.get(i), this.selectDriver("const int", null), this.selectDriver("long", null), hashMap);
            }
            XDebuggerAssertions.assertVariableTypeMatches((XValue)((XValue)aaElements.get(i)), (String)name, (String)CidrDebuggingSTLValuesTestCase.mapKeyValue("int", "AA"), null, (Boolean)true);
            List<XValue> keyValue = CidrDebuggingSTLValuesTestCase.checkMapPair((XValue)aaElements.get(i), "AA", i, "", true);
            List ab = XDebuggerAssertions.collectChildren((XValueContainer)((XValueContainer)keyValue.get(1)));
            CidrDebuggingSTLValuesTestCase.assertSize((int)2, (Collection)ab);
            XDebuggerAssertions.assertVariable((XValue)((XValue)ab.get(0)), (String)"a", (String)"int", (String)Integer.toString(i * i), (Boolean)false);
            XDebuggerAssertions.assertVariable((XValue)((XValue)ab.get(1)), (String)"b", (String)"char", (String)"65 'A'", (Boolean)false);
            XDebuggerAssertions.assertVariableTypeMatches((XValue)((XValue)aa2Elements.get(i)), (String)name, (String)CidrDebuggingSTLValuesTestCase.mapKeyValue("AA", "AA"), null, (Boolean)true);
            keyValue = CidrDebuggingSTLValuesTestCase.checkMapPair((XValue)aa2Elements.get(i), "AA", "", "", true, true);
            List ab0 = XDebuggerAssertions.collectChildren((XValueContainer)((XValueContainer)keyValue.get(0)));
            CidrDebuggingSTLValuesTestCase.assertSize((int)2, (Collection)ab0);
            List ab1 = XDebuggerAssertions.collectChildren((XValueContainer)((XValueContainer)keyValue.get(1)));
            CidrDebuggingSTLValuesTestCase.assertSize((int)2, (Collection)ab1);
            XDebuggerAssertions.assertVariable((XValue)((XValue)ab0.get(0)), (String)"a", (String)"int", (String)Integer.toString(i), (Boolean)false);
            XDebuggerAssertions.assertVariable((XValue)((XValue)ab0.get(1)), (String)"b", (String)"char", (String)"65 'A'", (Boolean)false);
            XDebuggerAssertions.assertVariable((XValue)((XValue)ab1.get(0)), (String)"a", (String)"int", (String)Integer.toString(i * i), (Boolean)false);
            XDebuggerAssertions.assertVariable((XValue)((XValue)ab1.get(1)), (String)"b", (String)"char", (String)"65 'A'", (Boolean)false);
        }
    }

    private static List<XValue> checkMapPair(XValue var, @Nullable String type, int key, String value, boolean hasChildren) {
        return CidrDebuggingSTLValuesTestCase.checkMapPair(var, type, Integer.toString(key), value, false, hasChildren);
    }

    private static List<XValue> checkMapPair(XValue var, @Nullable String type, String key, String value, boolean keyHasChildren, boolean valueHasChildren) {
        List keyValue = XDebuggerAssertions.collectChildren((XValueContainer)var);
        CidrDebuggingSTLValuesTestCase.assertSize((int)2, (Collection)keyValue);
        XDebuggerAssertions.assertVariable((XValue)((XValue)keyValue.get(0)), (String)"first", null, (String)key, (Boolean)keyHasChildren);
        XDebuggerAssertions.assertVariable((XValue)((XValue)keyValue.get(1)), (String)"second", (String)type, (String)value, (Boolean)valueHasChildren);
        return keyValue;
    }

    private static void checkHashMapValue(XValue var, String keyType, String valueType, HashMap<String, String> map2) {
        List keyValue = XDebuggerAssertions.collectChildren((XValueContainer)var);
        CidrDebuggingSTLValuesTestCase.assertSize((int)2, (Collection)keyValue);
        XTestValueNode keyNode = XDebuggerAssertions.computePresentation((XValue)((XValue)keyValue.get(0)));
        XDebuggerAssertions.assertVariable((XTestValueNode)keyNode, (String)"first", (String)keyType, null, (Boolean)false);
        CidrDebuggingSTLValuesTestCase.assertNotNull((Object)keyNode.myValue);
        String expectedValue = map2.remove(keyNode.myValue);
        CidrDebuggingSTLValuesTestCase.assertNotNull((Object)expectedValue);
        XDebuggerAssertions.assertVariable((XValue)var, null, null, (String)"", (Boolean)true);
        XDebuggerAssertions.assertVariable((XValue)((XValue)keyValue.get(1)), (String)"second", (String)valueType, (String)expectedValue, (Boolean)false);
    }

    @Test
    public void testArrayCppClassMemberChildren() throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers");
        XValue var = CidrDebuggingFixture.findVar(this.collectVars(0), "testClass");
        List testClassChildren = XDebuggerAssertions.collectChildren((XValueContainer)var);
        CidrDebuggingSTLValuesTestCase.assertSize((int)1, (Collection)testClassChildren);
        XDebuggerAssertions.assertVariable((Collection)testClassChildren, (String)"mTileMod", null, null, (Boolean)true);
        List elements = XDebuggerAssertions.collectChildren((XValueContainer)((XValueContainer)testClassChildren.get(0)));
        CidrDebuggingSTLValuesTestCase.assertSize((int)5, (Collection)elements);
        XDebuggerAssertions.assertVariable((XValue)((XValue)elements.get(0)), (String)"[0]", null, null, (Boolean)true);
        List tileMembers = XDebuggerAssertions.collectChildren((XValueContainer)((XValueContainer)elements.get(0)));
        CidrDebuggingSTLValuesTestCase.assertSize((int)2, (Collection)tileMembers);
        XDebuggerAssertions.assertVariable((Collection)tileMembers, (String)"mValue", (String)"int", (String)"1", (Boolean)false);
        XDebuggerAssertions.assertVariable((Collection)tileMembers, (String)"mOtherValue", (String)"int", (String)"2", (Boolean)false);
    }

    @Test
    public void testValuesOfStringStream() throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_STRING_STREAM);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_stringstream");
        XDebuggerAssertions.assertVariable(this.collectVars(0), (String)"sstream", null, (String)"", (Boolean)SystemInfo.isMac);
    }

    @Test
    public void testValuesOfUninitializedStringStream() throws Exception {
        CidrDebuggerSettings.getInstance().setValuesFilterEnabled(false);
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_STRING_STREAM_UNINITIALIZED);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_stringstream");
        XDebuggerAssertions.assertVariable(this.collectVars(1), (String)"sstream", null, (String)"", null);
    }

    @Test
    public void testUninitializedSTLContainers() throws Exception {
        CidrDebuggerSettings.getInstance().setValuesFilterEnabled(false);
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_UNINITIALIZED);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers");
        List<XValue> vars = this.collectVars(0);
        XDebuggerAssertions.assertVariable(vars, (String)"int_map", null, null, null);
        XDebuggerAssertions.assertVariable(vars, (String)"int_multimap", null, null, null);
        XDebuggerAssertions.assertVariable(vars, (String)"aa_map", null, null, null);
        XDebuggerAssertions.assertVariable(vars, (String)"aa2_map", null, null, null);
    }

    @Test
    public void testUninitializedSTLContainersWithFiltering() throws Exception {
        CidrDebuggerSettings.getInstance().setValuesFilterEnabled(true);
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_UNINITIALIZED);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers");
        List<XValue> vars = this.collectVars(0);
        CidrDebuggingSTLValuesTestCase.assertEmpty(vars);
    }

    @Test
    public void testSTLEmptyList() throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_EMPTY_LIST);
        this.waitForResolve();
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("stl_empty_list");
        List<XValue> vars = this.collectVars(0);
        XValue var = CidrDebuggingFixture.findVar(vars, "empty_list");
        XDebuggerAssertions.assertVariableTypeMatches((XValue)var, (String)"empty_list", (String)"std::(.+?::)?list<do_not_instantiate_me_except_below(, std::(.+?::)?allocator.*)?>");
        CidrDebuggingSTLValuesTestCase.assertSize((int)0, (Collection)XDebuggerAssertions.collectChildren((XValueContainer)var));
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        vars = this.collectVars(0);
        var = CidrDebuggingFixture.findVar(vars, "empty_list");
        XDebuggerAssertions.assertVariableTypeMatches((XValue)var, (String)"empty_list", (String)"std::(.+?::)?list<do_not_instantiate_me_except_below(, std::(.+?::)?allocator.*)?>");
        CidrDebuggingSTLValuesTestCase.assertSize((int)0, (Collection)XDebuggerAssertions.collectChildren((XValueContainer)var));
    }

    @Test
    public void testElementContainersTypes() throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_TYPES);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers_types");
        List<XValue> vars = this.collectVars(0);
        CidrDebuggingSTLValuesTestCase.doTestElementContainer(vars, "str_set", "std::(.+?::)?set<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?less, std::(.+?::)?allocator)?>", CidrDebuggingSTLValuesTestCase.treesetValueType(CidrDebuggingSTLValuesTestCase.stringType()));
        CidrDebuggingSTLValuesTestCase.doTestElementContainer(vars, "mult_str_set", "std::(.+?::)?multiset<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?less, std::(.+?::)?allocator)?>", CidrDebuggingSTLValuesTestCase.treesetValueType(CidrDebuggingSTLValuesTestCase.stringType()));
        CidrDebuggingSTLValuesTestCase.doTestElementContainer(vars, "unord_str_set", "std::(.+?::)?unordered_set<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?hash, std::(.+?::)?equal_to, std::(.+?::)?allocator(, false)?)?>", CidrDebuggingSTLValuesTestCase.hashValueType(CidrDebuggingSTLValuesTestCase.stringType()));
        CidrDebuggingSTLValuesTestCase.doTestElementContainer(vars, "str_plain_array", CidrDebuggingSTLValuesTestCase.stringType() + " \\[1\\]", CidrDebuggingSTLValuesTestCase.stringType());
        CidrDebuggingSTLValuesTestCase.doTestElementContainer(vars, "str_vector", "std::(.+?::)?vector<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?allocator)?>", CidrDebuggingSTLValuesTestCase.stringType());
        CidrDebuggingSTLValuesTestCase.doTestElementContainer(vars, "str_list", "std::(.+?::)?list<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?allocator)?>", CidrDebuggingSTLValuesTestCase.stringType());
        CidrDebuggingSTLValuesTestCase.doTestElementContainer(vars, "str_deque", "std::(.+?::)?deque<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?allocator)?>", CidrDebuggingSTLValuesTestCase.stringType());
        if (this.allContainersSupportedSupported()) {
            XValue stack = CidrDebuggingFixture.findVar(vars, "str_stack");
            List stackElements = XDebuggerAssertions.collectChildren((XValueContainer)stack);
            CidrDebuggingSTLValuesTestCase.assertSize((int)1, (Collection)stackElements);
            if ("c".equals(((XNamedValue)stackElements.get(0)).getName())) {
                CidrDebuggingSTLValuesTestCase.doTestElementContainer(stackElements, "c", "std::(.+?::)?stack<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?deque)?>(::container_type)?", CidrDebuggingSTLValuesTestCase.stringType());
            } else {
                CidrDebuggingSTLValuesTestCase.doTestElementContainer(stack, stackElements, "str_stack", "std::(.+?::)?stack<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?deque)?>", CidrDebuggingSTLValuesTestCase.stringType());
            }
            CidrDebuggingSTLValuesTestCase.doTestElementContainer(vars, "str_queue", "std::(.+?::)?queue<" + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?deque)?>", CidrDebuggingSTLValuesTestCase.stringType());
        }
    }

    @Test
    public void testMapChildren() throws Exception {
        final FutureResult stoppedThreadResult = new FutureResult();
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stoppedThreadResult.set((Object)stopPlace.thread.getId());
            }
        });
        this.loadApp("stl_map_with_elements");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_MAP_WITH_ELEMENTS_1);
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_MAP_WITH_ELEMENTS_2);
        this.myInferior.start();
        Long stoppedThread = (Long)CidrExecutionFixture.waitFor(stoppedThreadResult);
        CidrDebuggingSTLValuesTestCase.assertNotNull((Object)stoppedThread);
        List vars = this.myDriver.getVariables(stoppedThread.longValue(), 0);
        LLValue map2 = CidrDebuggingFixture.findVariable("m", vars);
        HashMap<String, String> expectedElements = new HashMap<String, String>();
        for (int i = 0; i < 20; ++i) {
            expectedElements.put(Integer.toString(i), Integer.toString(i * 2));
        }
        CidrDebuggingFixture.assertLLValue(this.myDriver, map2, "m", null, null, (Boolean)true, (Ref<Integer>)Ref.create((Object)this.selectDriver(null, 10)));
        DebuggerDriver.ResultList children = this.myDriver.getVariableChildren(map2, 2, 5);
        CidrDebuggingFixture.assertResultList(children, 5, true);
        for (LLValue v : children.list) {
            this.checkMapElement(expectedElements, v);
        }
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren((LLValue)children.list.get(0), 0, 2), 2, false);
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren((LLValue)children.list.get(0), 0, 1), 1, true);
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren((LLValue)children.list.get(0), 1, 1), 1, false);
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren((LLValue)children.list.get(0), 2, 2), 0, false);
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren((LLValue)children.list.get(0), 0, 5), 2, false);
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren(map2, 9, 5), 1, false);
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren(map2, 0, 10), 10, false);
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren(map2, 0, 9), 9, true);
        CidrDebuggingFixture.assertResultList(this.myDriver.getVariableChildren(map2, 10, 5), 0, false);
        this.myDriver.resume();
        stoppedThread = (Long)CidrExecutionFixture.waitFor(stoppedThreadResult);
        CidrDebuggingSTLValuesTestCase.assertNotNull((Object)stoppedThread);
        vars = this.myDriver.getVariables(stoppedThread.longValue(), 0);
        map2 = CidrDebuggingFixture.findVariable("m", vars);
        CidrDebuggingFixture.assertLLValue(this.myDriver, map2, "m", null, null, (Boolean)true, (Ref<Integer>)Ref.create((Object)this.selectDriver(null, 20)));
        children = this.myDriver.getVariableChildren(map2, 9, 5);
        CidrDebuggingFixture.assertResultList(children, 5, true);
        for (LLValue v : children.list) {
            this.checkMapElement(expectedElements, v);
        }
    }

    @Test
    public void testPartialContainersValues() throws Exception {
        int i;
        final FutureResult stoppedThreadResult = new FutureResult();
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stoppedThreadResult.set((Object)stopPlace.thread.getId());
            }
        });
        this.loadApp("stl_containers_large_small");
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_LARGE_SMALL);
        this.myInferior.start();
        Long stoppedThread = (Long)CidrExecutionFixture.waitFor(stoppedThreadResult);
        CidrDebuggingSTLValuesTestCase.assertNotNull((Object)stoppedThread);
        List vars = this.myDriver.getVariables(stoppedThread.longValue(), 0);
        LLValue largeList = CidrDebuggingFixture.findVariable("largeList", vars);
        LLValue largeMap = CidrDebuggingFixture.findVariable("largeMap", vars);
        LLValue smallList = CidrDebuggingFixture.findVariable("smallList", vars);
        LLValue smallMap = CidrDebuggingFixture.findVariable("smallMap", vars);
        CidrDebuggingFixture.assertLLValue(this.myDriver, largeList, null, null, null, (Boolean)true, (Ref<Integer>)Ref.create((Object)this.selectDriver(null, 200)));
        CidrDebuggingFixture.assertLLValue(this.myDriver, largeMap, null, null, null, (Boolean)true, (Ref<Integer>)Ref.create((Object)this.selectDriver(null, 200)));
        CidrDebuggingFixture.assertLLValue(this.myDriver, smallList, null, null, null, (Boolean)true, (Ref<Integer>)Ref.create((Object)this.selectDriver(null, 20)));
        CidrDebuggingFixture.assertLLValue(this.myDriver, smallMap, null, null, null, (Boolean)true, (Ref<Integer>)Ref.create((Object)this.selectDriver(null, 20)));
        HashMap<String, String> largeHashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < 200; ++i2) {
            largeHashMap.put(Integer.toString(i2), Integer.toString(i2));
        }
        HashMap<String, String> smallHashMap = new HashMap<String, String>();
        for (i = 0; i < 20; ++i) {
            smallHashMap.put(Integer.toString(i), Integer.toString(i));
        }
        for (i = 0; i < 200; i += 50) {
            DebuggerDriver.ResultList listChildren = this.myDriver.getVariableChildren(largeList, i, 50);
            CidrDebuggingFixture.assertResultList(listChildren, 50, i < 150);
            DebuggerDriver.ResultList mapChildren = this.myDriver.getVariableChildren(largeMap, i, 50);
            CidrDebuggingFixture.assertResultList(listChildren, 50, i < 150);
            for (int j = 0; j < 50; ++j) {
                CidrDebuggingFixture.assertLLValue(this.myDriver, (LLValue)listChildren.list.get(j), "[" + (i + j) + "]", "int", Integer.toString(i + j), (Boolean)false, 0);
                this.checkMapElement(largeHashMap, (LLValue)mapChildren.list.get(j));
            }
        }
        CidrDebuggingSTLValuesTestCase.assertEquals((int)0, (int)largeHashMap.size());
        DebuggerDriver.ResultList children = this.myDriver.getVariableChildren(smallList, 0, 20);
        DebuggerDriver.ResultList mapChildren = this.myDriver.getVariableChildren(smallMap, 0, 20);
        CidrDebuggingFixture.assertResultList(children, 20, false);
        CidrDebuggingFixture.assertResultList(mapChildren, 20, false);
        for (int i3 = 0; i3 < 20; ++i3) {
            CidrDebuggingFixture.assertLLValue(this.myDriver, (LLValue)children.list.get(i3), "[" + i3 + "]", "int", Integer.toString(i3), (Boolean)false, 0);
            this.checkMapElement(smallHashMap, (LLValue)mapChildren.list.get(i3));
        }
        CidrDebuggingSTLValuesTestCase.assertEquals((int)0, (int)smallHashMap.size());
    }

    private void checkMapElement(HashMap<String, String> largeHashMap, LLValue mapElem) throws Exception {
        CidrDebuggingFixture.assertLLValue(this.myDriver, mapElem, null, null, null, (Boolean)true, 2);
        CidrDebuggingSTLValuesTestCase.assertMatches(mapElem.getType(), CidrDebuggingSTLValuesTestCase.mapKeyValue("int", "int"));
        DebuggerDriver.ResultList mapPair = this.myDriver.getVariableChildren(mapElem, 0, 2);
        CidrDebuggingFixture.assertResultList(mapPair, 2, false);
        String expectedKey = this.myDriver.getData((LLValue)mapPair.list.get(0)).getValue();
        String expectedValue = largeHashMap.remove(expectedKey);
        CidrDebuggingSTLValuesTestCase.assertNotNull((Object)expectedValue);
        CidrDebuggingSTLValuesTestCase.assertEquals((String)expectedValue, (String)this.myDriver.getData((LLValue)mapPair.list.get(1)).getValue());
        CidrDebuggingFixture.assertLLValue(this.myDriver, mapElem, "[" + expectedKey + "]", null, "", null, null);
        CidrDebuggingFixture.assertLLValue(this.myDriver, (LLValue)mapPair.list.get(0), "first", "const int", expectedKey, (Boolean)false, 0);
        CidrDebuggingFixture.assertLLValue(this.myDriver, (LLValue)mapPair.list.get(1), "second", "int", expectedValue, (Boolean)false, 0);
    }

    private static void doTestElementContainer(@NotNull List<XValue> vars, @NotNull String contName, @NotNull @RegExp String expectedContType, @NotNull @RegExp String expectedElemType) {
        XValue cont = CidrDebuggingFixture.findVar(vars, contName);
        List contElements = XDebuggerAssertions.collectChildren((XValueContainer)cont);
        CidrDebuggingSTLValuesTestCase.doTestElementContainer(cont, contElements, contName, expectedContType, expectedElemType);
    }

    private static void doTestElementContainer(@NotNull XValue cont, @NotNull List<XValue> contElements, @NotNull String contName, @RegExp @NotNull String expectedContType, @RegExp @NotNull String expectedElemType) {
        XDebuggerAssertions.assertVariableTypeMatches((XValue)cont, (String)contName, (String)expectedContType, null, (Boolean)true);
        CidrDebuggingSTLValuesTestCase.assertSize((int)1, contElements);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)contElements.get(0), (String)"[0]", (String)expectedElemType, (String)"\"e\"", (Boolean)true);
    }

    @Test
    public void testMapContainersTypes() throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_CONTAINERS_TYPES);
        this.waitForResolve();
        this.startDebugSessionAndWaitForPause("stl_containers_types");
        List<XValue> vars = this.collectVars(0);
        CidrDebuggingSTLValuesTestCase.doTestStringMapContainer(vars, "str_map", "std::(.+?::)?map<" + CidrDebuggingSTLValuesTestCase.stringType() + ", " + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?less, std::(.+?::)?allocator)?>", CidrDebuggingSTLValuesTestCase.mapKeyValue(CidrDebuggingSTLValuesTestCase.stringType(), CidrDebuggingSTLValuesTestCase.stringType()));
        if (this.allContainersSupportedSupported()) {
            CidrDebuggingSTLValuesTestCase.doTestStringMapContainer(vars, "str_multimap", "std::(.+?::)?multimap<" + CidrDebuggingSTLValuesTestCase.stringType() + ", " + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?less, std::(.+?::)?allocator)?>", CidrDebuggingSTLValuesTestCase.mapKeyValue(CidrDebuggingSTLValuesTestCase.stringType(), CidrDebuggingSTLValuesTestCase.stringType()));
            CidrDebuggingSTLValuesTestCase.doTestStringMapContainer(vars, "unord_map", "std::(.+?::)?unordered_map<" + CidrDebuggingSTLValuesTestCase.stringType() + ", " + CidrDebuggingSTLValuesTestCase.stringType() + "(, std::(.+?::)?hash, std::(.+?::)?equal_to, std::(.+?::)?allocator(, false)?)?>", CidrDebuggingSTLValuesTestCase.mapKeyValue(CidrDebuggingSTLValuesTestCase.stringType(), CidrDebuggingSTLValuesTestCase.stringType()));
        }
    }

    private static void doTestStringMapContainer(@NotNull List<XValue> vars, @NotNull String contName, @RegExp String expectedContType, @RegExp String expectedElementType) {
        XValue cont = CidrDebuggingFixture.findVar(vars, contName);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)cont, null, (String)expectedContType, null, (Boolean)true);
        List contElements = XDebuggerAssertions.collectChildren((XValueContainer)cont);
        CidrDebuggingSTLValuesTestCase.assertSize((int)1, (Collection)contElements);
        XValue element = (XValue)contElements.get(0);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)element, (String)"[0]", (String)expectedElementType, (String)"", (Boolean)true);
        List elementChildren = XDebuggerAssertions.collectChildren((XValueContainer)element);
        CidrDebuggingSTLValuesTestCase.assertSize((int)2, (Collection)elementChildren);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)((XValue)elementChildren.get(0)), (String)"first", (String)("(const )?" + CidrDebuggingSTLValuesTestCase.stringType()), (String)"\"k\"", (Boolean)true);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)((XValue)elementChildren.get(1)), (String)"second", (String)("(const )?" + CidrDebuggingSTLValuesTestCase.stringType()), (String)"\"v\"", (Boolean)true);
    }

    @Test
    public void testMapMultisetToDouble() throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_MAP_MULTISET_TO_DOUBLE_START);
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_MAP_MULTISET_TO_DOUBLE_END);
        this.waitForResolve();
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("stl_map_multiset_to_double");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_MAP_MULTISET_TO_DOUBLE_START);
        if (this.myBackend == DebuggerDriverKind.GDB) {
            for (int i = 0; i < 7; ++i) {
                this.collectVars(0);
                this.getSession().stepOver(false);
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
            }
        } else {
            this.collectVars(0);
            this.getSession().resume();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        }
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_MAP_MULTISET_TO_DOUBLE_END);
        List<XValue> vars = this.collectVars(0);
        XValue vec = CidrDebuggingFixture.findVar(vars, "vec");
        XDebuggerAssertions.assertVariableTypeMatches((XValue)vec, (String)"vec", (String)"std::(.+?::)?vector<std::(.+?::)?map(<std::(.+?::)?multiset(<int>)?, double>)?(, std::(.+?::)?allocator)? ?>");
        List vecElements = XDebuggerAssertions.collectChildren((XValueContainer)vec);
        CidrDebuggingSTLValuesTestCase.assertSize((int)1, (Collection)vecElements);
        XValue map2 = (XValue)vecElements.get(0);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)map2, (String)"[0]", (String)"std::(.+?::)?map<std::(.+?::)?multiset(<int>)?, double(, std::(.+?::)?less, std::(.+?::)?allocator)? ?>");
        List mapElements = XDebuggerAssertions.collectChildren((XValueContainer)map2);
        CidrDebuggingSTLValuesTestCase.assertSize((int)1, (Collection)mapElements);
        XValue pair = (XValue)mapElements.get(0);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)pair, (String)"[0]", (String)"std::(.+?::)?pair<const std::(.+?::)?multiset(<int>)?, double>");
        List pairElements = XDebuggerAssertions.collectChildren((XValueContainer)pair);
        CidrDebuggingSTLValuesTestCase.assertSize((int)2, (Collection)pairElements);
        XValue first = (XValue)pairElements.get(0);
        XValue second = (XValue)pairElements.get(1);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)first, (String)"first", (String)"const std::(.+?::)?multiset<int(, std::(.+?::)?less, std::(.+?::)?allocator)? ?>");
        XDebuggerAssertions.assertVariable((XValue)second, (String)"second", (String)"double", (String)"1.2", (Boolean)false);
    }

    @Test
    public void testSmartPointerTypes() throws Exception {
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_SMART_PTR_0);
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_SMART_PTR_1);
        XDebuggerAssertions.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_SMART_PTR_2);
        this.waitForResolve();
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("stl_smart_pointers");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)-1);
        if (this.getSession().getCurrentPosition().getLine() >= ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_SMART_PTR_2) {
            return;
        }
        List<XValue> vars = this.collectVars(0);
        this.doTestSmartPtr(vars, "int_up", "std::(.+?::)?unique_ptr<int(, std::(.+?::)?default_delete(<.*> ?)?)?>", "NULL", null);
        this.doTestSmartPtr(vars, "int_sp", "std::(.+?::)?shared_ptr<int>", "NULL", null);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_SMART_PTR_1);
        vars = this.collectVars(0);
        this.doTestSmartPtr(vars, "int_up", "std::(.+?::)?unique_ptr<int(, std::(.+?::)?default_delete(<.*> ?)?)?>", "0x\\p{XDigit}+", "0");
        this.doTestSmartPtr(vars, "int_sp", "std::(.+?::)?shared_ptr<int>", "0x\\p{XDigit}+", "0");
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_STL, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_STL_SMART_PTR_2);
        vars = this.collectVars(0);
        this.doTestSmartPtr(vars, "int_up", "std::(.+?::)?unique_ptr<int(, std::(.+?::)?default_delete(<.*> ?)?)?>", "0x\\p{XDigit}+", "42");
        this.doTestSmartPtr(vars, "int_sp", "std::(.+?::)?shared_ptr<int>", "0x\\p{XDigit}+", "44");
    }

    private void doTestSmartPtr(@NotNull List<XValue> vars, @NotNull String varName, @RegExp String expectedPtrType, @RegExp String expectedPtr, @Nullable @RegExp String expectedValue) {
        XValue ptr = CidrDebuggingFixture.findVar(vars, varName);
        XDebuggerAssertions.assertVariableTypeMatches((XValue)ptr, null, (String)expectedPtrType, null, (Boolean)true);
        List ptrElements = XDebuggerAssertions.collectChildren((XValueContainer)ptr);
        CidrDebuggingSTLValuesTestCase.assertSize((int)1, (Collection)ptrElements);
        if (this.myBackend == DebuggerDriverKind.LLDB) {
            return;
        }
        XValue element = (XValue)ptrElements.get(0);
        XDebuggerAssertions.assertVariableValueMatches((XValue)element, (String)"get()", (String)"int *", (String)expectedPtr, (Boolean)(expectedValue != null ? 1 : 0));
        if (expectedValue != null) {
            List elementChildren = XDebuggerAssertions.collectChildren((XValueContainer)element);
            CidrDebuggingSTLValuesTestCase.assertSize((int)1, (Collection)elementChildren);
            XDebuggerAssertions.assertVariableValueMatches((XValue)((XValue)elementChildren.get(0)), (String)"*get()", (String)"int", (String)expectedValue, (Boolean)false);
        }
    }

    private boolean allContainersSupportedSupported() {
        return true;
    }

    private boolean libcContainersSupportedSupported() {
        return true;
    }

    @NotNull
    @RegExp
    private static String stringType() {
        return "(std::(.+?::)?)?(basic_)?string(<char(, std::(.+?::)?char_traits, std::(.+?::)?allocator)?>)?";
    }

    @NotNull
    @RegExp
    private static String treesetValueType(@RegExp String type) {
        return "(" + type + ")|(std::(.+?::)?__tree_node<" + type + ", void \\*>::(__node_)?value_type)";
    }

    @NotNull
    @RegExp
    private static String hashValueType(@RegExp String type) {
        return "(" + type + ")|(std::(.+?::)?__hash_node<" + type + ", void \\*>::(__node_)?value_type)";
    }

    @NotNull
    @RegExp
    private static String mapKeyValue(@RegExp String keyType, @RegExp String valueType) {
        return "std::(.+?::)?((pair|__(hash_)?value_type)<(const )?" + keyType + ", " + valueType + ">(::value_type)?|__hash_node<.+?>(::__node_value_type)?)";
    }
}

