/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingWithDebugProjectTestCase;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import com.jetbrains.cidr.execution.debugger.remote.CidrRemoteDebugParameters;
import com.jetbrains.cidr.lang.OCLog;
import java.io.File;
import java.io.OutputStream;
import java.lang.invoke.StringConcatFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;
import org.junit.Test;

public abstract class CidrDebuggingGeneralTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggingWithDebugProjectTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE> {
    public CidrDebuggingGeneralTestCase(String targetName, DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, targetName, fixtureProjectFileRelativePath);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.waitForResolve();
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        CidrTestDataFixture fixture = super.createTestDataFixture();
        fixture.enableSymlinkedProjectCreation();
        return fixture;
    }

    @Test
    public void testStartingAndFinishing() throws Exception {
        this.myDebuggingFixture.startDebugSession(new XDebugSessionListener[0]);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler()));
    }

    @Test
    public void testExceptionsOnAsyncCommand() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        Throwable throwable = new ExecutionException("execution error");
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), false).toString());
        throwable = new DebuggerCommandException("debugger command error");
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), false).toString());
        throwable = new RuntimeException("runtime error");
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), true).toString());
        throwable = new ProcessCanceledException();
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), false).toString());
        throwable = new NullPointerException();
        CidrDebuggingGeneralTestCase.assertEquals((String)throwable.toString(), (String)this.catchErrorFromAsyncCommand(arg_0 -> CidrDebuggingGeneralTestCase.createThrowingCommand(throwable).consume(arg_0), true).toString());
        this.getSession().resume();
    }

    @NotNull
    private static <T extends Throwable> ThrowableConsumer<DebuggerDriver, T> createThrowingCommand(T throwable) {
        return driver -> {
            throwable.addSuppressed(new Throwable());
            throw throwable;
        };
    }

    private Throwable catchErrorFromAsyncCommand(@NotNull CidrDebugProcess.VoidDebuggerCommand command, boolean mustBeLogged) throws Exception {
        ArrayList<Throwable> loggedErrors = new ArrayList<Throwable>();
        Throwable throwable = (Throwable)CidrDebuggingGeneralTestCase.withLoggedErrorsRecorded(() -> {
            CidrDebugProcess debugProcess = (CidrDebugProcess)this.getSession().getDebugProcess();
            ExecutionResult executionResult = ExecutionResult.fromCompletableFuture((CompletableFuture)debugProcess.postCommand(command));
            try {
                executionResult.get(60000L, TimeUnit.MILLISECONDS);
                Throwable throwable = null;
                return throwable;
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                return throwable;
            }
            finally {
                debugProcess.postCommand(driver -> null).get(1500L, TimeUnit.MILLISECONDS);
            }
        }, loggedErrors);
        try {
            if (mustBeLogged) {
                CidrDebuggingGeneralTestCase.assertContainsElements(loggedErrors, (Object[])new Throwable[]{throwable});
            } else {
                CidrDebuggingGeneralTestCase.assertDoesntContain(loggedErrors, (Object[])new Throwable[]{throwable});
            }
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed(throwable);
            throw e;
        }
        return throwable;
    }

    protected static <T> T withLoggedErrorsRecorded(@NotNull ThrowableComputable<T, Exception> computable, @NotNull List<Throwable> loggedErrors) throws Exception {
        AtomicReference r = new AtomicReference();
        final List<Throwable> synchronizedLoggedErrors = Collections.synchronizedList(loggedErrors);
        LoggedErrorProcessor.executeWith((LoggedErrorProcessor)new LoggedErrorProcessor(){

            public boolean processError(@NotNull String category, String message, Throwable t, String @NotNull [] details) {
                synchronizedLoggedErrors.add(t);
                return false;
            }
        }, () -> r.set(computable.compute()));
        return (T)r.get();
    }

    @Test
    public void testPassingEnvVars() throws Exception {
        this.assumeDebugger().supportsTargetInputOutput();
        this.myDebuggingFixture.startDebugSession((Consumer<CidrRunConfiguration>)((Consumer)configuration2 -> {
            configuration2.setProgramParameters("printEnv");
            configuration2.getEnvs().put("TEST_ENV_VAR", "Foo");
        }), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler());
        CidrDebuggingGeneralTestCase.assertMatches(this.myDebuggingFixture.getConsoleText(), ".*TEST_ENV_VAR=Foo.*", 32);
    }

    @Test
    public void testPassingCommandLineArguments() throws Exception {
        this.assumeDebugger().supportsTargetInputOutput();
        this.myDebuggingFixture.startDebugSession((Consumer<CidrRunConfiguration>)((Consumer)configuration2 -> configuration2.setProgramParameters("printArgs $SOME_VAR $PATH %PATH% \"foo bar\\baz\"")), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler());
        String pattern = PlatformUtils.isAppCode() ? ".*1: printArgs\\n2: .*?:/usr/sbin:.*?\\n3: %PATH%\\n4: foo bar\\\\baz\\n.*" : ".*1: printArgs\\n2: \\$SOME_VAR\\n3: \\$PATH\\n4: %PATH%\\n5: foo bar\\\\baz\\n.*";
        CidrDebuggingGeneralTestCase.assertMatches(this.myDebuggingFixture.getConsoleText(), pattern, 32);
    }

    @Test
    public void testInputRedirection() throws Exception {
        this.assumeDebugger().supportsTargetInputOutput();
        String inputFile = ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath();
        this.myDebuggingFixture.startDebugSession((Consumer<CidrRunConfiguration>)((Consumer)configuration2 -> {
            configuration2.setProgramParameters("echo");
            configuration2.setRedirectInput(true);
            configuration2.setRedirectInputPath(inputFile);
        }), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitFor(this.getDebugProcess().getProcessHandler());
        CidrDebuggingGeneralTestCase.assertContains(this.myDebuggingFixture.getConsoleText(), PlatformTestUtil.loadFileText((String)inputFile));
    }

    @Test
    public void testPausingAndResuming() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.myDebuggingFixture.startDebugSessionWithListener("loop");
        CidrDebuggingGeneralTestCase.assertTrue((boolean)((XDebugSessionImpl)this.getSession()).isPauseActionSupported());
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)this.getSession().isPaused());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingGeneralTestCase.assertFalse((boolean)this.getSession().isPaused());
        this.getSession().pause();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)this.getSession().isPaused());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingGeneralTestCase.assertFalse((boolean)this.getSession().isPaused());
        CidrDebuggingFixture.assertNoMoreEvents(state, 500L);
    }

    @Test
    public void testSettingBreakpointsBeforeStarting() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
    }

    @Test
    public void testSettingBreakpointsWhileRunning() throws Exception {
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.myDebuggingFixture.startDebugSessionWithListener("loop");
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        CidrDebuggingGeneralTestCase.waitForSwing();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        CidrDebuggingFixture.assertNoMoreEvents(state, 500L);
    }

    @Test
    public void testRemovingBreakpoint() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FUNC_BEGINNING);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("func");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FUNC_BEGINNING);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        CidrDebuggingGeneralTestCase.waitForSwing();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        CidrDebuggingFixture.assertNoMoreEvents(state, 500L);
    }

    @Test
    public void testBreakpointOnEmptyLine() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_EMPTY);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
    }

    @Test
    public void testBreakpointInAsmCode() throws Exception {
        CidrDebuggingGeneralTestCase.assumeSystem().isNotMac();
        VirtualFile asmFile = this.isMSVCRuntime() ? ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_ASM_MASM : ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_ASM;
        int asmLine = this.isMSVCRuntime() ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_ASM_MASM_PRINT_HELLO_AFTER_PROLOGUE : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_ASM_PRINT_HELLO_AFTER_PROLOGUE;
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)asmFile, (int)asmLine);
        this.startDebugSessionAndWaitForPause("asmPrintHello");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)asmFile, (int)asmLine);
    }

    @Test
    public void testBreakpointBeforeAllCode() throws Exception {
        this.assumeBackendKind().isNotLLDB();
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_BEFORE_MAIN_CODE);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)-1);
        CidrDebuggingFixture.assertThat((Object)this.getSession().getCurrentPosition().getLine(), (Matcher)CoreMatchers.either((Matcher)CoreMatchers.is((Object)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_DECLARATION)).or(CoreMatchers.is((Object)(((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_DECLARATION + 1))));
        XDebuggerAssertions.assertBreakpointValidity((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_BEFORE_MAIN_CODE, (boolean)true, (boolean)false, null, CidrLineBreakpointType.class);
    }

    @Test
    public void testBreakpointInSharedLibrary() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
    }

    @Test
    public void testBreakpointWithConditionInSharedLibrary() throws Exception {
        XLineBreakpoint breakpoint = XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        breakpoint.setCondition("argc");
        this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
    }

    @Test
    public void testBreakpointWithInvalidConditionInSharedLibrary() throws Exception {
        this.doTestBreakpointWithInvalidCondition(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_SHARED, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SHARED_MAIN_BEGINNING);
    }

    @Test
    public void testBreakpointWithInvalidCondition() throws Exception {
        this.doTestBreakpointWithInvalidCondition(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
    }

    public void doTestBreakpointWithInvalidCondition(VirtualFile file2, int line) throws Exception {
        XLineBreakpoint breakpoint = XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)file2, (int)line);
        CidrDebuggingGeneralTestCase.assertNotNull((Object)breakpoint);
        breakpoint.setCondition("some_totally_invalid_condition");
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (this.myBackend == DebuggerDriverKind.LLDB) {
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
            this.getSession().resume();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        }
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
    }

    @Test
    public void testBreakpointInNotCompiledClass() throws Exception {
        VirtualFile[] xxx = new VirtualFile[1];
        WriteAction.computeAndWait(() -> {
            xxx[0] = ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getParent().createChildData((Object)this, "xxx.c");
            return xxx[0];
        });
        try {
            XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
            XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)xxx[0], (int)0);
            this.startDebugSessionAndWaitForPause();
            XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
            String errMessage = CidrDebuggerBundle.message((String)"debug.breakpoint.line.unresolved.hint", (Object[])new Object[0]);
            XDebuggerAssertions.assertBreakpointValidity((Project)this.getProject(), (VirtualFile)xxx[0], (int)0, (boolean)true, (boolean)true, (String)errMessage, CidrLineBreakpointType.class);
        }
        finally {
            try {
                WriteAction.runAndWait(() -> xxx[0].delete((Object)this));
            }
            catch (Throwable e) {
                OCLog.LOG.warn(e);
            }
        }
    }

    @Test
    public void testManuallyAddedBreakpoints() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.getDebugProcess().postCommand(driver -> {
            try {
                driver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
            }
            catch (DebuggerCommandException e) {
                throw new ExecutionException("Cannot set a breakpoint", (Throwable)e);
            }
        });
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        CidrDebuggingFixture.assertNoMoreEvents(state, 500L);
    }

    @Test
    public void testNoFrameIsPreselectedOnLineBreakpointInFunctionWithNoSource() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        this.getDebugProcess().getDriverInTests().addSymbolicBreakpoint("main_sourceless");
        this.getDebugProcess().getDriverInTests().addSymbolicBreakpoint("_main_sourceless");
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), ".*\\b(_)?main_sourceless\\b.*");
        CidrDebuggingGeneralTestCase.assertNull((Object)((CidrStackFrame)((List)frames.first).get(0)).getSourcePosition(false));
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(1)).getFrame().getFunction(), "main\\b.*");
        CidrDebuggingGeneralTestCase.assertEquals((Object)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (Object)((XStackFrame)((List)frames.first).get(1)).getSourcePosition().getFile());
        CidrDebuggingGeneralTestCase.assertSame(null, (Object)frames.second);
    }

    @Test
    public void testFirstFrameWithSourceIsPreselectedOnExceptionBreakpointInFunctionWithNoSource() throws Exception {
        int mainIdx;
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("sourceless_throw");
        XDebuggerAssertions.insertBreakpoint((Project)this.getProject(), (XBreakpointProperties)new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION, null), CidrExceptionBreakpointType.class);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertNull((Object)((CidrStackFrame)((List)frames.first).get(0)).getSourcePosition(false));
        for (mainIdx = 1; mainIdx < ((List)frames.first).size() && !((CidrStackFrame)((List)frames.first).get(mainIdx)).getFrame().getFunction().matches("main\\b.*"); ++mainIdx) {
        }
        CidrDebuggingGeneralTestCase.assertTrue((String)"Can't find main() frame", (mainIdx < ((List)frames.first).size() ? 1 : 0) != 0);
        CidrDebuggingGeneralTestCase.assertEquals((Object)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (Object)((XStackFrame)((List)frames.first).get(mainIdx)).getSourcePosition().getFile());
        CidrDebuggingGeneralTestCase.assertSame(((List)frames.first).get(mainIdx), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenOCExceptionThrown() throws Exception {
        Assume.assumeTrue((String)"OC debugging", (boolean)this.supportsOCDebugging());
        XDebuggerAssertions.insertBreakpoint((Project)this.getProject(), (XBreakpointProperties)new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.OBJC_EXCEPTION, null), CidrExceptionBreakpointType.class);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("ns_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), "objc_exception_throw", null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.ns_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "ns_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_THROWN, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.ns_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), "objc_exception_throw", null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.ns_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "ns_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_UNCAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.ns_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
        CidrDebuggingFixture.assertNoMoreEvents(state, 500L);
    }

    @NotNull
    private CidrStackFrame ns_breakpoints_frame(Pair<List<XStackFrame>, XStackFrame> frames) {
        return this.myDebuggingFixture.findFrameMatching((List)frames.first, "ns_exception_breakpoints.*");
    }

    @NotNull
    private CidrStackFrame cpp_breakpoints_frame(Pair<List<XStackFrame>, XStackFrame> frames) {
        return this.myDebuggingFixture.findFrameMatching((List)frames.first, "cpp_exception_breakpoints.*");
    }

    @Test
    public void testExceptionBreakpointWhenCPPExceptionThrown() throws Exception {
        XDebuggerAssertions.insertBreakpoint((Project)this.getProject(), (XBreakpointProperties)new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION, null), CidrExceptionBreakpointType.class);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("cpp_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        String throwFuncPattern = this.isMSVCRuntime() ? "_CxxThrowException" : ".*cxa_throw";
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), throwFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_THROWN, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), throwFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
        CidrDebuggingFixture.assertNoMoreEvents(state, 500L);
    }

    @Test
    public void testExceptionBreakpointWhenOCExceptionCaught() throws Exception {
        Assume.assumeTrue((String)"OC debugging", (boolean)this.supportsOCDebugging());
        XDebuggerAssertions.insertBreakpoint((Project)this.getProject(), (XBreakpointProperties)new CidrExceptionBreakpointType.Properties(null, CidrExceptionBreakpointType.Properties.Type.OBJC_EXCEPTION), CidrExceptionBreakpointType.class);
        this.startDebugSessionAndWaitForPause("ns_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), ".*cxa_begin_catch", null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.ns_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "ns_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_CAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.ns_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenCPPExceptionCaught() throws Exception {
        Assume.assumeTrue((String)"exception catch breakpoints", (boolean)this.supportsExceptionCatchBreakpoints());
        XDebuggerAssertions.insertBreakpoint((Project)this.getProject(), (XBreakpointProperties)new CidrExceptionBreakpointType.Properties(null, CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION), CidrExceptionBreakpointType.class);
        this.startDebugSessionAndWaitForPause("cpp_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        String catchFuncPattern = ".*cxa_begin_catch";
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), catchFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_CAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenCPPExceptionThrownAndCaught() throws Exception {
        Assume.assumeTrue((String)"exception catch breakpoints", (boolean)this.supportsExceptionCatchBreakpoints());
        XDebuggerAssertions.insertBreakpoint((Project)this.getProject(), (XBreakpointProperties)new CidrExceptionBreakpointType.Properties(CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION, CidrExceptionBreakpointType.Properties.Type.ANY_EXCEPTION), CidrExceptionBreakpointType.class);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("cpp_exception_breakpoints");
        String errorNodeName = "Exception";
        String errorNodeValue = "Exception breakpoint";
        String throwFuncPattern = this.isMSVCRuntime() ? "_CxxThrowException" : ".*cxa_throw";
        String catchFuncPattern = ".*cxa_begin_catch";
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), throwFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_THROWN, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), catchFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_CAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), throwFuncPattern, null, 0, errorNodeName, errorNodeValue, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT, errorNodeName, errorNodeValue, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenOCExceptionUncaught() throws Exception {
        Assume.assumeTrue((String)"OC debugging", (boolean)this.supportsOCDebugging());
        this.startDebugSessionAndWaitForPause("ns_exception_breakpoints");
        CidrDebuggingGeneralTestCase.assertTrue((((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_UNCAUGHT > ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_THROWN ? 1 : 0) != 0);
        CidrDebuggingGeneralTestCase.assertTrue((((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_UNCAUGHT > ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_CAUGHT ? 1 : 0) != 0);
        String errorNodeName = "Signal";
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), ".*pthread_kill", null, 0, errorNodeName, null, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.ns_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "ns_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_NS_EXCEPTION_UNCAUGHT, errorNodeName, null, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.ns_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
    }

    @Test
    public void testExceptionBreakpointWhenCPPExceptionUncaught() throws Exception {
        Assume.assumeFalse((this.myBackend == DebuggerDriverKind.GDB && SystemInfo.isWindows ? 1 : 0) != 0);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("cpp_exception_breakpoints");
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        CidrDebuggingGeneralTestCase.assertTrue((((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT > ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_THROWN ? 1 : 0) != 0);
        CidrDebuggingGeneralTestCase.assertTrue((((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT > ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_CAUGHT ? 1 : 0) != 0);
        String errorNodeName = SystemInfo.isWindows ? "Exception" : "Signal";
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        String signalRaiseFrameNamePattern = SystemInfo.isWindows ? ".*RaiseException.*" : ".*(?:pthread_kill|raise|gsignal).*";
        CidrStackFrame signalRaiseFrame = this.myDebuggingFixture.findFrameMatching((List)frames.first, signalRaiseFrameNamePattern, false);
        if (signalRaiseFrame == null) {
            signalRaiseFrame = (XStackFrame)((List)frames.first).get(0);
        }
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)signalRaiseFrame, signalRaiseFrameNamePattern, null, 0, errorNodeName, null, new String[0]);
        if (this.myBackend == DebuggerDriverKind.GDB && SystemInfo.isMac) {
            return;
        }
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), "cpp_exception_breakpoints", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CPP_EXCEPTION_UNCAUGHT, errorNodeName, null, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)this.cpp_breakpoints_frame((Pair<List<XStackFrame>, XStackFrame>)frames), (Object)frames.second);
    }

    @Test
    public void testFramesOnSignals() throws Exception {
        CidrDebuggingGeneralTestCase.assumeSystem().isUnix();
        this.startDebugSessionAndWaitForPause("signal");
        String errorNodeName = this.selectDriver("Signal", SystemInfo.isMac ? "Exception" : "Signal");
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), "(__(vdso_|kernel_)?)?time", null, 0, errorNodeName, null, new String[0]);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(1), "raiseSignal", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SIGNAL, errorNodeName, null, "someVar");
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(2), "main", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SIGNAL_CALL, errorNodeName, null, "argc", "argv");
        CidrDebuggingGeneralTestCase.assertSame(((List)frames.first).get(1), (Object)frames.second);
    }

    @Test
    public void testFramesOnSignalsMSVC() throws Exception {
        CidrDebuggingGeneralTestCase.assumeSystem().isWindows();
        this.assumeBackendKind().isLLDB();
        this.startDebugSessionAndWaitForPause("signal");
        String errorNodeName = "Exception";
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)((List)frames.first).get(0), "_wstrtime_s", null, 0, "Exception", null, new String[0]);
        CidrStackFrame timeFrame = this.myDebuggingFixture.findFrameMatching((List)frames.first, ".*time\\(.*");
        CidrDebuggingGeneralTestCase.assertNotNull((Object)timeFrame);
        CidrStackFrame signalFrame = this.myDebuggingFixture.findFrameMatching((List)frames.first, "raiseSignal.*");
        CidrDebuggingGeneralTestCase.assertFrameOnSignal((XStackFrame)signalFrame, "raiseSignal", ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_SIGNAL, "Exception", null, "someVar");
        CidrDebuggingGeneralTestCase.assertSame((Object)timeFrame, (Object)frames.second);
    }

    private static void assertFrameOnSignal(@NotNull XStackFrame frame, @RegExp String frameFunction, VirtualFile sourcePositionFile, int line, String errorNodeName, String errorNodeValue, String ... expectedVariables) {
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)frame).getFrame().getFunction(), "(" + frameFunction + ").*", 2);
        if (sourcePositionFile == null) {
            CidrDebuggingGeneralTestCase.assertNull((Object)((CidrStackFrame)frame).getSourcePosition(false));
        } else {
            XDebuggerAssertions.assertSourcePosition((XStackFrame)frame, (VirtualFile)sourcePositionFile, (int)line);
        }
        List variables = XDebuggerAssertions.collectChildren((XValueContainer)frame);
        List allExpectedVariables = ContainerUtil.concat(Collections.singletonList(errorNodeName), Arrays.asList(expectedVariables));
        XDebuggerAssertions.assertVariablesContain((List)variables, (String[])ArrayUtilRt.toStringArray((Collection)allExpectedVariables));
        XDebuggerAssertions.assertVariable((Collection)variables, (String)errorNodeName, null, (String)errorNodeValue, (Boolean)false);
    }

    @Test
    public void testStoppingWhenWaitingForInput() throws Exception {
        this.assumeDebugger().supportsTargetInputOutput();
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INPUT_LOOP);
        this.startDebugSessionAndWaitForPause("input_loop");
        this.getSession().resume();
        CidrDebuggingGeneralTestCase.assertFalse((boolean)CidrExecutionFixture.waitFor(this.getDebugProcess().getProcessHandler(), 1000L));
        OutputStream stream = this.getDebugProcess().getDriverInTests().getProcessInput();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)stream);
        stream.write("test\n".getBytes(StandardCharsets.UTF_8));
        CidrDebuggingGeneralTestCase.assertFalse((boolean)CidrExecutionFixture.waitFor(this.getDebugProcess().getProcessHandler(), 500L));
        this.getSession().stop();
        CidrDebuggingGeneralTestCase.assertTrue((boolean)CidrExecutionFixture.waitFor(this.getDebugProcess().getProcessHandler(), 1000L));
    }

    @Test
    public void testAttachingAndDetaching() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<ProcessHandler, Integer> handlerAndPid = this.launchApp("loop");
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.myDebuggingFixture.attachDebugSession(this.getProject(), info);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.myDebuggingFixture.assertConsoleTextEndsWith("Debugger attached to process " + handlerAndPid.second + "\n");
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        this.getSession().stop();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
        this.myDebuggingFixture.assertConsoleTextEndsWith("\nDebugger detached\n");
        CidrDebuggingGeneralTestCase.assertFalse((boolean)((ProcessHandler)handlerAndPid.first).isProcessTerminating());
        CidrDebuggingGeneralTestCase.assertFalse((boolean)((ProcessHandler)handlerAndPid.first).isProcessTerminated());
    }

    @Test
    public void testDetachingWhileOnBreakpoint() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<ProcessHandler, Integer> handlerAndPid = this.launchApp("loop");
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.myDebuggingFixture.attachDebugSession(this.getProject(), info);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getSession().stop();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
        this.myDebuggingFixture.assertConsoleTextEndsWith("\nDebugger detached\n");
        CidrDebuggingGeneralTestCase.assertFalse((boolean)((ProcessHandler)handlerAndPid.first).isProcessTerminating());
        CidrDebuggingGeneralTestCase.assertFalse((boolean)((ProcessHandler)handlerAndPid.first).isProcessTerminated());
    }

    @Test
    public void testAddingBreakpointAfterAttaching() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<ProcessHandler, Integer> handlerAndPid = this.launchApp("loop");
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.myDebuggingFixture.attachDebugSession(this.getProject(), info);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
    }

    @Test
    public void testFinishingAppWhileAttached() throws Exception {
        this.assumeDebugger().supportsLocalAttach();
        Pair<ProcessHandler, Integer> handlerAndPid = this.launchApp("loop");
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        ProcessInfo info = new ProcessInfo(((Integer)handlerAndPid.second).intValue(), "", "", "");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.myDebuggingFixture.attachDebugSession(this.getProject(), info);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getDebugProcess().getDriverInTests().evaluate(this.getDebugProcess().getCurrentThreadId(), 0, "stop = 1");
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
        this.myDebuggingFixture.assertConsoleTextEndsWith("Debugger attached to process " + handlerAndPid.second + "\nDebugger detached\n");
    }

    @Test
    public void testRemoteConnectingAndTargetFinishing() throws Exception {
        this.assumeDebugger().supportsRemoteDebug();
        Pair<File, OSProcessHandler> fileAndHandler = this.launchRemoteApp("r42");
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.myDebuggingFixture.createRemoteDebugSession(this.getProject(), new CidrRemoteDebugParameters("tcp:localhost:4242", ((File)fileAndHandler.first).getPath(), "/"), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
        this.myDebuggingFixture.assertConsoleTextEndsWith("Debugger connected to tcp:localhost:4242\nDebugger disconnected\n");
        CidrDebuggingGeneralTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor((ProcessHandler)fileAndHandler.second, 1000L));
    }

    @Test
    public void testRemoteConnectingAndDisconnectingWithoutFinishingTarget() throws Exception {
        this.assumeDebugger().supportsRemoteDebug();
        Pair<File, OSProcessHandler> fileAndHandler = this.launchRemoteApp("loop");
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.myDebuggingFixture.createRemoteDebugSession(this.getProject(), new CidrRemoteDebugParameters("tcp:localhost:4242", ((File)fileAndHandler.first).getPath(), "/"), new XDebugSessionListener[0]);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
        this.getSession().stop();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
        CidrDebuggingFixture.waitFor((ProcessHandler)fileAndHandler.second, 1000L);
        this.myDebuggingFixture.assertConsoleTextMatches(".*Debugger connected to tcp:localhost:4242\n(?:(?:Remote communication error\\.  Target disconnected\\.: .*|Remote connection closed)\n\n)?Debugger disconnected\n$");
    }

    @Test
    public void testCollectingFrames() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_BEGIN);
        this.startDebugSessionAndWaitForPause("values");
        XSuspendContext context = this.myDebuggingFixture.getSession().getSuspendContext();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)context.getActiveExecutionStack());
        CidrDebuggingGeneralTestCase.assertNotNull((Object)context.getActiveExecutionStack().getTopFrame());
        CidrDebuggingGeneralTestCase.assertEquals((Object)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (Object)context.getActiveExecutionStack().getTopFrame().getSourcePosition().getFile());
        CidrDebuggingGeneralTestCase.assertEquals((int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_BEGIN, (int)context.getActiveExecutionStack().getTopFrame().getSourcePosition().getLine());
        List<XStackFrame> frames = this.myDebuggingFixture.collectFrames(context.getActiveExecutionStack());
        CidrDebuggingFixture.assertFramePresentationMatches(frames.get(0), "values.*");
        CidrDebuggingFixture.assertFramePresentationMatches(frames.get(1), "main.*");
        CidrDebuggingGeneralTestCase.assertSame((Object)context.getActiveExecutionStack().getTopFrame(), (Object)frames.get(0));
    }

    @Test
    public void testCollectingDeepStacks() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FRAMES);
        this.startDebugSessionAndWaitForPause("deep_frames");
        List<XStackFrame> frames = this.myDebuggingFixture.collectFrames();
        CidrDebuggingGeneralTestCase.assertTrue((String)("Not enough frames: " + frames.size()), (frames.size() >= 1001 ? 1 : 0) != 0);
        for (int i = 0; i < frames.size(); ++i) {
            CidrStackFrame each = (CidrStackFrame)frames.get(i);
            CidrDebuggingGeneralTestCase.assertEquals((int)i, (int)each.getFrame().getIndex());
        }
    }

    @Test
    public void testErrorDuringFrameCollection() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_BEGIN);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("values");
        ThrowInTest.throwOn((Object)this.getSession().getDebugProcess(), (Key)CidrDebugProcess.THROW_ON_FRAME_COLLECTION, (boolean)true);
        XExecutionStack thread = XDebuggerAssertions.getActiveThread((XDebugSession)this.getSession());
        CidrDebuggingGeneralTestCase.assertNotNull((Object)thread);
        CidrDebuggingFixture.assertFramePresentationMatches(thread.getTopFrame(), "values.*");
        Pair framesWithError = XDebuggerAssertions.collectFramesWithError((XExecutionStack)thread, (long)60000L);
        CidrDebuggingGeneralTestCase.assertEmpty((Collection)((Collection)framesWithError.first));
        CidrDebuggingGeneralTestCase.assertEquals((String)"user exception", (String)((String)framesWithError.second));
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        ThrowInTest.throwOn((Object)this.getSession().getDebugProcess(), (Key)CidrDebugProcess.THROW_ON_FRAME_COLLECTION, (boolean)false);
        thread = XDebuggerAssertions.getActiveThread((XDebugSession)this.getSession());
        CidrDebuggingGeneralTestCase.assertNotNull((Object)thread);
        CidrDebuggingFixture.assertFramePresentationMatches(thread.getTopFrame(), "values.*");
        framesWithError = XDebuggerAssertions.collectFramesWithError((XExecutionStack)thread, (long)60000L);
        CidrDebuggingGeneralTestCase.assertEmpty((Collection)((Collection)framesWithError.first));
        CidrDebuggingGeneralTestCase.assertEquals((String)"Execution exception", (String)((String)framesWithError.second));
    }

    @Test
    public void testErrorDuringFrameVariablesCollection() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES_BEGIN);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("values");
        CidrStackFrame frame = (CidrStackFrame)this.myDebuggingFixture.collectFrames().get(0);
        ThrowInTest.throwOn((Object)frame, (Key)CidrStackFrame.THROW_ON_VARIABLES_COLLECTION, (boolean)true);
        CidrDebuggingFixture.assertVarCollectingError((XStackFrame)frame, "user exception");
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        frame = (CidrStackFrame)this.myDebuggingFixture.collectFrames().get(0);
        ThrowInTest.throwOn((Object)frame, (Key)CidrStackFrame.THROW_ON_VARIABLES_COLLECTION, (boolean)false);
        CidrDebuggingFixture.assertVarCollectingError((XStackFrame)frame, "Execution exception");
    }

    @Test
    public void testStepIntoFunctionWithNoSource() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL);
        this.getSession().stepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)(((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL + 1));
    }

    @Test
    public void testForceStepIntoFunctionWithNoSource() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        CidrStackFrame stackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertFalse((String)"Must be disassembly", (boolean)stackFrame.hasSourceFile());
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        int expLineNum = this.isMSVCRuntime() && this.myDebuggingFixture.getArchitectureType() == ArchitectureType.I386 ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL + 1;
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)expLineNum);
    }

    @Test
    public void testAddressBreakpointInsideSourcelessFunction() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_2);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("double_sourceless");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_2);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        CidrStackFrame stack = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)stack);
        XSourcePosition pos = stack.getSourcePosition();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)pos);
        this.pauseFor(100L);
        XLineBreakpoint toggledBreakpoint = XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)pos.getFile(), (int)pos.getLine());
        CidrDebuggingGeneralTestCase.assertNotNull((Object)toggledBreakpoint);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_3);
        this.pauseFor(100L);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_3);
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?my_sourceless1\\b.*");
    }

    @Test
    public void testJumpToAddressInsideSourcelessFunction() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_1);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("double_sourceless");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_1);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?my_sourceless2\\b.*");
        CidrStackFrame stack = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)stack);
        XSourcePosition targetPos = stack.getSourcePosition();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)targetPos);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_2);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_2);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?my_sourceless1\\b.*");
        stack = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)stack);
        boolean jumpStatus = this.myDebuggingFixture.myDebugProcess.jumpToLine(stack.getThread(), targetPos.getFile(), targetPos.getLine());
        CidrDebuggingGeneralTestCase.assertTrue((boolean)jumpStatus);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?my_sourceless2\\b.*");
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_3);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_DOUBLE_SOURCELESS_CALL_3);
        XDebuggerAssertions.assertVariableValue(this.collectVars(0), (String)"result_1", (String)"2");
    }

    @Test
    public void testSteppingOutOfMain() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FUNC_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("func");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_FUNC_BEGINNING);
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)(((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FUNC_CALL + this.offsetAfterStepOut()));
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
    }

    protected int offsetAfterStepOut() {
        return this.isMSVCRuntime() && this.myDebuggingFixture.getArchitectureType() == ArchitectureType.I386 || this.myBackend == DebuggerDriverKind.LLDB && SystemInfo.isMac ? 0 : 1;
    }

    @Test
    public void testSteppingOutSkippingSingleSourcelessFrame() throws Exception {
        this.doTestSteppingOutSkippingSourcelessFrames("sourceless_hello");
    }

    @Test
    public void testSteppingOutSkippingMultipleSourcelessFrames() throws Exception {
        this.assumeBackendKind().isNotLLDB();
        this.doTestSteppingOutSkippingSourcelessFrames("sourceless_recurse_indirect7");
    }

    @Test
    public void testSteppingOutSkippingRecursiveSourcelessFrames() throws Exception {
        this.assumeBackendKind().isNotLLDB();
        this.doTestSteppingOutSkippingSourcelessFrames("sourceless_recurse_direct7");
    }

    public void doTestSteppingOutSkippingSourcelessFrames(@NotNull String param) throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause(param);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        int expLineNum = this.isMSVCRuntime() && this.myDebuggingFixture.getArchitectureType() == ArchitectureType.I386 ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL + 1;
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)expLineNum);
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
    }

    @Test
    public void testSteppingOverSkippingSingleSourcelessFrame() throws Exception {
        this.doTestSteppingOverSkippingSourcelessFrames("sourceless_hello");
    }

    @Test
    public void testSteppingOverSkippingMultipleSourcelessFrames() throws Exception {
        this.doTestSteppingOverSkippingSourcelessFrames("sourceless_recurse_indirect7");
    }

    @Test
    public void testSteppingOverSkippingRecursiveSourcelessFrames() throws Exception {
        this.doTestSteppingOverSkippingSourcelessFrames("sourceless_recurse_direct7");
    }

    public void doTestSteppingOverSkippingSourcelessFrames(@NotNull String param) throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause(param);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        this.getSession().stepOver(false);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        if (((CidrStackFrame)this.getSession().getCurrentStackFrame()).getFrame().getFunction().matches("^hello_from_sourceless\\b.*")) {
            XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)(((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS + 1));
            this.getSession().stepOver(false);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        }
        int expLineNum = this.isMSVCRuntime() && this.myDebuggingFixture.getArchitectureType() == ArchitectureType.I386 ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL + 1;
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)expLineNum);
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
    }

    @Test
    public void testSteppingOutThroughSingleSourcelessFrame() throws Exception {
        this.assumeBackendKind().isNotLLDB();
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("sourceless_hello");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        if (((CidrStackFrame)this.getSession().getCurrentStackFrame()).getFrame().getFunction().matches("^hello_from_sourceless\\b.*")) {
            XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)(((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS + 1));
            this.getSession().forceStepInto();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        }
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertNull((Object)((CidrStackFrame)((List)frames.first).get(0)).getSourcePosition(false));
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(1)).getFrame().getFunction(), "^main\\b.*");
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        int expLineNum = this.isMSVCRuntime() && this.myDebuggingFixture.getArchitectureType() == ArchitectureType.I386 ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL + 1;
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)expLineNum);
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
    }

    @Test
    public void testSteppingOutThroughMultipleSourcelessFrames() throws Exception {
        this.doTestSteppingThroughSourcelessFrames("sourceless_recurse_indirect7", 7, false);
    }

    @Test
    public void testSteppingOutThroughRecursiveSourcelessFrames() throws Exception {
        this.doTestSteppingThroughSourcelessFrames("sourceless_recurse_direct7", 7, false);
    }

    @Test
    public void testSteppingOverThroughMultipleSourcelessFrames() throws Exception {
        this.doTestSteppingThroughSourcelessFrames("sourceless_recurse_indirect7", 7, true);
    }

    @Test
    public void testSteppingOverThroughRecursiveSourcelessFrames() throws Exception {
        this.doTestSteppingThroughSourcelessFrames("sourceless_recurse_direct7", 7, true);
    }

    public void doTestSteppingThroughSourcelessFrames(@NotNull String param, int depth, boolean useStepOver) throws Exception {
        this.assumeBackendKind().isNotLLDB();
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause(param);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS);
        this.getSession().forceStepInto();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        boolean isGCC = ((CidrStackFrame)this.getSession().getCurrentStackFrame()).getFrame().getFunction().matches("^hello_from_sourceless\\b.*");
        if (isGCC) {
            XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)(((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_HELLO_FROM_SOURCELESS + 1));
            this.getSession().forceStepInto();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        }
        int numSourcelessFrames = depth + 1;
        int stepsPerFrame = !useStepOver ? 1 : (!isGCC ? 6 : 3);
        for (int frame = numSourcelessFrames - 1; frame > 0; --frame) {
            for (int step = 0; step < stepsPerFrame; ++step) {
                Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
                if (((List)frames.first).size() > frame + 1) {
                    String function = ((CidrStackFrame)((List)frames.first).get(frame + 1)).getFrame().getFunction();
                    if (frame == numSourcelessFrames - 1 && step == stepsPerFrame - 1 && !function.matches("^main\\b.*")) continue;
                    CidrDebuggingGeneralTestCase.assertMatches(function, "^main\\b.*");
                } else if (stepsPerFrame == 3) {
                    stepsPerFrame = 4;
                }
                CidrDebuggingGeneralTestCase.assertNull((Object)((CidrStackFrame)((List)frames.first).get(0)).getSourcePosition(false));
                CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^sourceless_recurse.*");
                if (useStepOver) {
                    this.getSession().stepOver(false);
                } else {
                    this.getSession().stepOut();
                }
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
                CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
            }
        }
        Pair frames = XDebuggerAssertions.collectFramesWithSelected((XDebugSession)this.getSession(), (long)60000L);
        CidrDebuggingGeneralTestCase.assertNull((Object)((CidrStackFrame)((List)frames.first).get(0)).getSourcePosition(false));
        CidrDebuggingGeneralTestCase.assertMatches(((CidrStackFrame)((List)frames.first).get(0)).getFrame().getFunction(), "^(_)?main_sourceless\\b.*");
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        int expLineNum = this.isMSVCRuntime() && this.myDebuggingFixture.getArchitectureType() == ArchitectureType.I386 ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_SOURCELESS_CALL + 1;
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)expLineNum);
        this.getSession().stepOut();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        if (!this.steppingWorksWellWithLibcDebugInfo()) {
            return;
        }
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
    }

    @Test
    public void testJumpToLine() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_PRE_FUNC_CALL);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("func");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_PRE_FUNC_CALL);
        CidrStackFrame stack = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        CidrDebuggingGeneralTestCase.assertNotNull((Object)stack);
        CidrDebuggingGeneralTestCase.assertTrue((boolean)this.myDebuggingFixture.myDebugProcess.jumpToLine(stack.getThread(), ((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FUNC_CALL));
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_FUNC_CALL);
    }

    @Test
    public void testConsoleCommandCompletionTopLevelCommand() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        switch (this.myBackend) {
            case GDB: {
                this.doTestCompleteConsoleCommand("inf", "info", "inferior");
                this.doTestCompleteConsoleCommand("bre", "break", "break-range");
                this.doTestCompleteConsoleCommand("break", "break", "break-range");
                this.doTestCompleteConsoleCommand("break-", "break-range");
                break;
            }
            case LLDB: {
                this.doTestCompleteConsoleCommand("break", "breakpoint");
                this.doTestCompleteConsoleCommand("pr", "process");
                this.doTestCompleteConsoleCommand("disa", "disassemble");
            }
        }
    }

    @Test
    public void testConsoleCommandCompletionCursorBeforeEndOfCommand() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        switch (this.myBackend) {
            case GDB: {
                this.doTestCompleteConsoleCommand("infer", 3, "info", "inferior");
                this.doTestCompleteConsoleCommand("break-", 3, "break", "break-range");
                break;
            }
            case LLDB: {
                this.doTestCompleteConsoleCommand("breakpo", 5, "breakpoint");
                this.doTestCompleteConsoleCommand("proc", 2, "process");
                this.doTestCompleteConsoleCommand("disasse", 4, "disassemble");
            }
        }
    }

    @Test
    public void testConsoleCommandCompletionSubcommand() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        switch (this.myBackend) {
            case GDB: {
                this.doTestCompleteConsoleCommand("info pr", "pretty-printer", "probes", "proc", "program");
                break;
            }
            case LLDB: {
                this.doTestCompleteConsoleCommand("breakpoint l", "list");
            }
        }
    }

    protected void doTestCompleteConsoleCommand(@NotNull String command, String ... expectedCompletions) {
        this.doTestCompleteConsoleCommand(command, command.length(), expectedCompletions);
    }

    protected void doTestCompleteConsoleCommand(@NotNull String command, int offset, String ... expectedCompletions) {
        CidrDebugProcess debugProcess = (CidrDebugProcess)this.getSession().getDebugProcess();
        EmptyProgressIndicator processIndicatorStub = new EmptyProgressIndicator();
        List completions = debugProcess.completeConsoleCommand((String)command, (int)offset, (ProgressIndicator)processIndicatorStub).list;
        CidrDebuggingGeneralTestCase.assertContainsElements((Collection)completions, Arrays.asList(expectedCompletions));
        completions = debugProcess.completeConsoleCommand((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{" \u0001"}, (String)command)), (int)(1 + offset), (ProgressIndicator)processIndicatorStub).list;
        CidrDebuggingGeneralTestCase.assertContainsElements((Collection)completions, Arrays.asList(expectedCompletions));
    }

    @NotNull
    private String getExpectedPromptValue() {
        return this.selectDriver("(gdb) ", "(lldb) ");
    }

    @Test
    public void testConsolePromptHidingOnResume() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("loop");
        this.waitForDebuggerAndSwingEvents();
        CidrDebugProcess debugProcess = (CidrDebugProcess)this.getSession().getDebugProcess();
        CidrDebuggingGeneralTestCase.assertEquals((String)this.getExpectedPromptValue(), (String)debugProcess.getDebuggerConsole().getPrompt());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        this.waitForDebuggerAndSwingEvents();
        CidrDebuggingGeneralTestCase.assertEquals((String)"", (String)debugProcess.getDebuggerConsole().getPrompt());
    }

    @Test
    public void testConsolePromptOnBreak() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause();
        this.waitForDebuggerAndSwingEvents();
        CidrDebugProcess debugProcess = (CidrDebugProcess)this.getSession().getDebugProcess();
        CidrDebuggingGeneralTestCase.assertEquals((String)this.getExpectedPromptValue(), (String)debugProcess.getDebuggerConsole().getPrompt());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        this.waitForDebuggerAndSwingEvents();
        CidrDebuggingGeneralTestCase.assertEquals((String)this.getExpectedPromptValue(), (String)debugProcess.getDebuggerConsole().getPrompt());
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.STOPPED);
        this.waitForDebuggerAndSwingEvents();
        CidrDebuggingGeneralTestCase.assertEquals((String)"", (String)debugProcess.getDebuggerConsole().getPrompt());
    }

    @Test
    public void testDebuggerCrashNotification() throws Exception {
        this.doTestDebuggerCrash(false);
    }

    @Test
    public void testDebuggerCrashNotificationOnBreakpoint() throws Exception {
        this.doTestDebuggerCrash(true);
    }

    public void doTestDebuggerCrash(boolean useBreakpoint) throws Exception {
        CidrDebuggingGeneralTestCase.assumeSystem().isUnix();
        if (useBreakpoint) {
            XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP);
            this.startDebugSessionAndWaitForPause("loop");
        } else {
            this.myDebuggingFixture.startDebugSession("loop", new XDebugSessionListener[0]);
        }
        final FutureResult notificationFuture = new FutureResult();
        this.getProject().getMessageBus().connect(this.getTestRootDisposable()).subscribe(Notifications.TOPIC, (Object)new Notifications(){

            public void notify(@NotNull Notification notification) {
                String content = notification.getContent();
                if (content.contains("SIGABRT") && content.contains("<a href=\"Restart\">")) {
                    notificationFuture.set((Object)notification);
                }
            }
        });
        BaseProcessHandler processHandler = this.getDebugProcess().getDriverInTests().getProcessHandler();
        Process process = processHandler.getProcess();
        UnixProcessManager.sendSignal((int)OSProcessUtil.getProcessID((Process)process), (int)6);
        process.waitFor();
        processHandler.waitFor(1000L);
        this.waitForDebuggerAndSwingEvents();
        CidrDebuggingGeneralTestCase.assertNotNull(CidrDebuggingFixture.waitFor(notificationFuture, 1000L));
    }

    private void pauseFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

