/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerAssertions;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingWithDebugProjectTestCase;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBExpressionPlaceholder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;
import org.junit.Test;

public abstract class CidrDebuggingEvaluationTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggingWithDebugProjectTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE> {
    public CidrDebuggingEvaluationTestCase(String targetName, DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, targetName, fixtureProjectFileRelativePath);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.waitForResolve();
    }

    @Test
    public void testEvaluatingSizedCArray() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        Pair<XValue, String> array = this.evaluate("GetStructWithArray().x");
        XDebuggerAssertions.assertVariableValueMatches((XValue)((XValue)array.first), (String)"result", (String)this.selectDriver("char [3]", "char *"), (String)this.selectDriver("", this.isMSVCRuntime() ? "0x\\p{XDigit}+ \"ab\"" : "\"ab\""));
    }

    @Test
    public void testEvalThisPtr() throws Exception {
        CidrDebuggerSettings.getInstance().setValuesFilterEnabled(true);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MYCLASS_FUNC);
        this.startDebugSessionAndWaitForPause("memfunc");
        Pair<XValue, String> val = this.myDebuggingFixture.evaluate("this");
        XDebuggerAssertions.assertVariable(val, null, (String)(this.myBackend == DebuggerDriverKind.LLDB || SystemInfo.isMac ? "MyClass *" : "MyClass *const"));
    }

    @Test
    public void testEvalThisPtrInInlineFunc() throws Exception {
        CidrDebuggerSettings.getInstance().setValuesFilterEnabled(true);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MYCLASS_INLINE_FUNC);
        this.startDebugSessionAndWaitForPause("inlinememfunc");
        Pair<XValue, String> val = this.myDebuggingFixture.evaluate("this");
        XDebuggerAssertions.assertVariable(val, null, (String)(this.myBackend == DebuggerDriverKind.LLDB || SystemInfo.isMac ? "MyClass *" : "MyClass *const"));
    }

    @Test
    public void testEvalCStruct() throws Exception {
        this.doTestEvalCStruct("s", this.selectDriver("struct MyCStruct", "MyCStruct"));
    }

    @Test
    public void testEvaluatingTypeDefStruct() throws Exception {
        String expType = this.myBackend == DebuggerDriverKind.LLDB && SystemInfo.isWindows ? "MyCStruct" : "MyCStructT";
        this.doTestEvalCStruct("s1", expType);
    }

    private void doTestEvalCStruct(@NotNull String sName, @NotNull String sType) throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_FOO, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CFUNC_ENDING);
        this.startDebugSessionAndWaitForPause("cfunc");
        Pair<XValue, String> val = this.myDebuggingFixture.evaluate(sName);
        XDebuggerAssertions.assertVariable(val, null, (String)sType);
    }

    @Test
    public void testEvalCStructArray() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_FOO, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CFUNC_ENDING);
        this.startDebugSessionAndWaitForPause("cfunc");
        Pair<XValue, String> val = this.myDebuggingFixture.evaluate("sArray");
        XDebuggerAssertions.assertVariable(val, null, (String)this.selectDriver("struct MyCStruct [20]", "MyCStruct [20]"));
    }

    @Test
    public void testEvalCPtrStructArray() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_FOO, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_CFUNC_ENDING);
        this.startDebugSessionAndWaitForPause("cfunc");
        Pair<XValue, String> val = this.myDebuggingFixture.evaluate("pSArray");
        XDebuggerAssertions.assertVariable(val, null, (String)this.selectDriver("struct MyCStruct *[20]", "MyCStruct *[20]"));
    }

    @Test
    public void testEvalCppStruct() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MYCLASS_FUNC);
        this.startDebugSessionAndWaitForPause("memfunc");
        Pair<XValue, String> val = this.myDebuggingFixture.evaluate("s");
        XDebuggerAssertions.assertVariable(val, null, (String)"MyStruct");
    }

    @Test
    public void testEvalCppStructArray() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MYCLASS_FUNC);
        this.startDebugSessionAndWaitForPause("memfunc");
        Pair<XValue, String> val = this.myDebuggingFixture.evaluate("sArray");
        XDebuggerAssertions.assertVariable(val, null, (String)"MyStruct [20]");
    }

    @Test
    public void testEvalCppPtrStructArray() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MYCLASS_FUNC);
        this.startDebugSessionAndWaitForPause("memfunc");
        Pair<XValue, String> val = this.myDebuggingFixture.evaluate("pSArray");
        XDebuggerAssertions.assertVariable(val, null, (String)"MyStruct *[20]");
    }

    @Test
    public void testEvaluationExceptionOnUnsupportedLanguage() throws Exception {
        this.startDriver();
        try {
            this.myDriver.evaluate(0L, 0, "1+1", new DebuggerDriver.DebuggerLanguage(){

                public String toString() {
                    return "Unsupported";
                }
            });
            CidrDebuggingEvaluationTestCase.fail((String)"Expected exception");
        }
        catch (DebuggerCommandException e) {
            CidrDebuggingEvaluationTestCase.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("Unsupported is not supported by"));
        }
    }

    @Test
    public void testEvaluateRvalueReference() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES);
        this.startDebugSessionAndWaitForPause("values");
        XValue val = (XValue)this.evaluate((String)"rr").first;
        XDebuggerAssertions.assertVariableValueMatches((XValue)val, (String)"result", (String)this.selectDriver("int &&", "int"), (String)"0");
    }

    @Test
    public void testErrorDuringEvaluation() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_VALUES);
        this.startDebugSessionAndWaitForPause("values");
        ThrowInTest.throwOn((Object)this.getDebugProcess(), (Key)CidrEvaluator.THROW_ON_EVALUATION, (boolean)true);
        CidrDebuggingEvaluationTestCase.assertEquals((String)"user exception", (String)((String)this.evaluate((String)"1").second));
        ThrowInTest.throwOn((Object)this.getDebugProcess(), (Key)CidrEvaluator.THROW_ON_EVALUATION, (boolean)false);
        CidrDebuggingEvaluationTestCase.assertEquals((String)"Execution exception", (String)((String)this.evaluate((String)"1").second));
    }

    @Test
    public void testEvaluationWithSideEffects() throws Exception {
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        BlockingQueue<CidrDebuggingFixture.DebuggerState> state = this.startDebugSessionAndWaitForPause("forLoop");
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        Pair<XValue, String> evalResult = this.evaluate("evaluate_with_side_effects()");
        XDebuggerAssertions.assertVariableValue((XValue)((XValue)evalResult.first), (String)"result", (String)"0");
        CidrDebuggingEvaluationTestCase.assertNull((Object)evalResult.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        for (int i = 0; i < 10; ++i) {
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
            XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_FOR_LOOP);
            this.collectVars(0);
            this.getSession().resume();
            CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
        }
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.PAUSED);
        XDebuggerAssertions.assertCurrentPosition((XDebugSession)this.getSession(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_ENDING);
        evalResult = this.evaluate("evaluate_with_side_effects()");
        XDebuggerAssertions.assertVariableValue((XValue)((XValue)evalResult.first), (String)"result", (String)"1");
        CidrDebuggingEvaluationTestCase.assertNull((Object)evalResult.second);
        this.getSession().resume();
        CidrDebuggingFixture.waitForEvent(state, CidrDebuggingFixture.DebuggerState.RESUMED);
    }

    @Test
    public void testMethodInsertHandler() throws Exception {
        Assume.assumeTrue((String)"OC debugging", (boolean)this.supportsOCDebugging());
        XDebuggerTestUtil.toggleBreakpoint((Project)this.getProject(), (VirtualFile)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_OC, (int)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_OC_BEGINNING);
        this.startDebugSessionAndWaitForPause();
        EdtTestUtil.runInEdtAndWait(() -> {
            LanguageConsoleView console = this.myDebuggingFixture.myDebugProcess.getDebuggerConsole();
            Document hostDocument = console.getEditorDocument();
            Editor editor = (Editor)WriteAction.compute(() -> {
                EditorEx hostEditor = console.getConsoleEditor();
                hostDocument.setText((CharSequence)"po [NSString stringWithUTF8<caret>");
                EditorTestUtil.setCaretsAndSelection((Editor)hostEditor, (EditorTestUtil.CaretAndSelectionState)EditorTestUtil.extractCaretAndSelectionMarkers((Document)hostDocument));
                PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(hostDocument);
                GDBExpressionPlaceholder gdbExpr = (GDBExpressionPlaceholder)PsiTreeUtil.findChildOfType((PsiElement)PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(hostDocument), GDBExpressionPlaceholder.class);
                CidrDebuggingEvaluationTestCase.assertNotNull((Object)gdbExpr);
                List injectedPsiFiles = InjectedLanguageManager.getInstance((Project)this.getProject()).getInjectedPsiFiles((PsiElement)gdbExpr);
                CidrDebuggingEvaluationTestCase.assertNotNull((Object)injectedPsiFiles);
                CidrDebuggingEvaluationTestCase.assertSize((int)1, (Collection)injectedPsiFiles);
                PsiFile injectedFile = ((PsiElement)((Pair)injectedPsiFiles.get(0)).getFirst()).getContainingFile();
                return InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)hostEditor, (PsiFile)injectedFile);
            });
            ReadAction.run(() -> {
                new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(this.getProject(), editor, 1);
                CidrDebuggingEvaluationTestCase.assertEquals((String)"po [NSString stringWithUTF8String:<#(const char *)nullTerminatedCString#>]", (String)hostDocument.getText());
            });
        });
    }
}

