/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.FutureResult;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrDebugTestDataFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerTestCase;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public abstract class CidrDebuggerDriverRemoteTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggerTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrDebugProjectMarkup> {
    private static final Key<List<DebuggerDriver.PathMapping>> REMOTE_TO_LOCAL_MAPPING = Key.create((String)"REMOTE_TO_LOCAL_MAPPING");
    private static File ourLocalProjectCopy;

    public CidrDebuggerDriverRemoteTestCase(DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, CidrDebuggerDriverRemoteTestCase.getDefaultTargetName(backend), new CidrTestProjectDescription(fixtureProjectFileRelativePath));
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrDebugTestDataFixture(){

            @Override
            public File copyTestData(@NotNull File folderOrZipToCopy, @NotNull File toDir) {
                File result = super.copyTestData(folderOrZipToCopy, toDir);
                ourLocalProjectCopy = new File(toDir, "_local_project_copy");
                TestCase.assertTrue((boolean)ourLocalProjectCopy.mkdirs());
                super.copyTestData(folderOrZipToCopy, ourLocalProjectCopy);
                return result;
            }
        };
    }

    @Override
    protected CidrProjectFixture.CleanProjectOption shouldCleanProject() {
        return CidrProjectFixture.CleanProjectOption.CLEAN_FOR_TESTCASE;
    }

    @Override
    @NotNull
    protected CidrDebugProjectMarkup createProjectMarkup(@NotNull VirtualFile projectDir) {
        VirtualFile localProjectCopyDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ourLocalProjectCopy);
        CidrDebuggerDriverRemoteTestCase.assertNotNull((String)("local copy not found near " + projectDir), (Object)localProjectCopyDir);
        projectDir.putUserData(REMOTE_TO_LOCAL_MAPPING, Collections.singletonList(new DebuggerDriver.PathMapping(localProjectCopyDir.getParent().getPath(), localProjectCopyDir.getPath())));
        return new CidrDebugProjectMarkup(localProjectCopyDir);
    }

    @Test
    public void testConnecting() throws Exception {
        this.assumeDebugger().supportsRemoteDebug();
        File file2 = (File)this.launchRemoteApp(null).first;
        final FutureResult finished = new FutureResult();
        final FutureResult connected = new FutureResult();
        final StringBuffer log = new StringBuffer();
        this.startDriver(new DebuggerDriver.Handler(){

            public void handleConnected(@NotNull String connection) {
                log.append("connected ");
                connected.set((Object)connection);
            }

            public void handleRunning() {
                log.append("running ");
            }

            public void handleInterrupted(@NotNull DebuggerDriver.StopPlace stopPlace) {
                log.append("interrupted ");
            }

            public void handleTargetFinished(int code, @Nullable String description2) {
                log.append("finished ");
                finished.set((Object)code);
            }

            public void handleDisconnected() {
                log.append("disconnected ");
            }
        });
        this.loadAndConnect("tcp:localhost:4242", file2);
        CidrDebuggerDriverRemoteTestCase.assertEquals((String)"tcp:localhost:4242", (String)((String)CidrDebuggingFixture.waitFor(connected)));
        CidrDebuggerDriverRemoteTestCase.assertEquals((Object)0, CidrDebuggingFixture.waitFor(finished));
        CidrDebuggerDriverRemoteTestCase.assertEquals((String)"connected running finished ", (String)log.toString());
    }

    @Test
    public void testEvaluateArgumentsCount() throws Exception {
        this.assumeDebugger().supportsRemoteDebug();
        File file2 = (File)this.launchRemoteApp((String)"printArgs foo bar baz").first;
        final FutureResult stoppedThreadResult = new FutureResult();
        this.startDriver(new DebuggerDriver.Handler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                stoppedThreadResult.set((Object)stopPlace.thread.getId());
            }
        });
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.loadAndConnect("tcp:localhost:4242", file2);
        Long stoppedThread = (Long)CidrExecutionFixture.waitFor(stoppedThreadResult);
        CidrDebuggerDriverRemoteTestCase.assertNotNull((Object)stoppedThread);
        List vars = this.myDriver.getVariables(stoppedThread.longValue(), 0);
        LLValue argcVar = CidrDebuggingFixture.findVariable("argc", vars);
        CidrDebuggerDriverRemoteTestCase.assertNotNull((String)"Couldn't find variable 'argc'", (Object)argcVar);
        CidrDebuggingFixture.assertLLValuePresentableValue(this.myDriver, argcVar, "5");
    }

    @Test
    public void testBreakpointsBeforeLoading() throws Exception {
        this.doTestBreakpoints(PutBreakpoint.BEFORE_LOADING);
    }

    @Test
    public void testBreakpointsAfterLoading() throws Exception {
        this.doTestBreakpoints(PutBreakpoint.AFTER_LOADING);
    }

    @Test
    public void testBreakpointsAfterConnecting() throws Exception {
        this.doTestBreakpoints(PutBreakpoint.AFTER_CONNECTION);
    }

    public void doTestBreakpoints(PutBreakpoint putBreakpoint) throws Exception {
        int line;
        this.assumeDebugger().supportsRemoteDebug();
        File file2 = (File)this.launchRemoteApp((String)(putBreakpoint == PutBreakpoint.AFTER_CONNECTION ? "loop" : null)).first;
        final FutureResult breakpoint = new FutureResult();
        this.startDriver(new CidrDebuggerTestCase.NullHandler(){

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                breakpoint.set((Object)stopPlace);
            }

            public void handleTargetFinished(int code, @Nullable String description2) {
                breakpoint.setException((Throwable)new Exception("Breakpoint was not triggered"));
            }
        });
        int n = line = putBreakpoint == PutBreakpoint.AFTER_CONNECTION ? ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_INSIDE_LOOP : ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING;
        if (putBreakpoint == PutBreakpoint.BEFORE_LOADING) {
            this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), line);
        }
        this.loadForRemote("tcp:localhost:4242", file2);
        if (putBreakpoint == PutBreakpoint.AFTER_LOADING) {
            this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), line);
        }
        this.myInferior.start();
        if (putBreakpoint == PutBreakpoint.AFTER_CONNECTION) {
            this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), line);
        }
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(breakpoint);
        CidrDebuggerDriverRemoteTestCase.assertNotNull((Object)stopPlace);
        CidrDebuggerDriverRemoteTestCase.assertEquals((String)((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), (String)stopPlace.frame.getFile());
        CidrDebuggerDriverRemoteTestCase.assertEquals((int)line, (int)stopPlace.frame.getLine());
    }

    @Test
    public void testDisconnecting() throws Exception {
        this.doTestDisconnecting(true, false);
    }

    @Test
    public void testDisconnectingOnBreakpoint() throws Exception {
        this.doTestDisconnecting(false, false);
    }

    @Test
    public void testDisconnectingOnBreakpointAfterGdbserverIsKilled() throws Exception {
        this.doTestDisconnecting(false, true);
    }

    public void doTestDisconnecting(boolean whenRunning, boolean killGdbserver) throws Exception {
        this.assumeDebugger().supportsRemoteDebug();
        Pair<File, OSProcessHandler> fileAndHandler = this.launchRemoteApp(whenRunning ? "loop" : null);
        final FutureResult breakpoint = new FutureResult();
        final Semaphore connected = new Semaphore(0);
        final Semaphore disconnected = new Semaphore(0);
        final StringBuffer log = new StringBuffer();
        this.startDriver(new DebuggerDriver.Handler(){

            public void handleConnected(@NotNull String connection) {
                log.append("connected ");
                connected.release();
            }

            public void handleDisconnected() {
                log.append("disconnected ");
                disconnected.release();
            }

            public void handleBreakpoint(@NotNull DebuggerDriver.StopPlace stopPlace, int breakpointNumber) {
                breakpoint.set((Object)stopPlace);
            }

            public void handleDetached() {
                log.append("detached ");
                disconnected.release();
            }

            public void handleTargetFinished(int code, @Nullable String description2) {
                log.append("finished ");
                disconnected.release();
            }
        });
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.loadAndConnect("tcp:localhost:4242", (File)fileAndHandler.first);
        CidrDebuggerDriverRemoteTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor(connected, 5000L));
        CidrDebuggerDriverRemoteTestCase.assertEquals((String)"connected ", (String)log.toString());
        DebuggerDriver.StopPlace stopPlace = (DebuggerDriver.StopPlace)CidrDebuggingFixture.waitFor(breakpoint);
        CidrDebuggerDriverRemoteTestCase.assertNotNull((Object)stopPlace);
        if (whenRunning) {
            this.myDriver.resume();
        }
        if (killGdbserver) {
            ((OSProcessHandler)fileAndHandler.second).destroyProcess();
            CidrDebuggerDriverRemoteTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor((ProcessHandler)fileAndHandler.second, 2000L));
        }
        boolean thrown = false;
        try {
            this.myInferior.detach();
        }
        catch (ExecutionException e) {
            CidrDebuggerDriverRemoteTestCase.assertTrue((boolean)ExceptionUtil.causedBy((Throwable)e, ExecutionFinishedException.class));
            thrown = true;
        }
        CidrDebuggerDriverRemoteTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor(disconnected, 1000L));
        CidrDebuggerDriverRemoteTestCase.assertEquals((String)("connected " + (thrown ? "finished " : "disconnected ")), (String)log.toString());
    }

    @Test
    public void testMiAsyncNotSupported() throws Exception {
        this.assumeDebugger().supportsRemoteDebug();
        Pair<File, OSProcessHandler> fileAndHandler = this.launchRemoteApp(null);
        BlockingQueue events = this.startDriver(CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT);
        ((GDBDriver)this.myDriver).setMIResponseFilterInTests((request, s) -> {
            if (s.equals("(gdb)")) {
                return s;
            }
            if (!request.contains("mi-async")) {
                return s;
            }
            return "^error,msg=\"No symbol table is loaded.  Use the \\\"file\\\" command.\"";
        });
        this.myDriver.addBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_MAIN.getPath(), ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_MAIN_BEGINNING);
        this.loadAndConnect("tcp:localhost:4242", (File)fileAndHandler.first);
        CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT, 5000L);
        this.myDriver.resume();
        this.myInferior.detach();
        CidrDebuggerDriverRemoteTestCase.assertTrue((boolean)CidrDebuggingFixture.waitFor((ProcessHandler)fileAndHandler.second, 2000L));
    }

    protected void loadForRemote(@NotNull String connectionString, @Nullable File symbols) throws ExecutionException {
        List data = (List)this.myProjectFixture.getProjectDir().getUserData(REMOTE_TO_LOCAL_MAPPING);
        CidrDebuggerDriverRemoteTestCase.assertNotNull((String)"No REMOTE_TO_LOCAL_MAPPING data", (Object)data);
        this.loadForRemote(connectionString, symbols, data);
    }

    protected void loadAndConnect(@NotNull String connectionString, @Nullable File symbols) throws ExecutionException {
        this.loadForRemote(connectionString, symbols);
        this.myInferior.start();
    }

    static enum PutBreakpoint {
        BEFORE_LOADING,
        AFTER_LOADING,
        AFTER_CONNECTION;

    }
}

