/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build.runners;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.build.runners.BackgroundableProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunnerKt;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J6\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010%\u001a\u00020\u0016H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/execution/build/runners/BackgroundableProjectTaskRunner;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "tasks", "", "Lcom/intellij/task/ProjectTask;", "parentRunner", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "totalPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "sessionId", "", "context", "Lcom/intellij/task/ProjectTaskContext;", "waitingIndicator", "Ljava/util/concurrent/Future;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/task/ProjectTask;Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;Lorg/jetbrains/concurrency/AsyncPromise;Ljava/lang/Object;Lcom/intellij/task/ProjectTaskContext;Ljava/util/concurrent/Future;)V", "executionStarted", "Lcom/intellij/util/concurrency/FutureResult;", "", "getExecutionStarted", "()Lcom/intellij/util/concurrency/FutureResult;", "[Lcom/intellij/task/ProjectTask;", "collectTasks", "", "([Lcom/intellij/task/ProjectTask;)Ljava/util/Collection;", "run", "", "indicator", "runTask", "Lorg/jetbrains/concurrency/Promise;", "runner", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "task", "waitForStart", "intellij.cidr.execution"})
final class BackgroundableProjectTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final FutureResult<Boolean> executionStarted;
    private final ProjectTask[] tasks;
    private final CidrProjectTaskRunner parentRunner;
    private final AsyncPromise<ProjectTaskRunner.Result> totalPromise;
    private final Object sessionId;
    private final ProjectTaskContext context;
    private final Future<ProgressIndicator> waitingIndicator;

    @NotNull
    public final FutureResult<Boolean> getExecutionStarted() {
        return this.executionStarted;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (!this.waitForStart()) {
            if (this.totalPromise.getState() == Promise.State.PENDING) {
                this.totalPromise.cancel();
            }
            return;
        }
        Collection<ProjectTask> myTasks = this.collectTasks(this.tasks);
        if (myTasks.isEmpty()) {
            this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
            return;
        }
        try {
            for (ProjectTask task : myTasks) {
                CidrTaskRunner taskRunner = this.parentRunner.runnerForTask(task, this.getProject());
                if (taskRunner == null) {
                    this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
                    break;
                }
                Promise<ProjectTaskRunner.Result> promise = this.runTask(taskRunner, this.getProject(), task, this.sessionId, this.context);
                if ((ProjectTaskRunner.Result)promise.blockingGet(Integer.MAX_VALUE) == TaskRunnerResults.SUCCESS) continue;
                this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
                break;
            }
            if (Promises.isPending((Promise)((Promise)this.totalPromise))) {
                this.totalPromise.setResult((Object)TaskRunnerResults.SUCCESS);
            }
        }
        catch (InterruptedException ex) {
            this.totalPromise.setResult((Object)TaskRunnerResults.ABORTED);
            throw (Throwable)new ProcessCanceledException((Throwable)ex);
        }
        catch (CancellationException ex) {
            this.totalPromise.setResult((Object)TaskRunnerResults.ABORTED);
            throw (Throwable)new ProcessCanceledException((Throwable)ex);
        }
        catch (Throwable ex) {
            CidrProjectTaskRunnerKt.access$getLOG$p().error(ex);
            this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
        }
    }

    private final boolean waitForStart() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return true;
        }
        try {
            boolean cancelled = this.waitingIndicator.get().isCanceled();
            this.executionStarted.set((Object)true);
            return !cancelled;
        }
        catch (InterruptedException ex) {
            this.totalPromise.setResult((Object)TaskRunnerResults.ABORTED);
            throw (Throwable)new ProcessCanceledException((Throwable)ex);
        }
        catch (CancellationException ex) {
            this.totalPromise.setResult((Object)TaskRunnerResults.ABORTED);
            throw (Throwable)new ProcessCanceledException((Throwable)ex);
        }
        catch (Throwable ex) {
            CidrProjectTaskRunnerKt.access$getLOG$p().error(ex);
            this.totalPromise.setResult((Object)TaskRunnerResults.FAILURE);
            throw (Throwable)new ProcessCanceledException(ex);
        }
    }

    private final Promise<ProjectTaskRunner.Result> runTask(CidrTaskRunner runner, Project project2, ProjectTask task, Object sessionId, ProjectTaskContext context) {
        return runner.executeTask(project2, task, sessionId, context);
    }

    private final Collection<ProjectTask> collectTasks(ProjectTask[] tasks2) {
        boolean bl;
        List expandedTasks2;
        block3: {
            expandedTasks2 = StreamsKt.toList(UtilKt.stream((Object[])tasks2).filter(new Predicate(this){
                final /* synthetic */ BackgroundableProjectTaskRunner this$0;

                public final boolean test(ProjectTask it) {
                    return BackgroundableProjectTaskRunner.access$getParentRunner$p(this.this$0).canRun(this.this$0.getProject(), it);
                }
                {
                    this.this$0 = backgroundableProjectTaskRunner;
                }
            }).map(new Function(this){
                final /* synthetic */ BackgroundableProjectTaskRunner this$0;

                public final Pair<ProjectTask, CidrTaskRunner> apply(ProjectTask it) {
                    return TuplesKt.to((Object)it, (Object)BackgroundableProjectTaskRunner.access$getParentRunner$p(this.this$0).runnerForTask(it, this.this$0.getProject()));
                }
                {
                    this.this$0 = backgroundableProjectTaskRunner;
                }
            }).filter(collectTasks.expandedTasks.3.INSTANCE).map(collectTasks.expandedTasks.4.INSTANCE));
            Iterable $this$any$iv = expandedTasks2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl2 = false;
                    if (!it.isEmpty()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.flatten((Iterable)expandedTasks2);
    }

    public BackgroundableProjectTaskRunner(@NotNull Project project2, @NotNull ProjectTask[] tasks2, @NotNull CidrProjectTaskRunner parentRunner, @NotNull AsyncPromise<ProjectTaskRunner.Result> totalPromise, @NotNull Object sessionId, @NotNull ProjectTaskContext context, @NotNull Future<ProgressIndicator> waitingIndicator) {
        super(project2, CidrExecutionBundle.message("build.progress", new Object[0]), true);
        this.tasks = tasks2;
        this.parentRunner = parentRunner;
        this.totalPromise = totalPromise;
        this.sessionId = sessionId;
        this.context = context;
        this.waitingIndicator = waitingIndicator;
        this.executionStarted = new FutureResult();
    }

    public static final /* synthetic */ CidrProjectTaskRunner access$getParentRunner$p(BackgroundableProjectTaskRunner $this) {
        return $this.parentRunner;
    }
}

