/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.MessageView;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.build.CidrBuild;
import com.jetbrains.cidr.execution.build.CidrBuildTaskType;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public abstract class ShowBuildConsoleInternalAction
extends AnAction
implements DumbAware {
    protected ShowBuildConsoleInternalAction(@NotNull Supplier<String> dynamicText) {
        super(dynamicText);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        String text = Messages.showMultilineInputDialog((Project)project2, (String)"", (String)CidrExecutionBundle.message("build.console.input.dialog", new Object[0]), (String)"", null, null);
        if (text == null) {
            return;
        }
        ProcessHandler processHandler = new ProcessHandler(){

            protected void destroyProcessImpl() {
            }

            protected void detachProcessImpl() {
            }

            public boolean detachIsDefault() {
                return false;
            }

            public OutputStream getProcessInput() {
                return null;
            }
        };
        CidrBuild.BuildContext context = new CidrBuild.BuildContext(project2, () -> ((Object)((Object)this)).getClass().getName() + "build configuration", CidrBuildTaskType.BUILD, CidrExecutionBundle.message("task.execution.build", new Object[0]), CidrExecutionBundle.message("build.progress", new Object[0]));
        context.processHandler = processHandler;
        context.indicator = new EmptyProgressIndicator();
        MessageView.getInstance((Project)project2).runWhenInitialized(() -> {
            this.createConsole(project2, context);
            processHandler.notifyTextAvailable(text, ProcessOutputTypes.STDOUT);
            ToolWindowManager.getInstance((Project)project2).getToolWindow("Messages").show(null);
        });
    }

    protected abstract void createConsole(Project var1, CidrBuild.BuildContext var2);
}

