/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.ExecutionException;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

public class CidrBuildUtil {
    public static AsyncPromise<ProjectTaskRunner.Result> toPromise(@NotNull ExecutionResult<CidrBuildResult> result) {
        AsyncPromise promise = new AsyncPromise();
        CidrBuildUtil.handleProjectTaskResults(result, (AsyncPromise<ProjectTaskRunner.Result>)promise);
        return promise;
    }

    public static void handleProjectTaskResults(@NotNull ExecutionResult<CidrBuildResult> result, @NotNull AsyncPromise<ProjectTaskRunner.Result> promise) {
        try {
            CidrBuildResult buildResult = (CidrBuildResult)result.get();
            if (buildResult.getCanceled()) {
                promise.setResult((Object)TaskRunnerResults.ABORTED);
            } else if (buildResult.getSucceeded()) {
                promise.setResult((Object)TaskRunnerResults.SUCCESS);
            } else {
                promise.setResult((Object)TaskRunnerResults.FAILURE);
            }
        }
        catch (ExecutionException ex) {
            promise.setResult((Object)TaskRunnerResults.FAILURE);
        }
    }
}

