/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.build.events.BuildEventsNls;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.TraceableExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildEvent;
import com.jetbrains.cidr.execution.build.CidrBuildId;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.CidrBuildTaskType;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBuild {
    private static final NotificationGroup LOG_NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Build Log", (String)CidrExecutionBundle.message("build.log.notification.group.name", new Object[0]));
    public static final Logger LOG = Logger.getInstance(CidrBuild.class);

    public static ExecutionResult<CidrBuildResult> execute(final @NotNull Project project2, final @NotNull BuildContext context, @NotNull CidrToolEnvironment environment, @NotNull Runnable doExecute) {
        final Object processCreationLock = new Object();
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            context.indicator = new EmptyProgressIndicator();
        } else {
            final ExecutionResult indicatorResult = new ExecutionResult();
            UIUtil.invokeLaterIfNeeded(() -> new Task.Backgroundable(project2, context.taskName, true){

                public void run(@NotNull ProgressIndicator indicator) {
                    indicatorResult.set((Object)indicator);
                    DumbService.getInstance((Project)project2).suspendIndexingAndRun(CidrExecutionBundle.message("activity.name.build", new Object[0]), () -> {
                        boolean wasCanceled = false;
                        while (!context2.myResult.isDone()) {
                            if (!wasCanceled && indicator.isCanceled()) {
                                wasCanceled = true;
                                Object object = processCreationLock;
                                synchronized (object) {
                                    ProcessHandler process = context2.processHandler;
                                    if (process != null) {
                                        process.destroyProcess();
                                    }
                                }
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                throw new ProcessCanceledException((Throwable)e);
                            }
                        }
                    });
                }
            }.queue());
            try {
                context.indicator = (ProgressIndicator)indicatorResult.get();
                context.indicator.setText(context.progressTitle);
                context.indicator.setText2("");
            }
            catch (ExecutionException e) {
                context.myResult.setException((Throwable)e);
                return context.myResult;
            }
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!context.waitAndStart()) {
                return;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
            environment.getHostMachine().waitForFilesSync(context.indicator);
            TransactionGuard.submitTransaction((Disposable)project2, () -> {
                Object object = processCreationLock;
                synchronized (object) {
                    if (context.indicator.isCanceled()) {
                        context.canceled();
                        return;
                    }
                    MessageView.getInstance((Project)project2).runWhenInitialized(() -> {
                        try {
                            doExecute.run();
                        }
                        catch (Throwable e) {
                            context.error(e);
                            throw e;
                        }
                    });
                }
            });
        });
        return context.myResult;
    }

    public static void startProcess(final @NotNull Project project2, final BuildContext context, final Collection<File> toRefresh) {
        context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                context.indicator.setText(CidrExecutionBundle.message("build.refreshing", new Object[0]));
                context.indicator.setText2("");
                CidrBuild.refreshFiles(toRefresh, context.refreshAsync, () -> {
                    if (project2.isDisposed()) {
                        return;
                    }
                    boolean buildSucceeded = event.getExitCode() == 0;
                    boolean canceled = context2.indicator.isCanceled();
                    long duration = System.currentTimeMillis() - context2.started;
                    CidrBuildResult buildResult = new CidrBuildResult(buildSucceeded, canceled, context2.started, duration, context2.errors, context2.warnings);
                    String fullMessage = CidrBuild.buildNotificationMessage(context2.taskName, buildResult);
                    CidrBuildResult buildResultWithMessage = buildResult.withMessage(fullMessage);
                    context.finished(buildResultWithMessage);
                    CidrBuild.showBuildNotification(project2, context2.taskName, buildResultWithMessage);
                });
            }
        });
        ((CidrBuildListener)project2.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).beforeStarted(new CidrBuildEvent(context.buildConfiguration, context.taskType, context.id));
        context.processHandler.startNotify();
    }

    public static void refreshFiles(@NotNull Collection<File> files, @NotNull Runnable onFinish) {
        CidrBuild.doRefreshFiles(files, onFinish);
    }

    private static void refreshFiles(@NotNull Collection<File> files, boolean async, @NotNull Runnable onFinish) {
        if (async) {
            CidrBuild.doRefreshFiles(files, () -> {});
            onFinish.run();
        } else {
            CidrBuild.doRefreshFiles(files, onFinish);
        }
    }

    private static void doRefreshFiles(@NotNull Collection<File> files, @NotNull Runnable onFinish) {
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            HashSet<File> toRefreshOneByOne = new HashSet<File>();
            HashSet<VirtualFile> virtualFiles = new HashSet<VirtualFile>();
            for (File file2 : files) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
                if (virtualFile == null || !virtualFile.isValid()) {
                    toRefreshOneByOne.add(file2);
                    continue;
                }
                virtualFiles.add(virtualFile);
            }
            for (File file2 : toRefreshOneByOne) {
                virtualFiles.add(VfsUtil.findFileByIoFile((File)file2, (boolean)true));
            }
            List list = VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray(virtualFiles));
            RefreshQueue.getInstance().refresh(true, true, onFinish, ModalityState.NON_MODAL, (Collection)list);
        });
    }

    @BuildEventsNls.Message
    @NotNull
    private static String buildNotificationMessage(@BuildEventsNls.Title String taskName, @NotNull CidrBuildResult buildResult) {
        if (buildResult.getCanceled()) {
            return CidrExecutionBundle.message("build.canceled", taskName);
        }
        boolean hasWarningsOrErrors = buildResult.getErrors() > 0 || buildResult.getWarnings() > 0;
        boolean hasDuration = buildResult.getDuration() > 0L;
        boolean isSucceeded = buildResult.getSucceeded();
        String durationString = NlsMessages.formatDurationApproximate((long)buildResult.getDuration());
        if (!hasDuration && !hasWarningsOrErrors) {
            return isSucceeded ? CidrExecutionBundle.message("build.finished", taskName) : CidrExecutionBundle.message("build.failed", taskName);
        }
        if (hasDuration && !hasWarningsOrErrors) {
            return isSucceeded ? CidrExecutionBundle.message("build.finished.duration", taskName, durationString) : CidrExecutionBundle.message("build.failed.duration", taskName, durationString);
        }
        if (!hasDuration) {
            return isSucceeded ? CidrExecutionBundle.message("task.finished.with.details", taskName, buildResult.getErrors(), buildResult.getWarnings()) : CidrExecutionBundle.message("task.failed.with.details", taskName, buildResult.getErrors(), buildResult.getWarnings());
        }
        return isSucceeded ? CidrExecutionBundle.message("task.finished.with.details.and.duration", taskName, buildResult.getErrors(), buildResult.getWarnings(), durationString) : CidrExecutionBundle.message("task.failed.with.details.and.duration", taskName, buildResult.getErrors(), buildResult.getWarnings(), durationString);
    }

    public static String showBuildNotification(@NotNull Project project2, @NotNull MessageType messageType, @NotNull @Nls String message) {
        return CidrBuild.showBuildNotification(project2, "Messages", messageType, message);
    }

    public static String showBuildNotification(@NotNull Project project2, @NonNls @NotNull String toolWindowId, @NotNull MessageType messageType, @NotNull @Nls String message) {
        return CidrBuild.showBuildNotification(project2, toolWindowId, messageType, message, message, null);
    }

    private static void showBuildNotification(@NotNull Project project2, @BuildEventsNls.Title @NotNull String taskName, @NotNull CidrBuildResult buildResult) {
        MessageType messageType;
        String notificationTitle;
        String balloonContent = buildResult.getMessage();
        String notificationText = null;
        if (buildResult.getCanceled()) {
            notificationTitle = CidrExecutionBundle.message("build.canceled", taskName);
            messageType = MessageType.INFO;
        } else {
            boolean hasWarningsOrErrors;
            boolean bl = hasWarningsOrErrors = buildResult.getErrors() > 0 || buildResult.getWarnings() > 0;
            messageType = !buildResult.getSucceeded() ? MessageType.ERROR : (hasWarningsOrErrors ? MessageType.WARNING : MessageType.INFO);
            notificationTitle = buildResult.getSucceeded() ? CidrExecutionBundle.message("build.finished", taskName) : CidrExecutionBundle.message("build.failed", taskName);
            notificationText = hasWarningsOrErrors ? CidrExecutionBundle.message("build.details", buildResult.getErrors(), buildResult.getWarnings()) : null;
        }
        CidrBuild.showBuildNotification(project2, "Messages", messageType, balloonContent, notificationTitle, notificationText);
    }

    private static String showBuildNotification(@NotNull Project project2, @NonNls @NotNull String balloonToolWindow, @NotNull MessageType balloonType, @Nls @NotNull String balloonContent, @NlsContexts.SystemNotificationTitle @NotNull String notificationTitle, @NlsContexts.SystemNotificationText @Nullable String notificationText) {
        Notification notification = LOG_NOTIFICATION_GROUP.createNotification(balloonContent, balloonType);
        notification.notify(project2);
        if (balloonType == MessageType.ERROR) {
            ToolWindowManager manager2 = ToolWindowManager.getInstance((Project)project2);
            ToolWindow toolWindow = manager2.getToolWindow(balloonToolWindow);
            String balloonToolWindowId = toolWindow == null ? "Messages" : balloonToolWindow;
            Runnable runnable = () -> manager2.notifyByBalloon(balloonToolWindowId, balloonType, balloonContent);
            if (toolWindow == null) {
                MessageView.getInstance((Project)project2).runWhenInitialized(runnable);
            } else {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
        }
        SystemNotifications.getInstance().notify(notification.getGroupId(), notificationTitle, StringUtil.notNullize((String)notificationText));
        return balloonContent;
    }

    public static Pair<AnAction, Disposable> initializeBuildLog(@NotNull BuildContext context, @NonNls @NotNull String logName) {
        File file2 = null;
        FileWriter writer = null;
        try {
            file2 = FileUtil.createTempFile((String)logName, (String)".log", (boolean)true);
            writer = new FileWriter(file2);
        }
        catch (IOException e) {
            LOG.error("Cannot create build log file", (Throwable)e);
        }
        final File finalFile = file2;
        final FileWriter finalWriter = writer;
        AnAction showBuildLogAction = new AnAction(CidrExecutionBundle.messagePointer("build.action.showLog", new Object[0]), AllIcons.Debugger.Console){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (finalFile == null) {
                    return;
                }
                try {
                    Runtime.getRuntime().exec("open " + finalFile.getPath());
                }
                catch (IOException e) {
                    LOG.error("Cannot open build log file: " + finalFile, (Throwable)e);
                }
            }

            public boolean isDumbAware() {
                return true;
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(finalFile != null);
            }
        };
        if (finalWriter != null) {
            context.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    try {
                        finalWriter.write(event.getText());
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }
            });
        }
        Disposable disposable = new Disposable(){

            public void dispose() {
                if (finalWriter != null) {
                    try {
                        finalWriter.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                if (finalFile != null) {
                    FileUtil.delete((File)finalFile);
                }
            }
        };
        return Pair.create((Object)showBuildLogAction, (Object)disposable);
    }

    public static class BuildContentRemoveListener
    implements ContentManagerListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ContentManager myContentManager;
        @NotNull
        private final Content myContent;
        @NotNull
        private final BuildContext myContext;

        public BuildContentRemoveListener(@NotNull Project project2, @NotNull ContentManager contentManager, @NotNull Content content, @NotNull BuildContext context) {
            this.myProject = project2;
            this.myContentManager = contentManager;
            this.myContent = content;
            this.myContext = context;
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event.getContent() != this.myContent) {
                return;
            }
            this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
        }

        public void contentRemoveQuery(@NotNull ContentManagerEvent event) {
            if (event.getContent() != this.myContent) {
                return;
            }
            if (this.myContext.isRunning()) {
                int result = Messages.showYesNoDialog((Project)this.myProject, (String)CidrExecutionBundle.message("build.inProgress.cancelQuestion", new Object[0]), (String)CidrExecutionBundle.message("build.inProgress", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result == 0) {
                    this.myContext.stop();
                } else {
                    event.consume();
                }
            }
        }
    }

    public static class BuildContext {
        @NotNull
        protected final ExecutionResult<CidrBuildResult> myResult = new TraceableExecutionResult();
        private static final Key<Semaphore> BUILD_SEMAPHORE_KEY = Key.create((String)"BUILD_SEMAPHORE_KEY");
        @NotNull
        public final CidrBuildId id;
        @NotNull
        public final CidrBuildConfiguration buildConfiguration;
        @NotNull
        public final CidrBuildTaskType taskType;
        @NotNull
        @Nls
        public final String taskName;
        @NotNull
        public final @NlsContexts.ProgressText String progressTitle;
        private final Project myProject;
        private final Semaphore myBuildSemaphore;
        private final boolean refreshAsync = Registry.is((String)"cidr.asynchronous.refresh.after.build", (boolean)false);
        private final long started = System.currentTimeMillis();
        @NotNull
        public volatile ProgressIndicator indicator;
        @NotNull
        public volatile ProcessHandler processHandler;
        public volatile int errors;
        public volatile int warnings;

        public BuildContext(@NotNull Project project2, @NotNull CidrBuildConfiguration buildConfiguration, @Nullable CidrBuildTaskType taskType, @NotNull @Nls String taskName, @NotNull @NlsContexts.ProgressText String progressTitle) {
            this.myProject = project2;
            this.id = CidrBuildId.create();
            this.buildConfiguration = buildConfiguration;
            this.taskType = taskType == null ? CidrBuildTaskType.BUILD : taskType;
            this.taskName = taskName;
            this.progressTitle = progressTitle;
            Semaphore semaphore = (Semaphore)this.myProject.getUserData(BUILD_SEMAPHORE_KEY);
            if (semaphore == null) {
                semaphore = (Semaphore)((UserDataHolderEx)this.myProject).putUserDataIfAbsent(BUILD_SEMAPHORE_KEY, (Object)new Semaphore(1));
            }
            this.myBuildSemaphore = semaphore;
        }

        public boolean isRunning() {
            return !this.indicator.isCanceled() && !this.processHandler.isProcessTerminated() && !this.processHandler.isProcessTerminating();
        }

        public ExecutionResult<CidrBuildResult> getResult() {
            return this.myResult;
        }

        public void stop() {
            this.indicator.cancel();
        }

        /*
         * Exception decompiling
         */
        public boolean waitAndStart() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void finished(@NotNull CidrBuildResult buildResult) {
            this.myBuildSemaphore.release();
            this.myResult.set((Object)buildResult);
            ((CidrBuildListener)this.myProject.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).afterFinished(new CidrBuildEvent(this.buildConfiguration, this.taskType, this.id), buildResult);
        }

        private void canceled() {
            if (this.processHandler == null) {
                this.myBuildSemaphore.release();
            }
            this.myResult.set((Object)new CidrBuildResult(false, true, this.started, System.currentTimeMillis() - this.started, this.errors, this.warnings, CidrExecutionBundle.message("build.canceled", this.taskName)));
        }

        public void error(Throwable e) {
            this.myBuildSemaphore.release();
            this.myResult.setException(e);
        }
    }
}

