/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.build;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.NlsActions;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.jetbrains.cidr.execution.CidrProjectTaskContextProvider;
import com.jetbrains.cidr.execution.build.CidrBuildConfigurationProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H%J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/execution/build/CidrAbstractBuildTargetAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "isIncrementalBuild", "", "title", "", "description", "icon", "Ljavax/swing/Icon;", "(ZLjava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildText", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "createContext", "Lcom/intellij/task/ProjectTaskContext;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getBuildableElements", "", "Lcom/intellij/openapi/roots/ProjectModelBuildableElement;", "isEnabled", "update", "intellij.cidr.execution"})
public abstract class CidrAbstractBuildTargetAction
extends DumbAwareAction {
    private final boolean isIncrementalBuild;

    public void update(@NotNull AnActionEvent e) {
        Project project2 = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(this.isEnabled(project2));
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project2).getSelectedConfiguration();
        RunConfiguration configuration2 = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        e.getPresentation().setText(this.buildText(configuration2), false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = DumbAwareAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        List<ProjectModelBuildableElement> buildableElements = this.getBuildableElements(project3);
        if (buildableElements.isEmpty()) {
            return;
        }
        ProjectTaskContext context = this.createContext(project3, e.getDataContext());
        ProjectTaskManager manager2 = ProjectTaskManager.getInstance((Project)project3);
        Collection $this$toTypedArray$iv = buildableElements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ProjectModelBuildableElement[] projectModelBuildableElementArray = thisCollection$iv.toArray(new ProjectModelBuildableElement[0]);
        if (projectModelBuildableElementArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        manager2.run(context, manager2.createBuildTask(this.isIncrementalBuild, Arrays.copyOf(projectModelBuildableElementArray, projectModelBuildableElementArray.length)));
    }

    protected boolean isEnabled(@NotNull Project project2) {
        return CidrBuildConfigurationProvider.EP_NAME.extensions().anyMatch(new Predicate(this, project2){
            final /* synthetic */ CidrAbstractBuildTargetAction this$0;
            final /* synthetic */ Project $project;

            public final boolean test(CidrBuildConfigurationProvider it) {
                return it.hasBuildableConfigurations(this.$project) && (this.this$0.isIncrementalBuild() || it.hasCleanableConfigurations(this.$project));
            }
            {
                this.this$0 = cidrAbstractBuildTargetAction;
                this.$project = project2;
            }
        });
    }

    @NotNull
    protected List<ProjectModelBuildableElement> getBuildableElements(@NotNull Project project2) {
        List<ProjectModelBuildableElement> buildableConfigurations;
        List<ProjectModelBuildableElement> list;
        Object v0;
        block3: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)CidrBuildConfigurationProvider.EP_NAME.getExtensionList();
            for (Object t : iterable2) {
                CidrBuildConfigurationProvider it = (CidrBuildConfigurationProvider)t;
                boolean bl = false;
                if (!it.hasBuildableConfigurations(project2)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((list = (CidrBuildConfigurationProvider)v0) == null || (list = list.getBuildableConfigurations(project2)) == null) {
            list = buildableConfigurations = CollectionsKt.emptyList();
        }
        if (buildableConfigurations.isEmpty()) {
            new EditConfigurationsDialog(project2).show();
        }
        return buildableConfigurations;
    }

    @NotNull
    protected ProjectTaskContext createContext(@NotNull Project project2, @NotNull DataContext dataContext) {
        return CidrProjectTaskContextProvider.Companion.createContext(project2, dataContext);
    }

    @Nls
    @NotNull
    protected abstract String buildText(@Nullable RunConfiguration var1);

    public final boolean isIncrementalBuild() {
        return this.isIncrementalBuild;
    }

    public CidrAbstractBuildTargetAction(boolean isIncrementalBuild, @NlsActions.ActionText @Nullable String title, @NlsActions.ActionDescription @Nullable String description2, @Nullable Icon icon) {
        super(title, description2, icon);
        this.isIncrementalBuild = isIncrementalBuild;
    }
}

