/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.statistics.CidrTestingFrameworkCounterUsagesCollector;
import com.jetbrains.cidr.statistics.CidrTestingFrameworkProjectUsagesCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunner
implements ProgramRunner<RunnerSettings> {
    public final void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        ExecutionManager.getInstance((Project)environment.getProject()).startRunProfile(environment, state -> this.doExecute((RunProfileState)state, environment));
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        return DefaultProgramRunnerKt.executeState((RunProfileState)state, (ExecutionEnvironment)environment, (ProgramRunner)this);
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (profile instanceof RunConfigurationWithSuppressedDefaultRunAction && "Run".equals(executorId)) {
            return false;
        }
        if (profile instanceof RunConfigurationWithSuppressedDefaultDebugAction && "Debug".equals(executorId)) {
            return false;
        }
        return profile instanceof CidrRunProfile;
    }

    protected static void triggerUsage(@Nullable RunnerAndConfigurationSettings configuration2) {
        RunConfiguration runConfiguration;
        String frameworkId;
        if (configuration2 != null && (frameworkId = CidrTestingFrameworkProjectUsagesCollector.getFrameworkId(runConfiguration = configuration2.getConfiguration())) != null) {
            CidrTestingFrameworkCounterUsagesCollector.TEST_RUN.log(runConfiguration.getProject(), (Object)frameworkId);
        }
    }

    public XDebugSession startDebugSession(final CidrCommandLineState state, ExecutionEnvironment env, final boolean muteBreakpoints, final XDebugSessionListener ... listeners) throws ExecutionException {
        XDebugSession session = XDebuggerManager.getInstance((Project)env.getProject()).startSession(env, (XDebugProcessStarter)new XDebugProcessConfiguratorStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                for (XDebugSessionListener l : listeners) {
                    session.addSessionListener(l);
                }
                return state.startDebugProcess(session);
            }

            public void configure(XDebugSessionData data) {
                if (muteBreakpoints) {
                    data.setBreakpointsMuted(true);
                }
            }
        });
        CidrRunner.configureDebugSessionUI(session);
        return session;
    }

    private static void configureDebugSessionUI(@NotNull XDebugSession session) {
        RunnerLayoutUi runnerLayoutUi;
        ConsoleView consoleView = session.getConsoleView();
        if (consoleView instanceof ConsoleViewWrapperBase && (runnerLayoutUi = session.getUI()) != null) {
            ((ExecutionConsoleEx)consoleView).buildUi(runnerLayoutUi);
        }
    }
}

