/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationBuildConfigurationEditor;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import com.jetbrains.cidr.ui.InvalidItem;
import com.jetbrains.cidr.ui.SortedCollectionComboBoxModel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunConfigurationSettingsEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends SettingsEditor<CONFIGURATION>
implements PanelWithAnchor {
    protected final Project myProject;
    protected final BCH myConfigHelper;
    private JComponent myAnchor;
    private JBLabel myTargetLabel;
    protected JComboBox myTargetCombo;
    protected CidrRunConfigurationBuildConfigurationEditor myConfigurationEditor;
    protected CommonProgramParametersPanel myCommonProgramParameters;

    public CidrRunConfigurationSettingsEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        this.myProject = project2;
        this.myConfigHelper = configHelper;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultFill(1).setDefaultAnchor(10).setDefaultWeightX(1, 1.0).setDefaultInsets(0, (Insets)JBUI.insets((int)0, (int)0, (int)4, (int)10)).setDefaultInsets(1, (Insets)JBUI.insetsBottom((int)4));
        this.createEditorInner(panel, g);
        this.setAnchor(this.myCommonProgramParameters.getAnchor());
        return panel;
    }

    @NotNull
    @NlsContexts.Label
    protected String getTargetComboTitle() {
        return ((CidrBuildConfigurationHelper)this.myConfigHelper).getTargetTitle();
    }

    protected void createEditorInner(JPanel panel, GridBag g) {
        this.setupTargetCombo(panel, g);
        this.setupConfigurationCombo(panel, g);
        this.createAdditionalControls(panel, g);
        this.setupCommonProgramParametersPanel(panel, g);
    }

    protected void setupTargetCombo(@NotNull JPanel panel, @NotNull GridBag g) {
        this.myTargetLabel = new JBLabel(this.getTargetComboTitle() + ":");
        panel.add((Component)this.myTargetLabel, g.nextLine().next());
        ComboBoxComponent container = this.createTargetComboBox();
        JComponent component = container.component;
        panel.add((Component)component, g.next().coverLine());
        this.myTargetCombo = container.comboBox;
        new ComboboxSpeedSearch(this.myTargetCombo);
        this.myTargetLabel.setLabelFor((Component)component);
        this.myTargetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && CidrRunConfigurationSettingsEditor.this.myTargetCombo.getItemCount() > 0) {
                    return;
                }
                CidrBuildTarget target = e.getStateChange() == 1 ? (CidrBuildTarget)ComboBoxModelKt.getItemValue((ItemEvent)e) : null;
                CidrRunConfigurationSettingsEditor.this.onTargetSelected(target);
            }
        });
        this.resetTargets();
        this.myTargetCombo.setRenderer(CidrRunConfigurationEditorUtil.getTargetsRenderer(this.myConfigHelper));
    }

    protected void setupConfigurationCombo(@NotNull JPanel panel, @NotNull GridBag g) {
        this.myConfigurationEditor = CidrRunConfigurationBuildConfigurationEditor.getInstance(this.myConfigHelper, this.myTargetCombo);
        this.myConfigurationEditor.createAdditionalControls(panel, g);
    }

    protected void setupCommonProgramParametersPanel(@NotNull JPanel panel, @NotNull GridBag g) {
        this.myCommonProgramParameters = this.createProgramParametersPanel();
        panel.add((Component)this.myCommonProgramParameters, g.nextLine().weighty(1.0).insets(8, -1, 8, -1).coverLine());
    }

    @NotNull
    protected CommonProgramParametersPanel createProgramParametersPanel() {
        return new CommonProgramParametersPanel();
    }

    protected void resetTargets() {
        ComboBoxModel oldModel = this.myTargetCombo.getModel();
        Object oldSelected = oldModel.getSelectedItem();
        SortedCollectionComboBoxModel model = new SortedCollectionComboBoxModel(ComparisonsKt.compareBy((Function1[])new Function1[]{it -> {
            if (it == null) {
                return Integer.valueOf(0);
            }
            if (it instanceof CidrBuildTarget) {
                return Integer.valueOf(4);
            }
            return Integer.valueOf(10);
        }}));
        model.addAll(this.getTargets());
        this.myTargetCombo.setModel(model);
        this.myTargetCombo.setSelectedItem(null);
        if (oldSelected != null) {
            BuildTargetData oldTargetData = CidrRunConfigurationSettingsEditor.itemToTargetData(oldSelected);
            Object toSelect = model.contains(oldSelected) ? oldSelected : ReadAction.compute(() -> ((CidrBuildConfigurationHelper)this.myConfigHelper).findTarget(oldTargetData));
            CidrRunConfigurationEditorUtil.setSelectedItem(this.myTargetCombo, toSelect, oldTargetData);
        }
    }

    @Nullable
    private static BuildTargetData itemToTargetData(@Nullable Object item) {
        if (item instanceof BuildTargetData) {
            return (BuildTargetData)item;
        }
        if (item instanceof CidrBuildTarget) {
            return new BuildTargetData((CidrBuildTarget)item);
        }
        if (item instanceof InvalidItem) {
            return (BuildTargetData)((InvalidItem)item).getValue();
        }
        return null;
    }

    @NotNull
    protected List<TARGET> getTargets() {
        return ((CidrBuildConfigurationHelper)this.myConfigHelper).getTargets();
    }

    protected void createAdditionalControls(JPanel panel, GridBag g) {
    }

    protected void onTargetSelected(@Nullable TARGET target) {
    }

    protected void resetEditorFrom(@NotNull CONFIGURATION runConfiguration) {
        this.resetBuildAndConfigurationFrom(runConfiguration);
        this.myCommonProgramParameters.reset(runConfiguration);
    }

    protected void resetBuildAndConfigurationFrom(@NotNull CONFIGURATION runConfiguration) {
        BuildTargetAndConfigurationData buildData = ((CidrRunConfiguration)runConfiguration).getTargetAndConfigurationData();
        BuildTargetData buildTargetData = buildData == null ? null : buildData.target;
        ReadAction.run(() -> {
            Object buildTarget = ((CidrBuildConfigurationHelper)this.myConfigHelper).findTarget(buildTargetData);
            Object buildConfig = ((CidrBuildConfigurationHelper)this.myConfigHelper).findConfiguration(buildTarget, buildData == null ? null : buildData.configurationName);
            CidrRunConfigurationEditorUtil.setSelectedItem(this.myTargetCombo, buildTarget, buildTargetData);
            this.myConfigurationEditor.selectConfiguration(buildConfig, buildData == null ? null : buildData.configurationName);
        });
    }

    protected void applyEditorTo(@NotNull CONFIGURATION runConfiguration) throws ConfigurationException {
        this.applyBuildAndConfigurationTo(runConfiguration);
        this.myCommonProgramParameters.applyTo(runConfiguration);
    }

    @Nullable
    public BuildTargetData getSelectedBuildTargetData() {
        CidrBuildTarget selectedBuildTarget = (CidrBuildTarget)ComboBoxModelKt.getSelectedItemValue((JComboBox)this.myTargetCombo);
        return selectedBuildTarget != null ? new BuildTargetData(selectedBuildTarget) : (BuildTargetData)ComboBoxModelKt.getSelectedInvalidItemValue((JComboBox)this.myTargetCombo);
    }

    protected void applyBuildAndConfigurationTo(@NotNull CONFIGURATION runConfiguration) {
        BuildTargetData selectedBuildTargetData = this.getSelectedBuildTargetData();
        String selectedConfigurationName = this.myConfigurationEditor.getSelectedConfiguration();
        ((CidrRunConfiguration)runConfiguration).setTargetAndConfigurationData(new BuildTargetAndConfigurationData(selectedBuildTargetData, selectedConfigurationName));
        this.syncBuildAndExecute(runConfiguration, selectedBuildTargetData);
    }

    protected void syncBuildAndExecute(@NotNull CONFIGURATION configuration2, @Nullable BuildTargetData buildTargetData) {
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myTargetLabel.setAnchor(anchor);
    }

    @NotNull
    protected ComboBoxComponent createTargetComboBox() {
        return new ComboBoxComponent((JComboBox)((Object)CidrRunConfigurationEditorUtil.createCombo()));
    }

    protected static class ComboBoxComponent {
        @NotNull
        public final JComboBox comboBox;
        @NotNull
        public final JComponent component;

        public ComboBoxComponent(JComboBox comboBox) {
            this(comboBox, comboBox);
        }

        public ComboBoxComponent(@NotNull JComponent component, @NotNull JComboBox comboBox) {
            this.comboBox = comboBox;
            this.component = component;
        }
    }
}

