/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionBase;
import com.jetbrains.cidr.execution.ConfigurationExtensionContext;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrRunConfigurationExtensionsManager
extends RunConfigurationExtensionsManager<CidrRunConfiguration<?, ?>, CidrRunConfigurationExtensionBase> {
    private static final Logger LOG = Logger.getInstance(CidrRunConfigurationExtensionsManager.class);

    public CidrRunConfigurationExtensionsManager() {
        super(CidrRunConfigurationExtensionBase.EP_NAME);
    }

    public static CidrRunConfigurationExtensionsManager getInstance() {
        return (CidrRunConfigurationExtensionsManager)((Object)ApplicationManager.getApplication().getService(CidrRunConfigurationExtensionsManager.class));
    }

    public void patchCommandLineState(@NotNull CidrRunConfiguration configuration2, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @Nullable File projectBaseDir, @NotNull CommandLineState state, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration2, environment, runnerSettings)) {
            extension.patchCommandLineState(configuration2, runnerSettings, environment, projectBaseDir, state, runnerId, context);
        }
    }

    @Deprecated
    public void patchCommandLine(@NotNull CidrRunConfiguration configuration2, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        LOG.error("This method is deprecated. Use another signature instead.");
    }

    public void patchCommandLine(@NotNull CidrRunConfiguration configuration2, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) throws ExecutionException {
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration2, environment, runnerSettings)) {
            extension.patchCommandLine(configuration2, runnerSettings, environment, cmdLine, runnerId, context);
        }
    }

    @Deprecated
    public void attachExtensionsToProcess(@NotNull CidrRunConfiguration configuration2, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        LOG.error("This method is deprecated. Use another signature instead.");
    }

    public void attachExtensionsToProcess(@NotNull CidrRunConfiguration configuration2, @NotNull ProcessHandler handler, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        for (CidrRunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration2, environment, runnerSettings)) {
            extension.attachToProcess(configuration2, handler, environment, runnerSettings, runnerId, context);
        }
    }

    @NotNull
    private List<CidrRunConfigurationExtensionBase> getEnabledExtensions(@NotNull CidrRunConfiguration configuration2, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings) {
        SmartList extensions = new SmartList();
        for (CidrRunConfigurationExtensionBase extension : this.getApplicableExtensions((RunConfigurationBase)configuration2)) {
            if (!extension.isEnabledFor(configuration2, environment, runnerSettings)) continue;
            extensions.add(extension);
        }
        return Collections.unmodifiableList(extensions);
    }
}

