/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.CidrProgramParameters;
import com.jetbrains.cidr.execution.ConsoleOptions;
import com.jetbrains.cidr.execution.ElevationOptions;
import com.jetbrains.cidr.execution.EnvironmentFileOptions;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrProgramParametersConfigurator
extends ProgramParametersConfigurator {
    public void configureConfiguration(@NotNull SimpleProgramParameters parameters, @NotNull CommonProgramRunConfigurationParameters configuration2) {
        super.configureConfiguration(parameters, configuration2);
        if (parameters instanceof CidrProgramParameters) {
            CidrProgramParameters cidrParameters = (CidrProgramParameters)parameters;
            if (configuration2 instanceof InputRedirectAware.InputRedirectOptions) {
                InputRedirectAware.InputRedirectOptions redirectOptions = (InputRedirectAware.InputRedirectOptions)configuration2;
                String redirectInputPath = this.getRedirectInputPath(redirectOptions, configuration2.getProject(), CidrProgramParameters.pathToFile(parameters.getWorkingDirectory()));
                cidrParameters.setRedirectInputPath(redirectInputPath);
            }
            if (configuration2 instanceof ElevationOptions) {
                ElevationOptions elevationOptions = (ElevationOptions)configuration2;
                cidrParameters.setElevated(elevationOptions.isElevated());
            }
            if (configuration2 instanceof EnvironmentFileOptions) {
                cidrParameters.setEnvironmentFile(((EnvironmentFileOptions)configuration2).getEnvironmentFile());
            }
            if (configuration2 instanceof ConsoleOptions) {
                ConsoleOptions consoleOptions = (ConsoleOptions)configuration2;
                cidrParameters.setUseExternalConsole(consoleOptions.isUseExternalConsole());
            }
        }
    }

    @Nullable
    private String getRedirectInputPath(@NotNull InputRedirectAware.InputRedirectOptions redirectOptions, @NotNull Project project2, @Nullable File workDirectory) {
        if (!redirectOptions.isRedirectInput()) {
            return null;
        }
        String redirectInputPath = redirectOptions.getRedirectInputPath();
        if (redirectInputPath == null) {
            return null;
        }
        File redirectInputFile = CidrProgramParameters.pathToFile(redirectInputPath = this.expandPathAndMacros(redirectInputPath, null, project2));
        if (redirectInputFile == null) {
            return null;
        }
        if (workDirectory != null && !redirectInputFile.isAbsolute()) {
            redirectInputFile = new File(workDirectory, redirectInputPath);
        }
        return redirectInputFile.getPath();
    }
}

