/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrResolveConfigurationProvider;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrContextRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>>
extends RunConfigurationProducer<CONFIGURATION> {
    protected final CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> myBinder;

    protected CidrContextRunConfigurationProducer(@NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        super(true);
        this.myBinder = binder;
    }

    @NotNull
    protected List<TARGET> getTargetsForFile(@Nullable PsiFile containingFile, @NotNull Predicate<TARGET> condition) {
        if (containingFile == null) {
            return Collections.emptyList();
        }
        ArrayList<OCResolveConfiguration> orderedConfigurations = new ArrayList<OCResolveConfiguration>(OCWorkspace.getInstance(containingFile.getProject()).getConfigurations());
        CidrResolveConfigurationProvider.EP_NAME.extensions().forEach(provider -> orderedConfigurations.retainAll(provider.getAllResolveConfigurationsForFile(containingFile, null)));
        ArrayList<TARGET> targets = new ArrayList<TARGET>(orderedConfigurations.size());
        for (OCResolveConfiguration configuration2 : orderedConfigurations) {
            TARGET target = this.myBinder.getTargetFromResolveConfiguration(configuration2);
            if (target == null || !condition.test(target)) continue;
            targets.add(target);
        }
        return Collections.unmodifiableList(targets);
    }

    @NotNull
    public List<TARGET> getExecutableTargetsForFile(@Nullable PsiFile containingFile) {
        return this.getTargetsForFile(containingFile, CidrBuildTarget::isExecutable);
    }

    public void setupTarget(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull List<TARGET> targetsWithContext) {
        this.findBuiltTargetAndConfiguration(newConfigurationWithTemplateDefaults, targetsWithContext, true);
    }

    @Nullable
    protected BuildTargetAndConfigurationData findBuiltTargetAndConfiguration(@NotNull CONFIGURATION configuration2, @NotNull List<TARGET> targetsWithContext, boolean adjustConfigurationFromContext) {
        Pair<TARGET, BC> selectedTargetAndConfig;
        if (targetsWithContext.isEmpty()) {
            return null;
        }
        CidrBuildTarget target = null;
        CidrBuildConfigurationHelper<CidrBuildConfiguration, CidrBuildTarget> helper = ((CidrRunConfiguration)configuration2).getHelper();
        Project project2 = configuration2.getProject();
        BuildTargetAndConfigurationData data = null;
        RunnerAndConfigurationSettings selectedSettings = RunManager.getInstance((Project)project2).getSelectedConfiguration();
        if (selectedSettings != null && this.myBinder.isSupportedRunConfiguration(selectedSettings.getConfiguration())) {
            selectedTargetAndConfig = this.myBinder.getTargetAndConfiguration((CidrRunConfiguration)selectedSettings.getConfiguration());
            data = helper.findSimilarValidInTargets((CidrBuildTarget)selectedTargetAndConfig.first, (CidrBuildConfiguration)selectedTargetAndConfig.second, targetsWithContext);
        }
        if (data == null) {
            selectedTargetAndConfig = this.myBinder.getTargetAndConfiguration(configuration2);
            data = helper.findSimilarValidInTargets((CidrBuildTarget)selectedTargetAndConfig.first, (CidrBuildConfiguration)selectedTargetAndConfig.second, targetsWithContext);
        }
        if (data != null && data.target != null) {
            target = (CidrBuildTarget)helper.findTarget(data.target, targetsWithContext);
        }
        if (target == null) {
            data = null;
            target = (CidrBuildTarget)targetsWithContext.get(0);
        }
        assert (target != null);
        BuildTargetData buildTargetData = new BuildTargetData(target);
        if (data == null) {
            Object buildConfiguration = ((CidrRunConfiguration)configuration2).getHelper().getDefaultConfiguration(target);
            data = new BuildTargetAndConfigurationData(buildTargetData, buildConfiguration == null ? null : buildConfiguration.getName());
        }
        if (adjustConfigurationFromContext) {
            if (configuration2 instanceof CidrExecutableDataHolder) {
                ((CidrExecutableDataHolder)configuration2).setExecutableData(new ExecutableData(buildTargetData));
            }
            ((CidrRunConfiguration)configuration2).setTargetAndConfigurationData(data);
        }
        return data;
    }
}

