/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.cidr.execution.CidrPathConsoleFilter;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrConsoleBuilder
extends TextConsoleBuilderImpl {
    public CidrConsoleBuilder(@NotNull Project project2, @Nullable CidrToolEnvironment environment, @Nullable Path baseDir) {
        super(project2);
        this.addFilter(new CidrPathConsoleFilter(project2, environment, baseDir));
    }

    @NotNull
    public ConsoleView createConsole(@NotNull ConfigurationType type, @NotNull SMTRunnerConsoleProperties consoleProperties) {
        SMTRunnerConsoleView console = (SMTRunnerConsoleView)SMTestRunnerConnectionUtil.createConsole((String)type.getId(), (TestConsoleProperties)consoleProperties);
        Disposer.register((Disposable)this.getProject(), (Disposable)console);
        Objects.requireNonNull(console.getResultsViewer().getTreeView()).getSelectionModel().setSelectionMode(4);
        return console;
    }
}

