/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.jetbrains.cidr.execution.CidrExecUtil;
import com.jetbrains.cidr.execution.CidrProgramParameters;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CidrCommandLineConfigurator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CidrProgramParameters myAppParameters;

    public CidrCommandLineConfigurator(@NotNull Project project2, @NotNull CidrProgramParameters appParameters) {
        this.myProject = project2;
        this.myAppParameters = appParameters;
    }

    public void configureCommandLine(@NotNull GeneralCommandLine cl) throws ExecutionException {
        Charset charset = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset();
        cl.setCharset(charset);
        cl.setWorkDirectory(CidrProgramParameters.pathToFile(this.myAppParameters.getWorkingDirectory()));
        cl.getParametersList().addAll(this.myAppParameters.getProgramParametersList().getList());
        Map env = cl.getEnvironment();
        env.putAll(this.myAppParameters.getEnv());
        if (SystemInfo.isMac) {
            CidrExecUtil.setIfAbsent((Map)env, (String)"NSUnbufferedIO", (String)"YES");
        }
        cl.withParentEnvironmentType(this.myAppParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        cl.withInput(CidrProgramParameters.pathToFile(this.myAppParameters.getRedirectInputPath()));
    }
}

