/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrBuildConfigurationHelper<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>> {
    @NotNull
    @NlsContexts.Label
    public String getTargetTitle() {
        return CidrExecutionBundle.message("build.configuration.target", new Object[0]);
    }

    @Nls
    @NotNull
    public String getConfigurationTitle() {
        return CidrExecutionBundle.message("build.configuration.configuration", new Object[0]);
    }

    public boolean allowEditBuildConfiguration() {
        return true;
    }

    public boolean hasTargetsInSeveralProjects() {
        return false;
    }

    @NotNull
    public abstract List<TARGET> getTargets();

    @NotNull
    public List<BC> getConfigurations(@Nullable TARGET target) {
        return target == null ? Collections.emptyList() : target.getBuildConfigurations();
    }

    @Nullable
    public BC getDefaultConfiguration(@Nullable TARGET target) {
        return (BC)((CidrBuildConfiguration)ContainerUtil.getFirstItem(this.getConfigurations(target)));
    }

    @NotNull
    public List<? extends TARGET> getRunTargets() {
        return ContainerUtil.filter(this.getTargets(), target -> target.isExecutable());
    }

    @NotNull
    public List<? extends TARGET> getRunTargets(@Nullable TARGET buildTarget) {
        return this.getRunTargets();
    }

    @Nullable
    public TARGET findRunTarget(@Nullable BuildTargetData data) {
        return this.findTarget(data, this.getRunTargets());
    }

    @Nullable
    public TARGET findTarget(@Nullable BuildTargetData targetData) {
        return this.findTarget(targetData, this.getTargets());
    }

    @Contract(value="null, _ -> null")
    public <T extends TARGET> T findTarget(@Nullable BuildTargetData targetData, @NotNull List<T> targets) {
        if (targetData == null) {
            return null;
        }
        for (CidrBuildTarget each : targets) {
            if (!each.pairOf(targetData)) continue;
            return (T)each;
        }
        return null;
    }

    @Nullable
    public BC findConfiguration(@Nullable TARGET target, @Nullable String name) {
        if (name == null) {
            return null;
        }
        for (CidrBuildConfiguration each : this.getConfigurations(target)) {
            if (!each.getName().equals(name)) continue;
            return (BC)each;
        }
        return null;
    }

    @Nullable
    public TARGET getDefaultTarget() {
        return (TARGET)((CidrBuildTarget)ContainerUtil.getFirstItem(this.getTargets()));
    }

    @Nullable
    public TARGET findFirstSuitableTarget(@Nullable String targetName) {
        return CidrBuildConfigurationHelper.findFirstSuitableTarget(this.getTargets(), targetName);
    }

    @NlsContexts.Label
    @NotNull
    public String getExecutableTitle() {
        return CidrExecutionBundle.message("build.configuration.executable", new Object[0]);
    }

    @Contract(value="_, null -> null")
    public static <T extends CidrBuildTarget> T findFirstSuitableTarget(@NotNull List<T> targets, @Nullable String targetName) {
        if (targetName == null) {
            return null;
        }
        for (CidrBuildTarget each : targets) {
            if (!each.getName().equals(targetName)) continue;
            return (T)each;
        }
        return null;
    }

    @Nullable
    public BuildTargetAndConfigurationData findSimilarValidInTargets(@Nullable TARGET target, @Nullable BC configuration2, @NotNull List<TARGET> targetsWithContext) {
        return targetsWithContext.contains(target) ? new BuildTargetAndConfigurationData((CidrBuildTarget<?>)target, (String)null) : null;
    }

    public static boolean isTargetDetectionEnabled() {
        return Registry.is((String)"cidr.test.framework.targetTypeFromHeaderDetectionEnable");
    }

    @TestOnly
    public static boolean setTargetDetection(boolean value) {
        boolean oldValue = CidrBuildConfigurationHelper.isTargetDetectionEnabled();
        Registry.get((String)"cidr.test.framework.targetTypeFromHeaderDetectionEnable").setValue(value);
        return oldValue;
    }

    @NotNull
    public CommonProgramParametersPanel createCommonPanelForTests() {
        return new CommonProgramParametersPanel();
    }
}

