/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestAnnotationInfoList {
    @NotNull
    protected final List<AnnotationInfo> myAnnotationHolder = new ArrayList<AnnotationInfo>();

    private void annotationAdded(@NotNull Annotation annotation) {
        ProblemGroup problemGroup;
        TextRange range = TextRange.create((Segment)annotation);
        HighlightSeverity severity = annotation.getSeverity();
        String message = annotation.getMessage();
        this.annotationAdded(severity, range, message);
        if (annotation.getQuickFixes() != null) {
            for (SuppressIntentionAction[] info : annotation.getQuickFixes()) {
                this.createQuickFix((Segment)range, info.quickFix);
            }
            problemGroup = annotation.getProblemGroup();
            if (problemGroup instanceof OCProblemGroup) {
                for (SuppressIntentionAction action : ((OCProblemGroup)problemGroup).getSuppressActions(null)) {
                    this.createQuickFix((Segment)range, (IntentionAction)action);
                }
            }
        }
        if (annotation.getBatchFixes() != null) {
            for (SuppressIntentionAction[] info : annotation.getBatchFixes()) {
                this.createQuickFix((Segment)range, info.quickFix);
            }
            problemGroup = annotation.getProblemGroup();
            if (problemGroup instanceof OCProblemGroup) {
                for (SuppressIntentionAction action : ((OCProblemGroup)problemGroup).getSuppressActions(null)) {
                    this.createQuickFix((Segment)range, (IntentionAction)action);
                }
            }
        }
    }

    public void annotationAdded(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message) {
        this.myAnnotationHolder.add(new AnnotationInfo(range, severity, message));
    }

    public void annotationsAdded(@NotNull Collection<? extends Annotation> holder) {
        for (Annotation annotation : holder) {
            this.annotationAdded(annotation);
        }
    }

    public boolean exists(@NotNull Predicate<? super AnnotationInfo> predicate) {
        return this.myAnnotationHolder.stream().anyMatch(predicate);
    }

    public abstract void createQuickFix(@Nullable Segment var1, @NotNull IntentionAction var2);

    public static class AnnotationInfo {
        public final TextRange range;
        public final HighlightSeverity severity;
        public final String message;

        AnnotationInfo(@NotNull TextRange range, @NotNull HighlightSeverity severity, @Nullable String message) {
            this.range = range;
            this.severity = severity;
            this.message = message;
        }

        public String toString() {
            return "AnnotationInfo{range=" + this.range + ", severity=" + this.severity + ", message='" + this.message + "'}";
        }
    }
}

