/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.jetbrains.cidr.CidrProjectApplicationVersion;
import com.jetbrains.cidr.EarlyProjectDirListener;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenHelper<T> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ProjectOpenHelper.class);
    private final Key<T> myOpenDataKey;
    private final SupportedFileChecker mySupportedFileChecker;

    public ProjectOpenHelper(@NotNull Key<T> openDataKey, @NotNull SupportedFileChecker supportedFileChecker) {
        this.myOpenDataKey = openDataKey;
        this.mySupportedFileChecker = supportedFileChecker;
    }

    public boolean isSupportedFile(@Nullable VirtualFile file2) {
        return file2 != null && this.mySupportedFileChecker.isSupportedFile(file2);
    }

    @Nullable
    public VirtualFile findSupportedSubFile(@NotNull VirtualFile file2) {
        if (!file2.isDirectory() && this.isSupportedFile(file2)) {
            return file2;
        }
        for (VirtualFile child : file2.getChildren()) {
            if (child == null || child.isDirectory() || !this.isSupportedFile(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getValidProjectPath(@NotNull VirtualFile file2) {
        if (!file2.isDirectory()) {
            file2 = file2.getParent();
        }
        if (ProjectUtil.isValidProjectPath((Path)file2.toNioPath())) {
            return file2;
        }
        return null;
    }

    @Nullable
    private static Pair<Path, OpenProjectTask> createTaskToOpenExistingProjectInDirectory(@NotNull VirtualFile file2, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile projectDir = ProjectOpenHelper.getValidProjectPath(file2);
        if (projectDir == null) {
            return null;
        }
        LOG.info("Opening existing project in directory " + projectDir + " Requested file " + file2);
        Path projectPath = projectDir.toNioPath();
        OpenProjectTask openProjectTask = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists((Path)projectPath, (Project)projectToClose).withForceOpenInNewFrame(forceOpenInNewFrame);
        return new Pair((Object)projectPath, (Object)openProjectTask);
    }

    @Nullable
    public Project openExistingProjectInDirectory(@NotNull VirtualFile file2, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Pair<Path, OpenProjectTask> task = ProjectOpenHelper.createTaskToOpenExistingProjectInDirectory(file2, projectToClose, forceOpenInNewFrame);
        if (task == null) {
            return null;
        }
        return ProjectManagerEx.getInstanceEx().openProject((Path)task.first, (OpenProjectTask)task.second);
    }

    @Nullable
    public @Nullable CompletableFuture<@Nullable Project> openExistingProjectInDirectoryAsync(@NotNull VirtualFile file2, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Pair<Path, OpenProjectTask> task = ProjectOpenHelper.createTaskToOpenExistingProjectInDirectory(file2, projectToClose, forceOpenInNewFrame);
        if (task == null) {
            return null;
        }
        return ProjectManagerEx.getInstanceEx().openProjectAsync((Path)task.first, (OpenProjectTask)task.second);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data) {
        return this.openProject(virtualFile, projectToClose, forceOpenInNewFrame, data, project2 -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data, Predicate<Project> callback) {
        if (!this.isSupportedFile(virtualFile)) {
            return null;
        }
        this.markFileToOpen(virtualFile, data);
        VirtualFile baseDir = virtualFile.getParent();
        OpenProjectTask options = PlatformProjectOpenProcessor.createOptionsToOpenDotIdeaOrCreateNewIfNotExists((Path)baseDir.toNioPath(), (Project)projectToClose).withForceOpenInNewFrame(forceOpenInNewFrame).withBeforeOpenCallback(ProjectOpenHelper.beforeOpenCallback(callback));
        EarlyProjectDirListener dirListener = (EarlyProjectDirListener)ApplicationManager.getApplication().getService(EarlyProjectDirListener.class);
        if (dirListener != null) {
            dirListener.setBaseDir(baseDir.getCanonicalPath());
        }
        try {
            Project project2 = ProjectManagerEx.getInstanceEx().openProject(baseDir.toNioPath(), options);
            return project2;
        }
        finally {
            if (dirListener != null) {
                dirListener.setBaseDir(null);
            }
        }
    }

    public @NotNull CompletableFuture<@Nullable Project> openProjectAsync(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data) {
        return this.openProjectAsync(virtualFile, projectToClose, forceOpenInNewFrame, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NotNull CompletableFuture<@Nullable Project> openProjectAsync(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame, T data, @Nullable Predicate<Project> runBeforeOpenCallback) {
        if (!this.isSupportedFile(virtualFile)) {
            return CompletableFuture.completedFuture(null);
        }
        this.markFileToOpen(virtualFile, data);
        VirtualFile baseDir = virtualFile.getParent();
        OpenProjectTask options = OpenProjectTask.build().withProjectToClose(projectToClose).withForceOpenInNewFrame(forceOpenInNewFrame).withRunConfigurators().withBeforeOpenCallback(ProjectOpenHelper.beforeOpenCallback(runBeforeOpenCallback));
        EarlyProjectDirListener dirListener = (EarlyProjectDirListener)ApplicationManager.getApplication().getService(EarlyProjectDirListener.class);
        if (dirListener != null) {
            dirListener.setBaseDir(baseDir.getCanonicalPath());
        }
        try {
            CompletableFuture completableFuture = ProjectManagerEx.getInstanceEx().openProjectAsync(baseDir.toNioPath(), options);
            return completableFuture;
        }
        finally {
            if (dirListener != null) {
                dirListener.setBaseDir(null);
            }
        }
    }

    public void linkToExistingProject(@NotNull Project project2, @NotNull T data) {
        VirtualFile baseDir = project2.getBaseDir();
        baseDir.putUserData(this.myOpenDataKey, data);
    }

    @NotNull
    private static Predicate<Project> beforeOpenCallback(@Nullable Predicate<Project> userCallback) {
        return project2 -> {
            CidrProjectApplicationVersion.getInstance(project2).initializeApplicationInfo();
            if (userCallback != null) {
                return userCallback.test((Project)project2);
            }
            return true;
        };
    }

    public void markFileToOpen(@NotNull VirtualFile virtualFile, @NotNull T data) {
        VirtualFile baseDir = virtualFile.getParent();
        baseDir.putUserData(this.myOpenDataKey, data);
    }

    @Nullable
    public T getAndClearFileToOpenData(@NotNull Project project2) {
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir == null) {
            return null;
        }
        Object data = baseDir.getUserData(this.myOpenDataKey);
        baseDir.putUserData(this.myOpenDataKey, null);
        return (T)data;
    }

    public static interface SupportedFileChecker {
        public boolean isSupportedFile(@NotNull VirtualFile var1);
    }
}

