/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.ProjectOpenHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenFileHelper<T>
extends ProjectOpenHelper<T> {
    @NotNull
    private final @NotNull List<@NotNull String> myFileNames;

    public ProjectOpenFileHelper(@NotNull @NotNull List<@NotNull String> fileNames, @NotNull Key<T> openDataKey) {
        super(openDataKey, new Checker(fileNames));
        this.myFileNames = fileNames;
    }

    @Override
    @Nullable
    public VirtualFile findSupportedSubFile(@NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            for (String each : this.myFileNames) {
                VirtualFile supportedFile = file2.findChild(each);
                if (supportedFile == null) continue;
                return supportedFile;
            }
            return null;
        }
        return this.isSupportedFile(file2) ? file2 : null;
    }

    private static class Checker
    implements ProjectOpenHelper.SupportedFileChecker {
        @NotNull
        private final @NotNull List<@NotNull String> myFileNames;

        Checker(@NotNull List<String> fileNames) {
            this.myFileNames = fileNames;
        }

        @Override
        public boolean isSupportedFile(@NotNull VirtualFile file2) {
            return this.isSupportedFile(file2.getName()) && file2.exists() && !file2.isDirectory();
        }

        private boolean isSupportedFile(@NotNull String fileName) {
            for (String each : this.myFileNames) {
                if (!FileUtil.namesEqual((String)each, (String)fileName)) continue;
                return true;
            }
            return false;
        }
    }
}

