/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.IoTestUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.cidr.CidrPathManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestDataFixture {
    public static final String REAL_PROJECT_DIR_SUFFIX = "-real";
    private final Set<File> myTempFiles = new HashSet<File>();
    protected boolean myCreateSymLinkedProject;
    private final File myTestDataDir;
    public static final Pattern IDEA_DIR_NAME_PATTERN = Pattern.compile("^" + Pattern.quote(".idea") + "$");

    public CidrTestDataFixture(File testDataDir) {
        this(testDataDir, false);
    }

    public CidrTestDataFixture(File testDataDir, boolean createSymlinkedProject) {
        this.myTestDataDir = testDataDir;
        this.myCreateSymLinkedProject = createSymlinkedProject;
    }

    @NotNull
    public static File getRegressionTestData() {
        return CidrPathManager.getCidrSourcesRoot().resolve("regression-testData").toFile();
    }

    @NotNull
    public static File getCommonTestData() {
        return CidrPathManager.getCidrSourcesRoot().resolve("cidr-common/tests/testData").toFile();
    }

    @NotNull
    public static File getLangTestData() {
        return CidrPathManager.getCidrSourcesRoot().resolve("cidr-lang/testData").toFile();
    }

    @NotNull
    public static File getDebuggerTestData() {
        return CidrPathManager.getCidrSourcesRoot().resolve("cidr-debugger/testData").toFile();
    }

    @NotNull
    public static File getCoverageTestData() {
        return CidrPathManager.getCidrSourcesRoot().resolve("cidr-coverage/testData").toFile();
    }

    @NotNull
    public static File getCLionTestData() {
        return CidrPathManager.getCidrSourcesRoot().resolve("clion/main/testData").toFile();
    }

    @NotNull
    public static File getCompDBTestData() {
        return CidrPathManager.getCidrSourcesRoot().resolve("clion-compdb/testData").toFile();
    }

    @NotNull
    public static File getAppCodeTestData() {
        return new File(PathManager.getHomePath(), "CIDR-appcode/appcode/main/testData");
    }

    public static File getCocoaCommonTestData() {
        return new File(PathManager.getHomePath(), "CIDR-appcode/cocoa-common/testData");
    }

    public static File getSwiftTestData() {
        return new File(PathManager.getHomePath(), "CIDR-appcode/swift-tests/testData");
    }

    public static File getMobileTestData() {
        return new File(PathManager.getHomePath(), "mobile-ide/mobile-native/testData");
    }

    @NotNull
    public static File getSwiftPackageManagerTestData() {
        return new File(PathManager.getHomePath(), "CIDR-appcode/swift-package-manager/testData");
    }

    public void enableSymlinkedProjectCreation() {
        this.myCreateSymLinkedProject = true;
    }

    public boolean isSymlinked() {
        return this.myCreateSymLinkedProject;
    }

    @NotNull
    public File getTestDataDir() {
        if (this.myTestDataDir == null) {
            throw new UnsupportedOperationException("No test data. Please override CidrTestCase.createTestDataFixture");
        }
        return this.myTestDataDir;
    }

    @NotNull
    public File getTestDataProjectsDir() {
        return this.getTestDataFile("projects");
    }

    @Contract(value="null -> null")
    public File getTestDataProjectsFile(@Nullable String testDataRelativePath) {
        return testDataRelativePath == null ? null : new File(this.getTestDataProjectsDir(), testDataRelativePath);
    }

    @Contract(value="null -> null")
    public File getTestDataFile(@Nullable String testDataRelativePath) {
        return testDataRelativePath == null ? null : new File(this.getTestDataDir(), testDataRelativePath);
    }

    public VirtualFile createTempDir() {
        return CidrTestDataFixture.getVirtualFile(this.createTempIODir());
    }

    public Path createTempPath() {
        return this.createTempIODir().toPath();
    }

    public File createTempIODir() {
        return this.createTempIODir(true);
    }

    public File createTempIODir(boolean deleteOnTearDown) {
        try {
            File result = FileUtil.createTempDirectory((String)"cidr_test_", null, (boolean)false).getCanonicalFile();
            if (deleteOnTearDown) {
                this.myTempFiles.add(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void tearDown() {
        for (File each : this.myTempFiles) {
            FileUtil.delete((File)each);
        }
    }

    public VirtualFile createTempFile() {
        return this.createTempFile("");
    }

    public VirtualFile createTempFile(@NotNull String content) {
        return CidrTestDataFixture.prepareFile(this.createTempIOFile(), content);
    }

    public VirtualFile createTempFile(@NotNull String content, @NotNull String suffix) {
        return CidrTestDataFixture.prepareFile(this.createTempIOFile(suffix), content);
    }

    private static VirtualFile prepareFile(@NotNull File f, @NotNull String content) {
        try {
            FileUtil.writeToFile((File)f, (byte[])content.getBytes(Charset.defaultCharset()));
            return CidrTestDataFixture.getVirtualFile(f);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static VirtualFile getVirtualFile(@NotNull File f) {
        VirtualFile result = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(f);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{result});
        return result;
    }

    public File createTempIOFile() {
        return this.createTempIOFile("");
    }

    public File createTempIOFile(@NotNull String suffix) {
        return this.createTempIOFile("cidr_test_file_", suffix);
    }

    public File createTempIOFile(@NotNull String prefix, @NotNull String suffix) {
        File f;
        try {
            f = FileUtil.createTempFile((String)prefix, (String)suffix, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((boolean)f.exists());
        this.myTempFiles.add(f);
        return f;
    }

    public VirtualFile createFile(@NotNull VirtualFile dir, @NotNull String name, @NotNull String content) {
        try {
            return (VirtualFile)WriteAction.computeAndWait(() -> {
                VirtualFile file2 = dir.findChild(name);
                if (file2 == null) {
                    file2 = dir.createChildData((Object)this, name);
                }
                file2.setBinaryContent(content.getBytes(Charset.defaultCharset()));
                return file2;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateFileText(@NotNull VirtualFile file2, @NotNull String append) throws IOException {
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)(VfsUtilCore.loadText((VirtualFile)file2) + append)));
    }

    public void writeFileTextExternally(@NotNull VirtualFile file2, @NotNull String text) throws IOException {
        this.writeIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file2), text);
        file2.refresh(false, false);
    }

    public void updateFileTextExternally(@NotNull VirtualFile file2, @NotNull String append) throws IOException {
        this.updateIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file2), append);
        file2.refresh(false, false);
    }

    public void writeIOFileText(@NotNull File file2, @NotNull String text) throws IOException {
        FileUtil.writeToFile((File)file2, (String)text);
        this.updateFileTimestamp(file2);
    }

    public void updateIOFileText(@NotNull File file2, @NotNull String append) throws IOException {
        this.writeIOFileText(file2, FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8) + append);
    }

    public void updateFileText(@NotNull VirtualFile file2, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        String original = VfsUtilCore.loadText((VirtualFile)file2);
        String replaced = original.replace(replaceString, replaceWith);
        TestCase.assertFalse((String)(replaceString + " not found in \n" + original), (boolean)original.equals(replaced));
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)replaced));
    }

    public void updateFileTextExternally(@NotNull VirtualFile file2, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        this.updateIOFileText(VfsUtilCore.virtualToIoFile((VirtualFile)file2), replaceString, replaceWith);
        file2.refresh(false, false);
    }

    public void updateIOFileText(@NotNull File file2, @NotNull String replaceString, @NotNull String replaceWith) throws IOException {
        String original = FileUtil.loadFile((File)file2, (String)"UTF-8", (boolean)true);
        String replaced = original.replace(replaceString, replaceWith);
        TestCase.assertFalse((String)(replaceString + " not found in \n" + original), (boolean)original.equals(replaced));
        FileUtil.writeToFile((File)file2, (String)replaced);
        this.updateFileTimestamp(file2);
    }

    public void updateFileTimestamp(File ... files) {
        for (File file2 : files) {
            TestCase.assertTrue((boolean)file2.setLastModified(file2.lastModified() + 3000L));
        }
    }

    public void updateFileRegexpText(@NotNull VirtualFile file2, @NotNull @RegExp String regexp, @NotNull String replaceWith) throws IOException {
        this.updateFileRegexpText(file2, regexp, replaceWith, true);
    }

    public void updateFileRegexpText(@NotNull VirtualFile file2, @NotNull @RegExp String regexp, @NotNull String replaceWith, boolean failIfNotFound) throws IOException {
        String original = VfsUtilCore.loadText((VirtualFile)file2);
        String replaced = CidrTestDataFixture.replaceFirstDotAll(original, regexp, replaceWith, failIfNotFound);
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file2, (String)replaced));
    }

    public void updateIOFileRegexpText(@NotNull File file2, @NotNull @RegExp String regexp, @NotNull String replaceWith) throws IOException {
        String original = FileUtil.loadFile((File)file2, (Charset)StandardCharsets.UTF_8);
        String replaced = CidrTestDataFixture.replaceFirstDotAll(original, regexp, replaceWith, true);
        FileUtil.writeToFile((File)file2, (String)replaced);
        this.updateFileTimestamp(file2);
    }

    private static String replaceFirstDotAll(String original, @RegExp String regexp, String replaceWith, boolean failIfNotFound) {
        Pattern pattern = Pattern.compile(regexp, 32);
        if (failIfNotFound) {
            Assert.assertTrue((String)(regexp + " not found in \n" + original), (boolean)pattern.matcher(original).find());
        }
        return pattern.matcher(original).replaceFirst(replaceWith);
    }

    @NotNull
    public List<File> collectDirectSubDirs(@NotNull File dir) {
        return CidrTestDataFixture.collectSubDirs(dir, true, new ArrayList<File>());
    }

    @NotNull
    public List<File> collectSubDirs(@NotNull File dir) {
        return CidrTestDataFixture.collectSubDirs(dir, false, new ArrayList<File>());
    }

    @NotNull
    private static List<File> collectSubDirs(@NotNull File dir, boolean direct, @NotNull List<File> result) {
        File[] subFiles = dir.listFiles();
        if (subFiles != null) {
            for (File eachSubFile : subFiles) {
                if (!eachSubFile.isDirectory()) continue;
                result.add(eachSubFile);
                if (direct) continue;
                CidrTestDataFixture.collectSubDirs(eachSubFile, false, result);
            }
        }
        return result;
    }

    public File copyTestData(@NotNull File folderOrZipToCopy, @NotNull File toDir) {
        File dir = toDir;
        String action = null;
        try {
            if (folderOrZipToCopy.isFile() && FileUtilRt.extensionEquals((String)folderOrZipToCopy.getName(), (String)"zip")) {
                action = "extract";
                ZipUtil.extract((File)folderOrZipToCopy, (File)toDir, null);
            } else {
                action = "copy";
                dir = new File(toDir, folderOrZipToCopy.getName());
                FileUtil.copyDir((File)folderOrZipToCopy, (File)dir);
            }
            List ideaDirs = FileUtil.findFilesOrDirsByMask((Pattern)IDEA_DIR_NAME_PATTERN, (File)dir);
            for (File ideaDir : ideaDirs) {
                if (!ideaDir.isDirectory()) continue;
                System.out.println("WARN: '.idea' found in test project and will be deleted during copy: " + ideaDir.getPath());
                FileUtil.delete((File)ideaDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't " + action + " test data from " + folderOrZipToCopy + " to " + toDir, e);
        }
        File projectDir = new File(toDir, folderOrZipToCopy.getName());
        if (this.myCreateSymLinkedProject) {
            File realDir = this.getRealFolder(projectDir);
            FileUtil.moveDirWithContent((File)projectDir, (File)realDir);
            this.createSymlink(realDir, projectDir.getName());
        }
        return projectDir;
    }

    @NotNull
    protected File getRealFolder(File projectDir) {
        return new File(projectDir.getPath() + REAL_PROJECT_DIR_SUFFIX);
    }

    @NotNull
    public File createSymlink(@NotNull File target) {
        return this.createSymlink(target, target.getName() + "-symlink");
    }

    @NotNull
    public File createSymlink(@NotNull File target, @NotNull String name) {
        return this.createSymlink(target, new File(target.getParentFile(), name));
    }

    @NotNull
    public File createSymlink(@NotNull File target, @NotNull File symlink) {
        TestCase.assertFalse((boolean)symlink.exists());
        try {
            IoTestUtil.createSymLink((String)target.getAbsolutePath(), (String)symlink.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create symlink", e);
        }
        Assert.assertTrue((boolean)symlink.exists());
        return symlink;
    }
}

