/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.OCGeneratedSourcesFilter;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceImpl;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class CidrProjectFixture<BUILD_CONFIGURATION_TYPE>
extends Assert
implements CidrProjectDependentFixture {
    private static final Logger LOG = Logger.getInstance((String)("#" + CidrProjectFixture.class.getPackage().getName()));
    private static final Key<Set<String>> BUILT_CONFIGURATIONS = Key.create((String)"BUILT_CONFIGURATIONS");
    private SdkLeakTracker myOldSdks;
    @NotNull
    protected final CidrTestDataFixture myTestDataFixture;
    private CleanProjectOption myCleanProjectOption = CleanProjectOption.DO_NOT_CLEAN;
    private boolean myLoadSymbols = true;
    private boolean mySaveSymbols = true;
    private static volatile Runnable ourProjectCleanup;
    private static volatile boolean ourRunningFixture;
    private static volatile ProjectInfo ourProjectInfo;
    private static volatile ThrowableConsumer<Project, Throwable> ourCloseProjectRunnable;
    private static final List<ThrowableRunnable<Throwable>> ourAdditionalProjectCleanUpRunnableList;
    private static final Map<ProjectTestData, ProjectTiming> ourProjectTimingMap;
    private static volatile VirtualFile ourTestRoot;
    private static volatile VirtualFile ourProjectDir;
    private static volatile VirtualFile ourProjectFile;
    private static volatile Project ourProject;
    private static volatile FileSymbolTablesCache.SymbolsProperties.SymbolsKind ourSymbolsWereBuilt;
    private static volatile boolean ourTestFilesChanged;
    private static volatile BulkFileListener ourTestFilesListener;
    private static volatile VirtualFilePointerTracker ourVirtualFilePointerTracker;
    private boolean myInitProjectHasBeenCalled = false;
    private boolean myOpenProjectHasBeenCalledOnce = false;
    private Disposable myProjectDisposable;
    private String myCurrentTestClassFQN;
    protected String myCurrentTestName;
    private final LinkedHashMap<CidrProjectDependentFixture, String> myDependentFixtures = new LinkedHashMap();
    public static final int NOT_IN_SCOPE = 0;
    public static final int IN_PROJECT = 1;
    public static final int IN_CONTENT = 3;
    public static final int IN_CONTENT_SOURCES = 4;
    public static final int IN_LIBRARIES = 8;
    public static final int IN_CONTENT_SOURCES_GENERATED = 16;

    public CidrProjectFixture(@NotNull CidrTestDataFixture testDataFixture) {
        this.myTestDataFixture = testDataFixture;
    }

    public void setCleanProjectOption(@NotNull CleanProjectOption option) {
        this.myCleanProjectOption = option;
    }

    public void setupSerialization(boolean loadSymbols, boolean saveSymbols) {
        this.myLoadSymbols = loadSymbols;
        this.mySaveSymbols = saveSymbols;
    }

    public void setUp(@NotNull String testClassFQN, @NotNull String testName) throws Exception {
        ourRunningFixture = true;
        try {
            this.myProjectDisposable = Disposer.newDisposable();
            FileSymbolTablesCache.setShouldBuildTablesInTests(null);
            this.myCurrentTestClassFQN = testClassFQN;
            this.myCurrentTestName = testName;
            this.myDependentFixtures.remove(this);
            if (!this.myDependentFixtures.isEmpty()) {
                LOG.warn("some of dependent fixtures were not removed by previous test: ");
                for (Map.Entry<CidrProjectDependentFixture, String> entry : this.myDependentFixtures.entrySet()) {
                    LOG.warn("  " + entry.getValue() + " => " + entry.getKey());
                }
                this.myDependentFixtures.clear();
            }
            this.addProjectDependentFixture(this);
            this.myOldSdks = new SdkLeakTracker();
        }
        catch (Exception e) {
            ourRunningFixture = false;
            throw e;
        }
    }

    public void tearDown() throws Exception {
        ourRunningFixture = false;
        Disposer.dispose((Disposable)this.myProjectDisposable);
        if (this.myCleanProjectOption == CleanProjectOption.CLEAN_EACH_TIME) {
            this.closeProjectAndCleanup();
        }
        FileSymbolTablesCache.setShouldBuildTablesInTests(null);
        WriteAction.runAndWait(() -> ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).dropAllUnsavedDocuments());
    }

    public void collectAllowedRoots(@NotNull List<? super String> result) {
    }

    public void addProjectDependentFixture(@NotNull CidrProjectDependentFixture fixture) throws Exception {
        CidrProjectFixture.assertNull((String)"dependent fixture already registered", (Object)this.myDependentFixtures.put(fixture, this.myCurrentTestName));
        if (this.myInitProjectHasBeenCalled && ourProject != null) {
            fixture.afterProjectOpened();
        }
    }

    public void removeProjectDependentFixture(@NotNull CidrProjectDependentFixture fixture) throws Exception {
        if (this.myInitProjectHasBeenCalled && ourProject != null) {
            fixture.beforeProjectClosed();
        }
        CidrProjectFixture.assertNotNull((String)("dependent fixture not found: " + fixture), this.myDependentFixtures.remove(fixture));
    }

    private static <R extends OCResolveConfiguration, B> void notifyDependentFixtures(boolean notifyOpen, @Nullable CidrProjectFixture<B> holder) throws Exception {
        if (ourProject != null && holder != null && holder.myInitProjectHasBeenCalled) {
            for (CidrProjectDependentFixture each : holder.myDependentFixtures.keySet()) {
                if (notifyOpen) {
                    each.afterProjectOpened();
                    continue;
                }
                each.beforeProjectClosed();
            }
        }
    }

    private FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTablesForFixtures() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind result = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
        for (CidrProjectDependentFixture each : this.myDependentFixtures.keySet()) {
            FileSymbolTablesCache.SymbolsProperties.SymbolsKind eachResult = each.shouldBuildSymbolTables();
            if (result.compareTo((Enum)eachResult) >= 0) continue;
            result = eachResult;
        }
        return result;
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        return FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
    }

    public void initProject(@NotNull String relativeProjectPath) throws Exception {
        this.initProject(relativeProjectPath, null, true);
    }

    public void initProject(@NotNull String relativeProjectPath, @Nullable String relativeFilesToCopyPath, boolean openProject) throws Exception {
        this.initProject(new CidrTestProjectDescription(relativeProjectPath, relativeFilesToCopyPath, openProject));
    }

    public void initProject(@NotNull CidrTestProjectDescription projectDescription) throws Exception {
        this.initProject(projectDescription, this.shouldBuildSymbolTablesForFixtures());
    }

    public void initProject(@NotNull CidrTestProjectDescription projectDescription, FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables) throws Exception {
        ProjectInfo info = this.getProjectInfo(projectDescription.getRelativeProjectPath(), projectDescription.getRelativeFolderToCopy());
        boolean shouldReinitialize = false;
        if (ourTestFilesChanged || ourProject == null || !ourProjectInfo.equals(info) || ourSymbolsWereBuilt.compareTo((Enum)buildSymbolTables) < 0 || this.projectChangedSomehow(ourProject)) {
            this.closeProjectAndCleanup();
            shouldReinitialize = true;
        }
        boolean wasAlreadyInitialized = this.myInitProjectHasBeenCalled;
        this.myInitProjectHasBeenCalled = true;
        this.myOpenProjectHasBeenCalledOnce = false;
        FileSymbolTablesCache.setShouldBuildTablesInTests((FileSymbolTablesCache.SymbolsProperties)new FileSymbolTablesCache.SymbolsProperties(buildSymbolTables, this.myLoadSymbols, this.mySaveSymbols));
        if (!shouldReinitialize) {
            if (projectDescription.getOpenProject()) {
                if (!wasAlreadyInitialized) {
                    CidrProjectFixture.notifyDependentFixtures(true, this);
                }
                if (AllowedModules.Companion.isRebuildRequired()) {
                    OCSymbolTablesBuildingActivity.getInstance((Project)this.getProject()).rebuildSymbols();
                }
            } else {
                this.closeProject();
            }
            return;
        }
        ourProjectInfo = info;
        ourSymbolsWereBuilt = buildSymbolTables;
        if (ourProjectCleanup == null) {
            ourProjectCleanup = () -> {
                CidrProjectFixture.closeProject(null, true);
                CidrProjectFixture.logProjectTimings();
            };
            PlatformTestUtil.registerProjectCleanup((Runnable)ourProjectCleanup);
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectOpened(@NotNull Project project2) {
                    if (!ourRunningFixture) {
                        CidrProjectFixture.this.closeProjectAndCleanup();
                    }
                }
            });
        }
        ourCloseProjectRunnable = this.getCloseProjectRunnable();
        this.addProjectCleanUpRunnables(ourAdditionalProjectCleanUpRunnableList);
        try {
            CidrProjectFixture.measureTiming("Copy Test Data", () -> WriteAction.runAndWait(() -> {
                File root = this.myTestDataFixture.createTempIODir(false);
                FileUtil.delete((File)root);
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(root);
                File adjustedProjectDir = new File(root, info.adjustedRelativePathToCopy);
                File copyDestination = adjustedProjectDir.getParentFile();
                File projectDir = this.myTestDataFixture.copyTestData(info.testData.dirToCopy, copyDestination);
                if (!projectDir.getCanonicalPath().equals(adjustedProjectDir.getCanonicalPath())) {
                    ourProjectFile = ourProjectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectDir);
                } else {
                    this.afterTestDataCopied(copyDestination, adjustedProjectDir);
                    ourTestRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(root);
                    CidrProjectFixture.assertNotNull((String)("Test root not found: " + root), (Object)ourTestRoot);
                    ourProjectDir = ourTestRoot.findFileByRelativePath(info.adjustedRelativeProjectPath);
                    ourProjectFile = ourTestRoot.findFileByRelativePath(projectDescription.getRelativeProjectPath());
                    CidrProjectFixture.assertNotNull((String)("Project dir not found at " + ourTestRoot + "/" + info.adjustedRelativeProjectPath), (Object)ourProjectDir);
                    CidrProjectFixture.assertNotNull((String)("Project file not found at " + ourTestRoot + "/" + projectDescription.getRelativeProjectPath()), (Object)ourProjectFile);
                }
                if (this.myTestDataFixture.isSymlinked()) {
                    VirtualFile each;
                    for (each = ourProjectDir; each != null && !ourTestRoot.equals(each) && !each.is(VFileProperty.SYMLINK); each = each.getParent()) {
                    }
                    if (ourTestRoot.equals(each)) {
                        CidrProjectFixture.fail((String)"Project path should point at a symlink");
                    }
                }
                CidrProjectFixture.initTestFilesListener();
            }));
        }
        catch (Throwable e) {
            this.closeProjectAndCleanup();
            ExceptionUtil.rethrow((Throwable)e);
        }
        if (projectDescription.getOpenProject()) {
            this.openProject();
        }
    }

    public boolean isProjectAlreadyOpened(@NotNull String relativeProjectPath, @Nullable String relativeFolderToCopy) {
        return this.getProjectInfo(relativeProjectPath, relativeFolderToCopy).equals(ourProjectInfo);
    }

    @NotNull
    private ProjectInfo getProjectInfo(@NotNull String relativeProjectPath, @Nullable String relativeFolderToCopy) {
        ProjectInfo info = new ProjectInfo();
        info.adjustedRelativeProjectPath = FileUtil.toSystemIndependentName((String)this.getAdjustedProjectDir(relativeProjectPath));
        info.adjustedRelativePathToCopy = relativeFolderToCopy == null ? info.adjustedRelativeProjectPath : relativeFolderToCopy;
        info.testData.adjustedProjectDir = this.myTestDataFixture.getTestDataProjectsFile(info.adjustedRelativeProjectPath);
        info.testData.projectDir = this.myTestDataFixture.getTestDataProjectsFile(relativeProjectPath);
        info.testData.dirToCopy = this.myTestDataFixture.getTestDataProjectsFile(info.adjustedRelativePathToCopy);
        info.testDataFixtureClass = this.myTestDataFixture.getClass();
        info.isSymlinked = this.myTestDataFixture.isSymlinked();
        switch (this.myCleanProjectOption) {
            case DO_NOT_CLEAN: {
                info.cleanKey = null;
                break;
            }
            case CLEAN_EACH_TIME: {
                info.cleanKey = new Object();
                break;
            }
            case CLEAN_FOR_TESTCASE: {
                info.cleanKey = this.myCurrentTestClassFQN;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void measureTiming(@NotNull String step, ThrowableRunnable<T> runnable) throws T {
        long before = System.currentTimeMillis();
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            long time = System.currentTimeMillis() - before;
            ProjectTiming timing = ourProjectTimingMap.computeIfAbsent(CidrProjectFixture.ourProjectInfo.testData, info -> new ProjectTiming());
            ProjectTiming.Step stepTiming = timing.steps.computeIfAbsent(step, s -> new ProjectTiming.Step());
            if (stepTiming.first == -1L) {
                stepTiming.first = stepTiming.total = time;
            } else {
                stepTiming.total += time;
            }
            ++stepTiming.performedTimes;
            throw throwable;
        }
        long time = System.currentTimeMillis() - before;
        ProjectTiming timing = ourProjectTimingMap.computeIfAbsent(CidrProjectFixture.ourProjectInfo.testData, info -> new ProjectTiming());
        ProjectTiming.Step stepTiming = timing.steps.computeIfAbsent(step, s -> new ProjectTiming.Step());
        if (stepTiming.first == -1L) {
            stepTiming.first = stepTiming.total = time;
        } else {
            stepTiming.total += time;
        }
        ++stepTiming.performedTimes;
    }

    private static void logProjectTimings() {
        OCBuildingActivityProgressIndicator.logStats((Logger)LOG);
        StringBuilder s = new StringBuilder();
        s.append("Unique project uses: ").append(ourProjectTimingMap.size()).append("\n");
        LinkedHashMap<String, ProjectTiming.Step> totalStepTimings = new LinkedHashMap<String, ProjectTiming.Step>();
        LinkedHashMap<String, List> stepSortedProjects = new LinkedHashMap<String, List>();
        for (Map.Entry<ProjectTestData, ProjectTiming> entry : ourProjectTimingMap.entrySet()) {
            int maxStepTimes = 0;
            for (Map.Entry<String, ProjectTiming.Step> eachStep : entry.getValue().steps.entrySet()) {
                ProjectTiming.Step stepTiming = eachStep.getValue();
                ProjectTiming.Step total = totalStepTimings.computeIfAbsent(eachStep.getKey(), __ -> new ProjectTiming.Step());
                total.first += stepTiming.first;
                total.total += stepTiming.total;
                if (stepTiming.performedTimes > 1) {
                    total.performedTimes += stepTiming.performedTimes;
                }
                maxStepTimes = Math.max(maxStepTimes, stepTiming.performedTimes);
                List sortedProjects = stepSortedProjects.computeIfAbsent(eachStep.getKey(), __ -> new SortedList((o1, o2) -> Comparing.compare((long)((ProjectTiming.Step)o2.second).total, (long)((ProjectTiming.Step)o1.second).total)));
                sortedProjects.add(Pair.create((Object)entry.getKey(), (Object)eachStep.getValue()));
            }
        }
        for (Map.Entry<ProjectTestData, ProjectTiming> entry : totalStepTimings.entrySet()) {
            int topProjects = 10;
            s.append("Projects ").append((String)((Object)entry.getKey())).append("\n").append("\tfirst time: ").append(StringUtil.formatDuration((long)((ProjectTiming.Step)((Object)entry.getValue())).first)).append("\n").append("\ttotal time: ").append(StringUtil.formatDuration((long)((ProjectTiming.Step)((Object)entry.getValue())).total)).append("\n").append("\tNumber of extra times called: ").append(((ProjectTiming.Step)((Object)entry.getValue())).performedTimes).append("\n").append("\tTop ").append(topProjects).append(" project repeatedly used: \n");
            for (Pair topProject : ContainerUtil.getFirstItems((List)((List)stepSortedProjects.get(entry.getKey())), (int)topProjects)) {
                s.append("\t\tTotal time: ").append(StringUtil.formatDuration((long)((ProjectTiming.Step)topProject.second).total)).append(", called ").append(((ProjectTiming.Step)topProject.second).performedTimes).append(" times: ").append(((ProjectTestData)topProject.first).projectDir).append("\n");
            }
        }
        LOG.info(s.toString());
    }

    @NotNull
    protected String getAdjustedProjectDir(@NotNull String relativeProjectFilePath) {
        return relativeProjectFilePath;
    }

    protected boolean projectChangedSomehow(@NotNull Project project2) {
        return false;
    }

    private static void initTestFilesListener() {
        if (ourTestFilesListener != null) {
            return;
        }
        MessageBus bus = ApplicationManager.getApplication().getMessageBus();
        ourTestFilesListener = new BulkFileListener(){

            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                this.after(events);
            }

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (ourProjectInfo == null) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    if (!FileUtil.isAncestor((File)CidrProjectFixture.ourProjectInfo.testData.dirToCopy, (File)new File(vFileEvent.getPath()), (boolean)true)) continue;
                    ourTestFilesChanged = true;
                    return;
                }
            }
        };
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)ourTestFilesListener);
    }

    public void closeProjectAndCleanup() {
        CidrProjectFixture.closeProject(this, true);
    }

    public final void openProject() throws Exception {
        this.openProject(false);
    }

    public final void openProject(boolean forceOpenAsExistingDotIdeaProject) throws Exception {
        this.openProject(forceOpenAsExistingDotIdeaProject ? OpenProjectKind.AS_DOT_IDEA : OpenProjectKind.AS_SPECIFIED_FILE);
    }

    public final void openProject(OpenProjectKind openProjectKind) throws Exception {
        this.checkInitProjectCalled();
        CidrProjectFixture.assertNull((String)"Project is already open; close it before opening another one.", (Object)ourProject);
        List<Project> before = Arrays.asList(ProjectManager.getInstance().getOpenProjects());
        try {
            Ref project2 = new Ref();
            ThrowableRunnable openingRunnable = () -> {
                if (openProjectKind == OpenProjectKind.AS_DOT_IDEA) {
                    project2.set((Object)PlatformProjectOpenProcessor.getInstance().doOpenProject(ourProjectDir, null, true));
                } else if (openProjectKind == OpenProjectKind.AS_RECENT) {
                    project2.set((Object)((Project)RecentProjectsManagerBase.getInstanceEx().openProject(Path.of(ourProjectDir.getPath(), new String[0]), new OpenProjectTask()).join()));
                } else if (openProjectKind == OpenProjectKind.AS_DIRECTORY) {
                    project2.set((Object)ProjectUtil.openOrImport((String)ourProjectDir.getPath(), null, (boolean)true));
                } else {
                    project2.set((Object)this.doOpenProject(ourProjectFile));
                }
            };
            if (this.myOpenProjectHasBeenCalledOnce) {
                openingRunnable.run();
            } else {
                this.myOpenProjectHasBeenCalledOnce = true;
                CidrProjectFixture.measureTiming("Opening", openingRunnable);
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    CidrProjectFixture.setProject(this, (Project)project2.get());
                }
                catch (Exception e) {
                    ExceptionUtil.rethrow((Throwable)e);
                }
                ourVirtualFilePointerTracker = new VirtualFilePointerTracker();
            });
        }
        catch (Exception e) {
            if (ourProject == null) {
                ArrayList<Project> after = new ArrayList<Project>(Arrays.asList(ProjectManager.getInstance().getOpenProjects()));
                after.removeAll(before);
                for (Project eachHanging : after) {
                    if (eachHanging.isDefault()) continue;
                    try {
                        PlatformTestUtil.forceCloseProjectWithoutSaving((Project)eachHanging);
                    }
                    catch (Throwable closeException) {
                        closeException.printStackTrace();
                    }
                }
            }
            throw e;
        }
        this.checkProjectOpenedCorrectly();
    }

    @NotNull
    protected abstract Project doOpenProject(@NotNull VirtualFile var1) throws Exception;

    protected void checkProjectOpenedCorrectly() {
    }

    public static void cleanupStatics() {
        if (ourProjectCleanup != null) {
            ourProjectCleanup.run();
            ourProjectCleanup = null;
        }
    }

    public final void closeProject() {
        CidrProjectFixture.closeProject(this, false);
    }

    public static <B> void closeProject(@Nullable CidrProjectFixture<B> holder, boolean cleanup) {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (ourProject != null) {
            actions.add(() -> LOG.debug("Cleaning test project"));
            if (cleanup) {
                actions.addAll(ourAdditionalProjectCleanUpRunnableList);
                ourAdditionalProjectCleanUpRunnableList.clear();
            }
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> CidrProjectFixture.notifyDependentFixtures(false, holder)));
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> TestApplicationManager.getInstance().setDataProvider(null)));
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> ourCloseProjectRunnable.consume((Object)ourProject)));
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> ourVirtualFilePointerTracker.assertPointersAreDisposed()));
            actions.add(() -> EdtTestUtil.runInEdtAndWait(() -> {
                CidrProjectFixture.setProject(holder, null);
                LightPlatformTestCase.checkEditorsReleased();
                if (holder != null) {
                    holder.myOldSdks.checkForJdkTableLeaks();
                }
            }));
            actions.add(() -> LOG.debug("Cleaned test project"));
        }
        actions.add(() -> {
            LOG.debug("Cleaning test resources");
            if (cleanup) {
                if (ourTestRoot != null) {
                    WriteAction.runAndWait(() -> {
                        FileUtil.delete((File)new File(ourTestRoot.getPath()));
                        ourTestRoot.refresh(false, false);
                    });
                }
                ourVirtualFilePointerTracker = null;
                ourProjectInfo = null;
                ourTestRoot = null;
                ourProjectDir = null;
                ourProjectFile = null;
                ourTestFilesChanged = false;
            }
        });
        new RunAll(actions).run();
    }

    @NotNull
    protected ThrowableConsumer<Project, Throwable> getCloseProjectRunnable() {
        return project2 -> {
            ProjectManagerEx.getInstanceEx().forceCloseProject(project2);
            HeavyPlatformTestCase.cleanupApplicationCaches((Project)project2);
        };
    }

    protected void addProjectCleanUpRunnables(List<ThrowableRunnable<Throwable>> list) {
        list.add((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            OCWorkspace workspace;
            if (this.isProjectInitialized() && (workspace = (OCWorkspace)this.getProject().getComponent(OCWorkspace.class)) instanceof OCWorkspaceImpl) {
                PathKt.delete((Path)((OCWorkspaceImpl)workspace).getStateFile());
            }
        }));
    }

    public final void saveAndCloseProject() {
        this.saveProject();
        this.closeProject();
    }

    public void saveProject() {
        EdtTestUtil.runInEdtAndWait(() -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            PlatformTestUtil.saveProject((Project)this.getProject(), (boolean)true);
        });
    }

    @Override
    public void afterProjectOpened() throws Exception {
    }

    @Override
    public void beforeProjectClosed() {
    }

    protected void afterTestDataCopied(@NotNull File copyDestination, @NotNull File adjustedProjectDir) throws Exception {
    }

    private static <B> void setProject(@Nullable CidrProjectFixture<B> holder, @Nullable Project project2) throws Exception {
        ourProject = project2;
        TestApplicationManager.getInstance().setDataProvider((DataProvider)(project2 == null ? null : new TestDataProvider(project2)));
        CidrProjectFixture.notifyDependentFixtures(true, holder);
    }

    @NotNull
    public VirtualFile getTestRoot() {
        return ourTestRoot;
    }

    @NotNull
    public File getTestIORoot() {
        return new File(this.getTestRootPath());
    }

    @NotNull
    public String getTestRootPath() {
        return ourTestRoot.getPath();
    }

    @NotNull
    public VirtualFile getProjectFile() {
        return ourProjectFile;
    }

    @NotNull
    public File getProjectIOFile() {
        return new File(this.getProjectFilePath());
    }

    @NotNull
    public String getProjectFilePath() {
        return ourProjectFile.getPath();
    }

    public VirtualFile getProjectDir() {
        return ourProjectDir;
    }

    @NotNull
    public Path getProjectIODir() {
        return Paths.get(this.getProjectDirPath(), new String[0]);
    }

    @NotNull
    public String getProjectDirPath() {
        return ourProjectDir.getPath();
    }

    @NotNull
    public Project getProject() {
        this.checkInitProjectCalled();
        if (!this.isProjectOpened()) {
            throw new RuntimeException("Project is not opened.");
        }
        return ourProject;
    }

    @Nullable
    public Project getProjectUnchecked() {
        return ourProject;
    }

    public boolean isProjectOpened() {
        return ourProject != null;
    }

    public Module getModule() {
        Module[] modules2 = ModuleManager.getInstance((Project)this.getProject()).getModules();
        return modules2[modules2.length - 1];
    }

    public List<String> getContentRootPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (String eachUrl : ModuleRootManager.getInstance((Module)module).getContentRootUrls()) {
                result.add(VfsUtilCore.urlToPath((String)eachUrl));
            }
        }
        return result;
    }

    public List<VirtualFile> getContentRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            result.addAll(Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots()));
        }
        return result;
    }

    public List<String> getSourceRootPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (String eachUrl : ModuleRootManager.getInstance((Module)module).getSourceRootUrls()) {
                result.add(VfsUtilCore.urlToPath((String)eachUrl));
            }
        }
        return result;
    }

    public List<VirtualFile> getSourceRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            result.addAll(Arrays.asList(ModuleRootManager.getInstance((Module)module).getSourceRoots()));
        }
        return result;
    }

    public List<String> getExcludeRootPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (String eachUrl : ModuleRootManager.getInstance((Module)module).getExcludeRootUrls()) {
                result.add(VfsUtilCore.urlToPath((String)eachUrl));
            }
        }
        return result;
    }

    public List<VirtualFile> getExcludeRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            result.addAll(Arrays.asList(ModuleRootManager.getInstance((Module)module).getExcludeRoots()));
        }
        return result;
    }

    public List<String> getLibraryRootPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (OrderEntry each : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(each instanceof LibraryOrderEntry)) continue;
                for (String eachUrl : each.getUrls(OrderRootType.CLASSES)) {
                    result.add(VfsUtilCore.urlToPath((String)eachUrl));
                }
            }
        }
        return result;
    }

    public List<VirtualFile> getLibraryRoots() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            for (OrderEntry each : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(each instanceof LibraryOrderEntry)) continue;
                result.addAll(Arrays.asList(each.getFiles(OrderRootType.CLASSES)));
            }
        }
        return result;
    }

    @NotNull
    public OCWorkspace getWorkspace() {
        return OCWorkspace.getInstance(this.getProject());
    }

    private void checkInitProjectCalled() {
        if (!this.myInitProjectHasBeenCalled) {
            throw new RuntimeException("CidrProjectFixture.initProject has never been called for this test.");
        }
    }

    public boolean isProjectInitialized() {
        return this.myInitProjectHasBeenCalled;
    }

    @NotNull
    public String getProjectSubPath(@NotNull String relativePath) {
        return FileUtil.toCanonicalPath((String)this.getProjectSubIOFile(relativePath).getPath());
    }

    @NotNull
    public File getProjectSubIOFile(@Nullable String relativePath) {
        return relativePath == null ? new File(ourProjectDir.getPath()) : new File(ourProjectDir.getPath(), relativePath);
    }

    @NotNull
    public File findProjectSubIOFile(@Nullable String relativePath) {
        return this.getProjectSubIOFile(relativePath);
    }

    @Nullable
    public VirtualFile findProjectSubFile(@Nullable String relativePath) {
        return relativePath == null ? ourProjectDir : ourProjectDir.findFileByRelativePath(relativePath);
    }

    @NotNull
    public VirtualFile getProjectSubFile(@Nullable String relativePath) {
        VirtualFile result = this.findProjectSubFile(relativePath);
        CidrProjectFixture.assertNotNull((String)("File not found: " + relativePath), (Object)result);
        return result;
    }

    @Nullable
    public PsiFile findProjectSubPsiFile(@Nullable String relativePath) {
        VirtualFile file2 = this.findProjectSubFile(relativePath);
        return file2 == null ? null : (PsiFile)ReadAction.compute(() -> OCLanguageUtils.tryGetOCFile((PsiFile)PsiManager.getInstance((Project)this.getProject()).findFile(file2)));
    }

    @Nullable
    public PsiDirectory findProjectSubPsiDirectory(@Nullable String relativePath) {
        VirtualFile file2 = this.findProjectSubFile(relativePath);
        return file2 == null ? null : (PsiDirectory)ReadAction.compute(() -> PsiManager.getInstance((Project)this.getProject()).findDirectory(file2));
    }

    @NotNull
    public PsiFile getProjectSubPsiFile(@Nullable String relativePath) {
        PsiFile result = this.findProjectSubPsiFile(relativePath);
        CidrProjectFixture.assertNotNull((String)("File not found: " + relativePath), (Object)result);
        return result;
    }

    @NotNull
    public PsiDirectory getProjectSubPsiDirectory(@Nullable String relativePath) {
        PsiDirectory result = this.findProjectSubPsiDirectory(relativePath);
        CidrProjectFixture.assertNotNull((String)("Dir not found: " + relativePath), (Object)result);
        return result;
    }

    @Nullable
    public OCFile findProjectSubOCFile(@Nullable String relativePath) {
        PsiFile file2 = this.findProjectSubPsiFile(relativePath);
        if (file2 != null) {
            UsefulTestCase.assertInstanceOf((Object)file2, OCPsiFile.class);
            return ((OCPsiFile)file2).getOCFile();
        }
        return null;
    }

    @NotNull
    public OCFile getProjectSubOCFile(@Nullable String relativePath) {
        OCFile result = this.findProjectSubOCFile(relativePath);
        CidrProjectFixture.assertNotNull((String)("File not found: " + relativePath), (Object)result);
        return result;
    }

    @NotNull
    public Module findModuleForFile(@NotNull String fileName) {
        VirtualFile file2 = this.findProjectSubFile(fileName);
        CidrProjectFixture.assertNotNull((Object)file2);
        return this.findModuleForFile(file2);
    }

    @NotNull
    public Module findModuleForFile(@NotNull VirtualFile file2) {
        Module module = ProjectFileIndex.getInstance((Project)this.getProject()).getModuleForFile(file2, false);
        CidrProjectFixture.assertNotNull((Object)module);
        return module;
    }

    public void assertFiles(Collection<VirtualFile> files, String ... expectedRelativePaths) {
        this.assertFiles(files, Arrays.asList(expectedRelativePaths));
    }

    public void assertFiles(Collection<VirtualFile> files, List<String> expectedRelativePaths) {
        this.assertIOFiles(this.collectIOFiles(files), expectedRelativePaths);
    }

    public void assertIOFiles(Collection<File> files, String ... expectedRelativePaths) {
        this.assertIOFiles(files, Arrays.asList(expectedRelativePaths));
    }

    public void assertIOFiles(Collection<File> files, List<String> expectedRelativePaths) {
        UsefulTestCase.assertSameElements(this.collectIOFilesPaths(files), expectedRelativePaths);
    }

    @NotNull
    public List<VirtualFile> collectProjectFiles(String ... relativePaths) {
        return this.collectProjectFiles(Arrays.asList(relativePaths));
    }

    @NotNull
    public List<String> collectProjectFilesPaths(List<String> relativePaths) {
        return ContainerUtil.map(relativePaths, s -> this.getProjectSubPath((String)s));
    }

    @NotNull
    public List<String> collectProjectFilesPaths(String ... relativePaths) {
        return this.collectProjectFilesPaths(Arrays.asList(relativePaths));
    }

    @NotNull
    public List<VirtualFile> collectProjectFiles(List<String> relativePaths) {
        return ContainerUtil.map(relativePaths, s -> this.getProjectSubFile((String)s));
    }

    @NotNull
    public List<VirtualFile> collectFilesFromPaths(String ... paths) {
        return this.collectFilesFromPaths(Arrays.asList(paths));
    }

    @NotNull
    public List<VirtualFile> collectFilesFromPaths(Collection<String> paths) {
        return ContainerUtil.map(paths, (Function)((NotNullFunction)path -> {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            CidrProjectFixture.assertNotNull((String)("file not found: " + path), (Object)file2);
            return file2;
        }));
    }

    @NotNull
    public List<File> collectIOFiles(Collection<VirtualFile> files) {
        return VfsUtilCore.virtualToIoFiles(files);
    }

    @NotNull
    public List<String> collectFilesPaths(Collection<VirtualFile> files) {
        return this.collectIOFilesPaths(this.collectIOFiles(files));
    }

    @NotNull
    public List<String> collectFullFilesPaths(Collection<VirtualFile> files) {
        return ContainerUtil.map(files, file2 -> file2.getPath());
    }

    @NotNull
    public List<String> collectIOFilesPaths(Collection<File> files) {
        File base = this.getProjectIODir().toFile();
        return ContainerUtil.map(files, file2 -> FileUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)base, (File)file2)));
    }

    public void assertScope(int mask, String ... relativePaths) {
        this.assertScope(mask, this.collectProjectFiles(relativePaths));
    }

    public void assertScope(int mask, VirtualFile ... files) {
        this.assertScope(mask, Arrays.asList(files));
    }

    public void assertScope(int mask, List<VirtualFile> files) {
        ApplicationManager.getApplication().runReadAction(() -> {
            StringBuilder m = new StringBuilder();
            m.append(CidrProjectFixture.assertScope(ProjectScope.getAllScope((Project)this.getProject()), "all", (mask & 3) != 0 || (mask & 8) != 0, files));
            m.append(CidrProjectFixture.assertScope(ProjectScope.getProjectScope((Project)this.getProject()), "project", (mask & 1) != 0, files));
            m.append(CidrProjectFixture.assertScope(ProjectScope.getLibrariesScope((Project)this.getProject()), "libraries", (mask & 8) != 0, files));
            m.append(CidrProjectFixture.assertScope(ProjectScope.getContentScope((Project)this.getProject()), "content", (mask & 3) != 0, files));
            GlobalSearchScope sourcesScope = OCSearchScope.getProjectSourcesScope((Project)this.getProject());
            OCGeneratedSourcesFilter.GeneratedSourcesScope generatedSourcesScope = new OCGeneratedSourcesFilter.GeneratedSourcesScope(this.getProject(), sourcesScope);
            m.append(CidrProjectFixture.assertScope(sourcesScope, "content sources", (mask & 4) != 0, files));
            m.append(CidrProjectFixture.assertScope((GlobalSearchScope)generatedSourcesScope, "content generated sources", (mask & 0x10) != 0, files));
            if (m.length() > 0) {
                CidrProjectFixture.fail((String)m.toString());
            }
        });
    }

    private static String assertScope(GlobalSearchScope scope, String scopeName, boolean inScope, List<VirtualFile> files) {
        ArrayList<VirtualFile> wrongFiles = new ArrayList<VirtualFile>();
        for (VirtualFile each : files) {
            CidrProjectFixture.assertNotNull((String)"Null file passed into the check", (Object)each);
            if (scope.contains(each) == inScope) continue;
            wrongFiles.add(each);
        }
        if (!wrongFiles.isEmpty()) {
            return "Files should " + (inScope ? "be" : "NOT be") + " in " + scopeName + " scope: \n" + StringUtil.join(wrongFiles, file2 -> " " + file2.getPath(), (String)"\n") + "\n\n";
        }
        return "";
    }

    @Nullable
    public OCResolveConfiguration findResolveConfiguration(String configAndVariantName) {
        for (OCResolveConfiguration each : this.getWorkspace().getConfigurations()) {
            if (!CidrProjectFixture.formatConfigName(each).matches(FileUtil.convertAntToRegexp((String)configAndVariantName))) continue;
            return each;
        }
        return null;
    }

    @NotNull
    protected static String formatConfigName(OCResolveConfiguration each) {
        Object eachName = each.getName();
        OCVariant variant = each.getVariant();
        if (variant != null) {
            eachName = (String)eachName + " [" + variant.getDisplayName() + "]";
        }
        return eachName;
    }

    @Nullable
    public OCResolveConfiguration findResolveConfigurationForTarget(String targetName) {
        for (OCResolveConfiguration each : this.getWorkspace().getConfigurations()) {
            if (!each.getName().equals(targetName)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public OCResolveConfiguration getFirstResolveConfiguration() {
        return this.getWorkspace().getConfigurations().get(0);
    }

    @NotNull
    public OCResolveConfiguration getResolveConfiguration(String configAndVariantName) {
        OCResolveConfiguration result = this.findResolveConfiguration(configAndVariantName);
        CidrProjectFixture.assertNotNull((String)("configuration not found:" + configAndVariantName + " among " + ContainerUtil.map(this.getWorkspace().getConfigurations(), CidrProjectFixture::formatConfigName)), (Object)result);
        return result;
    }

    @NotNull
    public OCResolveConfiguration getResolveConfigurationForTarget(String targetName) {
        OCResolveConfiguration result = this.findResolveConfigurationForTarget(targetName);
        CidrProjectFixture.assertNotNull((String)("configuration not found:" + targetName + " among " + ContainerUtil.map(this.getWorkspace().getConfigurations(), CidrProjectFixture::formatConfigName)), (Object)result);
        return result;
    }

    public void assertOrderedResolveConfigurations(String ... expectedConfigNames) {
        this.assertOrderedResolveConfigurations(Arrays.asList(expectedConfigNames));
    }

    public void assertOrderedResolveConfigurations(@NotNull List<String> expectedConfigNames) {
        this.assertOrderedResolveConfigurations(this.getWorkspace().getConfigurations(), expectedConfigNames);
    }

    public void assertOrderedResolveConfigurations(@NotNull List<OCResolveConfiguration> configurations, String ... expectedConfigNames) {
        this.assertOrderedResolveConfigurations(configurations, Arrays.asList(expectedConfigNames));
    }

    public void assertOrderedResolveConfigurations(@NotNull List<OCResolveConfiguration> configurations, List<String> expectedConfigNames) {
        UsefulTestCase.assertOrderedEquals(this.collectResolveConfigurationsNames(configurations), expectedConfigNames);
    }

    @NotNull
    public List<String> collectResolveConfigurationsNames(@NotNull List<OCResolveConfiguration> configurations) {
        return ContainerUtil.map(configurations, CidrProjectFixture::formatConfigName);
    }

    @NotNull
    public OCResolveConfiguration addResolveConfiguration(@NotNull String id, Consumer<OCResolveConfiguration.ModifiableModel> updater) {
        this.updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> {
            OCResolveConfiguration.ModifiableModel configModel = model.addConfiguration(id, id);
            updater.consume((Object)configModel);
        }));
        return this.getWorkspace().getConfigurationById(id);
    }

    public void removeResolveConfiguration(@NotNull OCResolveConfiguration config) {
        this.updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> {
            String id = config.getUniqueId();
            OCResolveConfiguration.ModifiableModel configModel = model.getConfigurationById(id);
            CidrProjectFixture.assertNotNull((String)("Configuration not found: " + id), (Object)configModel);
            model.removeConfiguration(configModel);
        }));
    }

    public void updateFirstResolveConfiguration(Consumer<OCResolveConfiguration.ModifiableModel> updater) {
        this.updateResolveConfiguration(null, updater);
    }

    public void updateResolveConfiguration(@Nullable OCResolveConfiguration configOrNullForDefault, Consumer<OCResolveConfiguration.ModifiableModel> updater) {
        this.updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> {
            OCResolveConfiguration.ModifiableModel configModel;
            if (configOrNullForDefault == null) {
                configModel = model.getConfigurations().get(0);
            } else {
                String id = configOrNullForDefault.getUniqueId();
                configModel = model.getConfigurationById(id);
                CidrProjectFixture.assertNotNull((String)("Configuration not found: " + id), (Object)configModel);
            }
            updater.consume((Object)configModel);
        }));
    }

    public void updateAllResolveConfigurations(Consumer<OCResolveConfiguration.ModifiableModel> updater) {
        this.updateWorkspace((Consumer<OCWorkspace.ModifiableModel>)((Consumer)model -> {
            for (OCResolveConfiguration.ModifiableModel each : model.getConfigurations()) {
                updater.consume((Object)each);
            }
        }));
    }

    public void updateWorkspace(Consumer<OCWorkspace.ModifiableModel> updater) {
        WriteAction.runAndWait(() -> {
            OCWorkspace.ModifiableModel model = this.getWorkspaceModifiableModel();
            try {
                updater.consume((Object)model);
                model.preCommit();
                model.commit();
            }
            finally {
                model.dispose();
            }
        });
    }

    public static void setDefaultFeatures64Bit(@NotNull OCResolveConfiguration.ModifiableModel configuration2) {
        HashMap<OCCompilerFeatures.TypeSize, Short> features = new HashMap<OCCompilerFeatures.TypeSize, Short>();
        features.put(OCCompilerFeatures.TypeSize.SIZE_T, (short)8);
        features.put(OCCompilerFeatures.TypeSize.LONG, (short)8);
        features.put(OCCompilerFeatures.TypeSize.DOUBLE, (short)8);
        features.put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, (short)16);
        configuration2.getDefaultCompilerSettings().setCompilerFeatures(features);
        for (CLanguageKind eachLang : CLanguageKind.values()) {
            configuration2.getLanguageCompilerSettings(eachLang).setCompilerFeatures(features);
        }
    }

    @NotNull
    public HeadersSearchPath createSearchPath(@NotNull File dir, boolean recursive, @NotNull HeadersSearchPath.Kind kind) {
        return new HeadersSearchPath(dir, recursive, kind);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(String name, @Nullable Class<T> clazz) {
        return (T)((OCSymbol)ContainerUtil.getFirstItem(this.findSymbols(name, clazz), null));
    }

    @NotNull
    public <T extends OCSymbol> List<T> findSymbols(String name, @Nullable Class<T> clazz) {
        ArrayList result = new ArrayList();
        OCGlobalProjectSymbolsCache.processTopLevelSymbols((Project)this.getProject(), ocSymbol -> {
            if (clazz == null || clazz.isInstance(ocSymbol)) {
                result.add(ocSymbol);
            }
            return true;
        }, (String)name);
        return result;
    }

    @NotNull
    public List<OCClassSymbol> findClassSymbols(String name, @Nullable String category) {
        List result = this.findSymbols(name, OCClassSymbol.class);
        CidrProjectFixture.assertFalse((boolean)result.isEmpty());
        result = ContainerUtil.findAll(result, symbol -> Objects.equals(symbol.getCategoryName(), category));
        return result;
    }

    @Nullable
    public final BUILD_CONFIGURATION_TYPE getBuildConfiguration(@NotNull CidrRunConfiguration runConfiguration) {
        return this.getBuildConfiguration(runConfiguration, null);
    }

    @Nullable
    public abstract BUILD_CONFIGURATION_TYPE getBuildConfiguration(@NotNull CidrRunConfiguration var1, @Nullable ExecutionTarget var2);

    public String buildConfig(BUILD_CONFIGURATION_TYPE config) throws Exception {
        return this.doBuildOrCleanConfig(config, true, false, null);
    }

    public String buildConfig(BUILD_CONFIGURATION_TYPE config, boolean allowBuildToFail) throws Exception {
        return this.doBuildOrCleanConfig(config, true, allowBuildToFail, null);
    }

    public String buildConfig(BUILD_CONFIGURATION_TYPE config, @Nullable ProcessListener listener) throws Exception {
        return this.doBuildOrCleanConfig(config, true, false, listener);
    }

    public String cleanConfig(BUILD_CONFIGURATION_TYPE config) throws Exception {
        return this.doBuildOrCleanConfig(config, false, false, null);
    }

    private String doBuildOrCleanConfig(BUILD_CONFIGURATION_TYPE config, boolean build2, boolean allowBuildToFail, @Nullable ProcessListener listener) throws Exception {
        return this.doExecuteConfig(allowBuildToFail, listener, (Function<ProcessListener, ExecutionResult<CidrBuildResult>>)((Function)wrappingListener -> this.doBuildOrCleanConfig(config, build2, (ProcessListener)wrappingListener)));
    }

    protected String doExecuteConfig(boolean allowToFail, final @Nullable ProcessListener listener, Function<ProcessListener, ExecutionResult<CidrBuildResult>> executor) throws Exception {
        final StringBuilder outputBuilder = new StringBuilder();
        ProcessListener wrappingListener = new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (listener != null) {
                    listener.startNotified(event);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (listener != null) {
                    listener.processTerminated(event);
                }
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (listener != null) {
                    listener.processWillTerminate(event, willBeDestroyed);
                }
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                outputBuilder.append(event.getText());
                if (listener != null) {
                    listener.onTextAvailable(event, outputType);
                }
            }
        };
        ExecutionResult result = (ExecutionResult)executor.fun((Object)wrappingListener);
        try {
            Boolean[] success = new Boolean[1];
            CidrProjectFixture.measureTiming("Build", () -> {
                success[0] = ((CidrBuildResult)result.get(5L, TimeUnit.MINUTES)).getSucceeded();
            });
            String output = outputBuilder.toString();
            this.disposeBuildToolWindow();
            if (!allowToFail) {
                CidrProjectFixture.assertTrue((String)output, (boolean)success[0]);
            }
            return output;
        }
        catch (Exception e) {
            System.err.println(outputBuilder);
            if (e instanceof TimeoutException) {
                UsefulTestCase.printThreadDump();
            }
            throw e;
        }
    }

    public String disposeBuildToolWindow() {
        Content content = (Content)UIUtil.invokeAndWaitIfNeeded(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow("Messages");
            if (toolWindow == null) {
                return null;
            }
            ContentManager contentManager = toolWindow.getContentManager();
            return (Content)ContainerUtil.find((Object[])contentManager.getContents(), content1 -> content1.getDisplayName().equals(CidrExecutionBundle.message("build.logToolWindowName", new Object[0])));
        });
        String output = "";
        if (content != null) {
            JComponent console = content.getComponent();
            if (console instanceof ConsoleViewImpl) {
                ConsoleViewImpl consoleView = (ConsoleViewImpl)console;
                UIUtil.invokeAndWaitIfNeeded(() -> {
                    UIUtil.dispatchAllInvocationEvents();
                    consoleView.flushDeferredText();
                    consoleView.waitAllRequests();
                });
                output = consoleView.getText();
            }
            Disposer.register((Disposable)this.myProjectDisposable, (Disposable)content);
        }
        return output;
    }

    protected abstract ExecutionResult<CidrBuildResult> doBuildOrCleanConfig(@NotNull BUILD_CONFIGURATION_TYPE var1, boolean var2, @Nullable ProcessListener var3);

    @NotNull
    public BUILD_CONFIGURATION_TYPE buildIfNeeded(@NotNull CidrRunConfiguration runConfiguration) throws Exception {
        return this.buildIfNeeded(runConfiguration, null);
    }

    @NotNull
    public BUILD_CONFIGURATION_TYPE buildIfNeeded(@NotNull CidrRunConfiguration runConfiguration, @Nullable ExecutionTarget executionTarget) throws Exception {
        BUILD_CONFIGURATION_TYPE configuration2 = this.getBuildConfiguration(runConfiguration, executionTarget);
        CidrProjectFixture.assertNotNull(configuration2);
        return this.buildIfNeeded(configuration2);
    }

    @NotNull
    public BUILD_CONFIGURATION_TYPE buildIfNeeded(@NotNull BUILD_CONFIGURATION_TYPE buildConfiguration) throws Exception {
        String id;
        Set<String> builtConfigurations = this.getBuiltConfigurations();
        if (!builtConfigurations.contains(id = (String)ReadAction.compute(() -> this.getConfigBuildId(buildConfiguration)))) {
            this.buildConfig(buildConfiguration);
            builtConfigurations.add(id);
        }
        return buildConfiguration;
    }

    @NotNull
    public BUILD_CONFIGURATION_TYPE cleanIfNeeded(@NotNull BUILD_CONFIGURATION_TYPE config) throws Exception {
        Set<String> builtConfigurations = this.getBuiltConfigurations();
        if (builtConfigurations.remove(this.getConfigBuildId(config))) {
            this.cleanConfig(config);
        }
        return config;
    }

    protected abstract String getConfigBuildId(@NotNull BUILD_CONFIGURATION_TYPE var1);

    private Set<String> getBuiltConfigurations() {
        if (!this.isProjectOpened()) {
            return Collections.emptySet();
        }
        HashSet builtConfigurations = (HashSet)this.getProject().getUserData(BUILT_CONFIGURATIONS);
        if (builtConfigurations == null) {
            builtConfigurations = new HashSet();
            this.getProject().putUserData(BUILT_CONFIGURATIONS, builtConfigurations);
        }
        return builtConfigurations;
    }

    @NotNull
    public OCCompilerKind getCompilerType() {
        if (SystemInfo.isWindows) {
            return MSVCCompilerKind.INSTANCE;
        }
        if (SystemInfo.isLinux) {
            return GCCCompilerKind.INSTANCE;
        }
        if (SystemInfo.isMac) {
            return ClangCompilerKind.INSTANCE;
        }
        return UnknownCompilerKind.INSTANCE;
    }

    public Pair<Boolean, String> executeProjectTask(@NotNull BiConsumer<ProjectTaskManager, java.util.function.Consumer<ProjectTaskManager.Result>> taskExecutor) throws Exception {
        FutureResult success = new FutureResult();
        taskExecutor.accept(ProjectTaskManager.getInstance((Project)this.getProject()), result -> success.set((Object)(result != null && !result.isAborted() && !result.hasErrors() ? 1 : 0)));
        Ref finished = new Ref((Object)false);
        CidrProjectFixture.measureTiming("Build", () -> {
            try {
                success.get(1L, TimeUnit.MINUTES);
                finished.set((Object)true);
            }
            catch (TimeoutException ex) {
                finished.set((Object)false);
            }
        });
        CidrProjectFixture.assertTrue((String)"timeout", (boolean)((Boolean)finished.get()));
        boolean result2 = (Boolean)success.get();
        String output = this.disposeBuildToolWindow();
        return new Pair((Object)result2, (Object)output);
    }

    public Pair<Boolean, String> executeProjectTasks(@NotNull List<ProjectTask> tasks2) throws Exception {
        ProjectTaskList task = tasks2.size() == 1 ? tasks2.get(0) : new ProjectTaskList(tasks2);
        return this.executeProjectTask((arg_0, arg_1) -> CidrProjectFixture.lambda$executeProjectTasks$52((ProjectTask)task, arg_0, arg_1));
    }

    public Pair<Boolean, String> executeProjectTasks(ProjectTask ... tasks2) throws Exception {
        return this.executeProjectTasks(Arrays.asList(tasks2));
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationTypeBase type, @Nullable BuildTargetAndConfigurationData buildTargetAndConfigurationData, boolean temporary, boolean shared, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)WriteAction.computeAndWait(() -> {
            RunManager runManager = RunManager.getInstance((Project)this.getProject());
            runManager.removeConfiguration(runManager.findConfigurationByName(name));
            return runManager.createConfiguration(name, type.getConfigurationFactories()[0]);
        });
        return this.createRunConfiguration(settings, buildTargetAndConfigurationData, temporary, shared, configurator);
    }

    protected RunnerAndConfigurationSettings createRunConfiguration(@NotNull RunnerAndConfigurationSettings settings, @Nullable BuildTargetAndConfigurationData buildTargetAndConfigurationData, boolean temporary, boolean shared, @Nullable Consumer<CidrRunConfiguration> configurator) {
        settings.setTemporary(temporary);
        CidrRunConfiguration config = (CidrRunConfiguration)settings.getConfiguration();
        config.setTargetAndConfigurationData(buildTargetAndConfigurationData);
        if (config instanceof CidrExecutableDataHolder) {
            ExecutableData data = buildTargetAndConfigurationData != null && buildTargetAndConfigurationData.target != null ? new ExecutableData(buildTargetAndConfigurationData.target) : null;
            ((CidrExecutableDataHolder)((Object)config)).setExecutableData(data);
        }
        if (configurator != null) {
            configurator.consume((Object)config);
        }
        WriteAction.runAndWait(() -> {
            RunManagerImpl runManager = (RunManagerImpl)RunManager.getInstance((Project)this.getProject());
            runManager.fireBeginUpdate();
            if (shared) {
                settings.storeInDotIdeaFolder();
            } else {
                settings.storeInLocalWorkspace();
            }
            runManager.addConfiguration(settings);
            runManager.setSelectedConfiguration(settings);
            runManager.fireEndUpdate();
        });
        return settings;
    }

    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull ConfigurationTypeBase type, @Nullable BuildTargetAndConfigurationData buildTargetAndConfigurationData, @Nullable Consumer<CidrRunConfiguration> configurator) throws Exception {
        return this.createRunConfiguration("__test__", type, buildTargetAndConfigurationData, true, true, configurator);
    }

    @NotNull
    public abstract CidrWorkspace getCidrWorkspace();

    public final @NotNull OCWorkspace.ModifiableModel getWorkspaceModifiableModel() {
        return this.getWorkspaceModifiableModel(false);
    }

    public abstract @NotNull OCWorkspace.ModifiableModel getWorkspaceModifiableModel(boolean var1);

    public void changeContentRoot(@Nullable VirtualFile root) {
        WriteAction.runAndWait(() -> this.getCidrWorkspace().changeContentRoot(root));
    }

    @NotNull
    public String getProjectName() {
        return this.getProject().getName();
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        return this.myProjectDisposable;
    }

    private static /* synthetic */ void lambda$executeProjectTasks$52(ProjectTask task, ProjectTaskManager taskManager, java.util.function.Consumer callback) {
        taskManager.run(task).onProcessed(callback);
    }

    static {
        ourRunningFixture = false;
        ourAdditionalProjectCleanUpRunnableList = new SmartList();
        ourProjectTimingMap = new HashMap<ProjectTestData, ProjectTiming>();
    }

    private static class ProjectInfo {
        String adjustedRelativeProjectPath;
        String adjustedRelativePathToCopy;
        ProjectTestData testData = new ProjectTestData();
        boolean isSymlinked;
        Class<? extends CidrTestDataFixture> testDataFixtureClass;
        Object cleanKey;

        private ProjectInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectInfo info = (ProjectInfo)o;
            if (!Objects.equals(this.testData, info.testData)) {
                return false;
            }
            if (!Objects.equals(this.cleanKey, info.cleanKey)) {
                return false;
            }
            if (!Objects.equals(this.testDataFixtureClass, info.testDataFixtureClass)) {
                return false;
            }
            return this.isSymlinked == info.isSymlinked;
        }

        public int hashCode() {
            int result = this.testData.hashCode();
            result = 31 * result + Objects.hashCode(this.cleanKey);
            result = 31 * result + Objects.hashCode(this.testDataFixtureClass);
            result = 31 * result + (this.isSymlinked ? 1 : 0);
            return result;
        }

        public String toString() {
            return "ProjectInfo{adjustedRelativeProjectPath='" + this.adjustedRelativeProjectPath + "', adjustedRelativePathToCopy='" + this.adjustedRelativePathToCopy + "', testData=" + this.testData + ", isSymlinked=" + this.isSymlinked + ", cleanKey=" + this.cleanKey + "}";
        }
    }

    private static class ProjectTestData {
        File adjustedProjectDir;
        File projectDir;
        File dirToCopy;

        private ProjectTestData() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectTestData data = (ProjectTestData)o;
            if (!FileUtil.filesEqual((File)this.adjustedProjectDir, (File)data.adjustedProjectDir)) {
                return false;
            }
            if (!FileUtil.filesEqual((File)this.dirToCopy, (File)data.dirToCopy)) {
                return false;
            }
            return FileUtil.filesEqual((File)this.projectDir, (File)data.projectDir);
        }

        public int hashCode() {
            int result = FileUtil.fileHashCode((File)this.adjustedProjectDir);
            result = 31 * result + FileUtil.fileHashCode((File)this.projectDir);
            result = 31 * result + FileUtil.fileHashCode((File)this.dirToCopy);
            return result;
        }

        public String toString() {
            return "ProjectTestData{adjustedProjectDir=" + this.adjustedProjectDir + ", projectDir=" + this.projectDir + ", dirToCopy=" + this.dirToCopy + "}";
        }
    }

    public static enum OpenProjectKind {
        AS_SPECIFIED_FILE,
        AS_DOT_IDEA,
        AS_RECENT,
        AS_DIRECTORY;

    }

    private static class ProjectTiming {
        final Map<String, Step> steps = new LinkedHashMap<String, Step>();

        private ProjectTiming() {
        }

        private static class Step {
            long first = -1L;
            long total = -1L;
            int performedTimes = 0;

            private Step() {
            }
        }
    }

    public static enum CleanProjectOption {
        DO_NOT_CLEAN,
        CLEAN_EACH_TIME,
        CLEAN_FOR_TESTCASE;

    }
}

