/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.CidrPrefixStringLiteralLexer;
import com.intellij.cidr.cpp.lexer.CidrStringLiteralLexer;
import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCLexerWithDirectives;
import com.intellij.cidr.cpp.lexer.OCRawStringLexerBase;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCHighlightingLexer
extends OCLexerWithDirectives {
    public static final char STRING_START = '\"';
    public static final char CHAR_START = '\'';

    @NotNull
    public static OCHighlightingLexer createDefault(@NotNull CidrTokenTypeProvider tokenTypeProvider) {
        return new OCHighlightingLexer(CidrLexerSettings.forLanguage(tokenTypeProvider, CLanguageKind.OBJ_CPP).forHighlighting().build());
    }

    @Contract(value="_, _ -> !null")
    @NotNull
    public static StringLiteralLexer createStringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        return new CidrStringLiteralLexer(quoteChar, originalLiteralToken);
    }

    @Contract(value="_ -> !null")
    @NotNull
    public static OCRawStringLexerBase createRawStringLexer(@NotNull CidrTokenTypeProvider tokenTypeProvider) {
        return new OCRawStringLexerBase(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, tokenTypeProvider.getSTRING_LITERAL());
    }

    public OCHighlightingLexer(@NotNull CidrLexerSettings settings) {
        super(settings);
        CidrPrefixStringLiteralLexer stringLiteralLexer = new CidrPrefixStringLiteralLexer('\"', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), (LexerBase)OCHighlightingLexer.createStringLiteralLexer('\"', this.myTokenTypeProvider.getSTRING_LITERAL()));
        this.registerSelfStoppingLayer((Lexer)stringLiteralLexer, new IElementType[]{this.myTokenTypeProvider.getSTRING_LITERAL()}, IElementType.EMPTY_ARRAY);
        CidrPrefixStringLiteralLexer charLiteralLexer = new CidrPrefixStringLiteralLexer('\'', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), (LexerBase)OCHighlightingLexer.createStringLiteralLexer('\'', this.myTokenTypeProvider.getCHARACTER_LITERAL()));
        this.registerSelfStoppingLayer((Lexer)charLiteralLexer, new IElementType[]{this.myTokenTypeProvider.getCHARACTER_LITERAL()}, IElementType.EMPTY_ARRAY);
        CidrPrefixStringLiteralLexer rawStringLiteralLexer = new CidrPrefixStringLiteralLexer('\"', this.myTokenTypeProvider.getRAW_STRING_PREFIX_TYPE(), OCHighlightingLexer.createRawStringLexer(this.myTokenTypeProvider));
        this.registerSelfStoppingLayer((Lexer)rawStringLiteralLexer, new IElementType[]{this.myTokenTypeProvider.getRAW_STRING_LITERAL(), this.myTokenTypeProvider.getWRONG_RAW_STRING_LITERAL()}, IElementType.EMPTY_ARRAY);
    }
}

