/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp;

import com.intellij.cidr.cpp.psi.CidrStringLiteralExpression;
import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.cidr.cpp.util.CidrStringLiteral;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import gnu.trove.TIntArrayList;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H&J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/cidr/cpp/CidrLiteralExpressionTextEscaper;", "T", "Lcom/intellij/cidr/cpp/util/CidrStringLiteral;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/cidr/cpp/psi/CidrStringLiteralExpression;", "myExpression", "(Lcom/intellij/cidr/cpp/psi/CidrStringLiteralExpression;)V", "sourceOffsets", "", "buildSourceOffsets", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "decode", "", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getStringCodec", "Lcom/intellij/cidr/cpp/util/CidrStringCodec;", "isOneLine", "relatedNodes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lang/ASTNode;", "singleOCStringLiteralForRange", "intellij.cidr.psi.base"})
public abstract class CidrLiteralExpressionTextEscaper<T extends CidrStringLiteral>
extends LiteralTextEscaper<CidrStringLiteralExpression<? extends T>> {
    private int[] sourceOffsets;

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        int[] nArray = this.buildSourceOffsets(rangeInsideHost);
        if (nArray == null) {
            return false;
        }
        this.sourceOffsets = nArray;
        CidrStringLiteral cidrStringLiteral = this.singleOCStringLiteralForRange(rangeInsideHost);
        if (cidrStringLiteral == null) {
            return false;
        }
        CidrStringLiteral ocStringLiteral = cidrStringLiteral;
        String contents = ocStringLiteral.getContents(false);
        outChars.append(contents);
        return this.getOffsetInHost(contents.length(), rangeInsideHost) == rangeInsideHost.getEndOffset();
    }

    private final CidrStringLiteral singleOCStringLiteralForRange(TextRange rangeInsideHost) {
        ASTNode aSTNode = (ASTNode)SequencesKt.singleOrNull(this.relatedNodes(rangeInsideHost));
        if (aSTNode == null) {
            return null;
        }
        ASTNode astNode = aSTNode;
        return CidrStringLiteralUtil.parseStringLiteral(this.getStringCodec(), astNode.getText());
    }

    private final Sequence<ASTNode> relatedNodes(TextRange rangeInsideHost) {
        TextRange rangeInDoc = rangeInsideHost.shiftRight(((CidrStringLiteralExpression)this.myHost).getTextOffset());
        return SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])((CidrStringLiteralExpression)this.myHost).getNode().getChildren(this.getStringCodec().getAllLiterals())), (Function1)((Function1)new Function1<ASTNode, Boolean>(rangeInDoc){
            final /* synthetic */ TextRange $rangeInDoc;

            public final boolean invoke(ASTNode it) {
                return this.$rangeInDoc.intersects(it.getTextRange());
            }
            {
                this.$rangeInDoc = textRange;
                super(1);
            }
        }));
    }

    private final int[] buildSourceOffsets(TextRange rangeInsideHost) {
        TIntArrayList sourceOffsetsList = new TIntArrayList();
        int sourceOffset = 0;
        for (ASTNode astNode : this.relatedNodes(rangeInsideHost)) {
            T ocStringLiteral = CidrStringLiteralUtil.parseStringLiteral(this.getStringCodec(), astNode.getText());
            int startIndex = StringsKt.indexOf$default((CharSequence)((CidrStringLiteralExpression)this.myHost).getText(), (String)((CidrStringLiteral)ocStringLiteral).contents, (int)(astNode.getStartOffset() - ((CidrStringLiteralExpression)this.myHost).getTextRange().getStartOffset()), (boolean)false, (int)4, null);
            if (startIndex == -1) {
                return null;
            }
            TextRange contentRangeInHost = TextRange.from((int)startIndex, (int)((CidrStringLiteral)ocStringLiteral).contents.length());
            CharSequence text = contentRangeInHost.subSequence((CharSequence)((CidrStringLiteralExpression)this.myHost).getText());
            int textLength = text.length();
            if (((CidrStringLiteral)ocStringLiteral).prefix.isRaw) {
                int n = 0;
                while (n < textLength) {
                    int it = n++;
                    boolean bl = false;
                    int n2 = sourceOffset;
                    sourceOffset = n2 + 1;
                    sourceOffsetsList.add(n2);
                }
                continue;
            }
            for (int positionInHost = 0; positionInHost < contentRangeInHost.getLength(); ++positionInHost) {
                int n = sourceOffset;
                sourceOffset = n + 1;
                sourceOffsetsList.add(n);
                if (text.charAt(positionInHost) != '\\') continue;
                n = sourceOffset;
                sourceOffset = n + 1;
                ++positionInHost;
            }
        }
        sourceOffsetsList.add(sourceOffset);
        return sourceOffsetsList.toNativeArray();
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        if (this.sourceOffsets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOffsets");
        }
        if (offsetInDecoded >= this.sourceOffsets.length) {
            return -1;
        }
        if (this.sourceOffsets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOffsets");
        }
        return RangesKt.coerceAtMost((int)this.sourceOffsets[offsetInDecoded], (int)rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    @NotNull
    public abstract CidrStringCodec<T> getStringCodec();

    public CidrLiteralExpressionTextEscaper(@NotNull CidrStringLiteralExpression<? extends T> myExpression) {
        super((PsiLanguageInjectionHost)myExpression);
    }
}

