/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.modulemap.ModuleMapFileType;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapFile;
import com.jetbrains.cidr.lang.modulemap.psi.ModuleMapModuleDeclaration;
import com.jetbrains.cidr.lang.modulemap.psi.impl.legacy.ModuleMapLegacyFileImpl;
import com.jetbrains.cidr.lang.modulemap.psi.impl.legacy.ModuleMapLegacyModuleDeclarationImpl;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareHeadersSearchRoot;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleMapAwareAppleFramework
extends AppleFramework
implements ModuleMapAwareHeadersSearchRoot {
    protected ModuleMapAwareAppleFramework(@NotNull Project project, @NotNull String name) {
        super(project, name);
    }

    @Override
    @Nullable
    public VirtualFile getModuleMapVirtualFile() {
        VirtualFile realFile = this.findModuleMapVirtualFile();
        if (realFile != null) {
            return realFile;
        }
        return this.createLightModuleMapVirtualFile();
    }

    public boolean shouldModuleMapInferSubmodules() {
        return true;
    }

    @NotNull
    private VirtualFile createLightModuleMapVirtualFile() {
        PsiManagerEx managerEx = PsiManagerEx.getInstanceEx((Project)this.myProject);
        LightVirtualFile file = new LightVirtualFile("module.modulemap", (FileType)ModuleMapFileType.INSTANCE, (CharSequence)"");
        class FileViewProvider
        extends SingleRootFileViewProvider {
            FileViewProvider(@NotNull PsiManagerEx managerEx, VirtualFile file) {
                super((PsiManager)managerEx, file);
            }

            @Nullable
            protected PsiFile createFile(@NotNull Language lang) {
                return ModuleMapAwareAppleFramework.this.createLightModuleMapPsiFile();
            }
        }
        managerEx.getFileManager().setViewProvider((VirtualFile)file, (com.intellij.psi.FileViewProvider)new FileViewProvider(managerEx, (VirtualFile)file));
        return file;
    }

    @NotNull
    private ModuleMapFile createLightModuleMapPsiFile() {
        List<ModuleMapModuleDeclaration> modules2 = this.collectModulesForLightModuleMapFile();
        return new ModuleMapLegacyFileImpl(this.getProject(), modules2);
    }

    @NotNull
    protected List<ModuleMapModuleDeclaration> collectModulesForLightModuleMapFile() {
        ModuleMapLegacyModuleDeclarationImpl module = new ModuleMapLegacyModuleDeclarationImpl(this.getName(), this.shouldModuleMapInferSubmodules());
        return List.of(module);
    }
}

