/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapExplicitFrameworkPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareAppleFramework;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class ExplicitFramework
extends ModuleMapAwareAppleFramework {
    protected ExplicitFramework(@NotNull Project project, @NotNull @NlsSafe String name) {
        super(project, name);
    }

    @NotNull
    @NonNls
    public abstract String getId();

    @Nullable
    public PsiFileSystemItem getParentSdkOrFrameworkItem() {
        return null;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    public abstract @UnmodifiableView Collection<VirtualFile> getHeaders();

    @NotNull
    public @UnmodifiableView Set<VirtualFile> getAdditionalHeaders() {
        return Collections.emptySet();
    }

    @Nullable
    public abstract VirtualFile getModuleMapBaseDirectory();

    @Override
    @NotNull
    public ModuleMapPathResolver createModuleMapPathResolver() {
        return new ModuleMapExplicitFrameworkPathResolver(this);
    }

    public boolean containsHeader(@Nullable VirtualFile file) {
        return file != null && this.getHeaders().contains(file);
    }

    protected boolean processFrameworkChildren(PsiElementProcessor<? super PsiFileSystemItem> processor) {
        return this.processCustomFileSet(processor, this.getHeaders(), false);
    }
}

