/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCRootUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculator {
    private static final Key<Pair<Long, Boolean>> LOOKS_LIKE_OBJC_KEY = new Key("LOOKS_LIKE_OBJC_KEY");
    private static final FileAttribute LOOKS_LIKE_OBJC_ATTRIBUTE = new FileAttribute("LOOKS_LIKE_OBJC_ATTRIBUTE", 1, true);
    private static final TokenSet OBJC_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.AT, OCTokenTypes.IMPORT_DIRECTIVE}), OCTokenTypes.OBJC_KEYWORDS_NO_AT, OCTokenTypes.ARC_TYPE_QUALIFIERS});

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull PsiFile file) {
        Project project = file.getProject();
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
        if (OCInclusionContextUtil.isLongLived(virtualFile)) {
            return OCLanguageKindCalculator.calculateLanguageKindFast(virtualFile, project);
        }
        String name = file.getName();
        OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project, name);
        if (result != null) {
            return result;
        }
        return CLanguageKind.maxLanguage();
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        return OCLanguageKindCalculator.calculateLanguageKind(null, virtualFile, project, false);
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project, @Nullable VirtualFile file) {
        return OCLanguageKindCalculatorBase.tryFileTypeAndExtension((Project)project, (VirtualFile)file);
    }

    @Nullable
    public static OCLanguageKind calculateMinimalKindByExtension(@Nullable Project project, @NotNull String name) {
        return OCLanguageKindCalculatorBase.calculateMinimalKindByExtension((Project)project, (String)name);
    }

    @Nullable
    private static OCLanguageKind tryFileExtension(@Nullable Project project, @NotNull String name) {
        return OCLanguageKindCalculatorBase.tryFileExtension((Project)project, (String)name);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@NotNull OCPsiFile file) {
        return OCLanguageKindCalculator.calculateLanguageKind(OCFileActiveConfigurationCache.getActiveConfiguration((PsiElement)file), file, true);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration configuration, @NotNull OCPsiFile file, boolean tryFromRoot) {
        if (file instanceof OCCodeFragment) {
            PsiFile containingFile;
            PsiElement context;
            OCPsiFile curFile = file;
            while ((context = file.getContext()) != null && (containingFile = context.getContainingFile()) != null && !curFile.equals(containingFile)) {
                if (containingFile instanceof OCCodeFragment) {
                    curFile = (OCCodeFragment)containingFile;
                    continue;
                }
                OCLanguageKind kind = OCPsiFile.getKind(containingFile);
                if (kind == null) break;
                return kind;
            }
        }
        Project project = file.getProject();
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
        if (!OCInclusionContextUtil.isLongLived(virtualFile)) {
            String name = file.getName();
            OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project, name);
            if (result != null) {
                return result;
            }
            return CLanguageKind.maxLanguage();
        }
        return OCLanguageKindCalculator.calculateLanguageKind(configuration, virtualFile, project, tryFromRoot);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration activeConfig, @NotNull VirtualFile file, @NotNull Project project, boolean tryFromRoot) {
        OCLanguageKind result;
        if (activeConfig != null && (result = activeConfig.getDeclaredLanguageKind(file)) != null) {
            return result;
        }
        result = OCLanguageKindCalculator.tryFileTypeAndExtension(project, file);
        if (result != null) {
            return result;
        }
        if (tryFromRoot && OCRootUtil.isNeedToFindRoot(file, project)) {
            OCResolveRootAndConfiguration rootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(project).getResolveRootAndActiveConfiguration(file);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCResolveConfiguration rootConfig = rootAndConfiguration.getConfiguration();
            if (rootFile != null && rootConfig != null && !rootFile.equals(file)) {
                result = OCLanguageKindCalculator.tryLanguageKindFromPchRoot(rootConfig, file, rootFile);
                if (result != null) {
                    return result;
                }
                return OCLanguageKindCalculator.calculateLanguageKind(rootConfig, rootFile, project, false);
            }
        }
        boolean isCpp = OCLanguageKindCalculator.isCppPreferred(activeConfig, file.getName());
        boolean isCuda = OCFileTypeHelpers.isCudaFile((String)file.getName());
        boolean isObjC = OCLanguageKindCalculator.looksLikeObjC(file);
        return CLanguageKind.find((boolean)isObjC, (boolean)isCpp, (boolean)isCuda);
    }

    public static boolean isCppPreferred(@Nullable OCResolveConfiguration activeConfig, @NotNull String name) {
        if (OCFileTypeHelpers.isCppFile((String)name)) {
            return true;
        }
        if (activeConfig != null) {
            Set kinds = activeConfig.getEnabledLanguageKinds();
            return kinds.isEmpty() || kinds.stream().anyMatch(OCLanguageKind::isCpp);
        }
        return true;
    }

    @Nullable
    public static OCLanguageKind tryLanguageKindFromPchRoot(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        OCImmutableInclusionContext cachedContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, header, pchCandidate);
        return cachedContext != null ? cachedContext.getLanguageKind() : null;
    }

    public static boolean looksLikeObjC(@NotNull VirtualFile file) {
        if (file.getFileType().isBinary()) {
            return false;
        }
        long currentTimestamp = file.getModificationStamp();
        Pair info = (Pair)LOOKS_LIKE_OBJC_KEY.get((UserDataHolder)file);
        if (info != null && (Long)info.first == currentTimestamp) {
            return (Boolean)info.second;
        }
        if (info == null) {
            info = OCLanguageKindCalculator.readDetectionInfo(file);
        }
        if (info == null || (Long)info.first != currentTimestamp) {
            CharSequence text = LoadTextUtil.loadText((VirtualFile)file, (int)2048);
            boolean isObjC = OCLanguageKindCalculator.calcLooksLikeObjC(text);
            info = Pair.create((Object)currentTimestamp, (Object)isObjC);
            OCLanguageKindCalculator.writeDetectionInfo(file, (Pair<Long, Boolean>)info);
        }
        file.putUserData(LOOKS_LIKE_OBJC_KEY, info);
        return (Boolean)info.second;
    }

    public static void markAsObjC(@NotNull VirtualFile file) {
        Pair info = Pair.create((Object)file.getModificationStamp(), (Object)true);
        file.putUserData(LOOKS_LIKE_OBJC_KEY, (Object)info);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Long, Boolean> readDetectionInfo(@NotNull VirtualFile file) {
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try (AttributeInputStream in = LOOKS_LIKE_OBJC_ATTRIBUTE.readFileAttribute(file);){
            if (in == null) return null;
            long timestamp = in.readLong();
            boolean isObjC = in.readBoolean();
            Pair pair = Pair.create((Object)timestamp, (Object)isObjC);
            return pair;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void writeDetectionInfo(@NotNull VirtualFile file, @NotNull Pair<Long, Boolean> info) {
        if (!(file instanceof VirtualFileWithId)) {
            return;
        }
        try (AttributeOutputStream out = LOOKS_LIKE_OBJC_ATTRIBUTE.writeFileAttribute(file);){
            out.writeLong((Long)info.first);
            out.writeBoolean((Boolean)info.second);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean calcLooksLikeObjC(CharSequence text) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.OBJ_CPP).build());
        lexer.start(text);
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (OBJC_TOKENS.contains(tt)) {
                return true;
            }
            lexer.advance();
        }
        return false;
    }
}

