/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.cidr.cpp.lexer.CidrTokenTypeProvider;
import com.intellij.cidr.cpp.lexer.OCHighlightingLexer;
import com.intellij.cidr.cpp.lexer.OCRawStringLexerBase;
import com.intellij.cidr.cpp.util.CidrIntType;
import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.lexer.OCTokenTypeProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import org.jetbrains.annotations.NotNull;

public class OCStringCodec
implements CidrStringCodec<OCStringLiteral> {
    public static OCStringCodec STRING_CODEC = new OCStringCodec();

    @NotNull
    public OCStringLiteral createStringLiteral(@NotNull CidrStringLiteralUtil.CidrStringPrefix prefix, @NotNull String string) {
        return new OCStringLiteral(prefix, string);
    }

    @NotNull
    public OCRawStringLexerBase createRawStringLexer() {
        return OCHighlightingLexer.createRawStringLexer((CidrTokenTypeProvider)OCTokenTypeProvider.INSTANCE);
    }

    @NotNull
    public OCStringLiteral getBadLiteral() {
        return OCStringLiteral.BAD_LITERAL;
    }

    @NotNull
    public TokenSet getAllLiterals() {
        return OCTokenTypes.ALL_STRINGS;
    }

    @NotNull
    public static OCIntType getType(@NotNull CidrIntType cidrIntType) {
        switch (cidrIntType) {
            case INT: {
                return OCIntType.INT;
            }
            case CHAR: {
                return OCIntType.CHAR;
            }
            case CHAR_CONST: {
                return OCIntType.CHAR_CONST;
            }
            case WCHAR: {
                return OCIntType.WCHAR;
            }
            case WCHAR_CONST: {
                return OCIntType.WCHAR_CONST;
            }
            case CHAR16: {
                return OCIntType.CHAR16;
            }
            case CHAR16_CONST: {
                return OCIntType.CHAR16_CONST;
            }
            case CHAR32: {
                return OCIntType.CHAR32;
            }
            case CHAR32_CONST: {
                return OCIntType.CHAR32_CONST;
            }
        }
        throw new IllegalArgumentException("Unknown type " + cidrIntType);
    }
}

